/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.table.ExternalTableDefn;
import org.apache.druid.catalog.model.table.InputFormats;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.utils.CollectionUtils;

public class InlineTableDefn
extends ExternalTableDefn.FormattedExternalTableDefn {
    public static final String TABLE_TYPE = "inline";
    public static final String DATA_PROPERTY = "data";

    public InlineTableDefn() {
        super("Inline input table", TABLE_TYPE, Collections.singletonList(new ModelProperties.StringListPropertyDefn(DATA_PROPERTY)), Collections.singletonList(INPUT_COLUMN_DEFN), InputFormats.ALL_FORMATS, null);
    }

    @Override
    protected InputSource convertSource(ResolvedTable table) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("type", TABLE_TYPE);
        List<String> dataList = table.stringListProperty(DATA_PROPERTY);
        if (CollectionUtils.isNullOrEmpty(dataList)) {
            throw new IAE("An inline table requires one or more rows of data in the '%s' property", new Object[]{DATA_PROPERTY});
        }
        jsonMap.put(DATA_PROPERTY, CatalogUtils.stringListToLines(dataList));
        return this.convertObject(table.jsonMapper(), jsonMap, InlineInputSource.class);
    }

    @Override
    public ResolvedTable mergeParameters(ResolvedTable spec, Map<String, Object> values) {
        throw new UOE("Inline table does not support parameters", new Object[0]);
    }

    @Override
    public void validate(ResolvedTable table) {
        super.validate(table);
        this.convertSource(table);
    }
}

