/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.catalog.model.ParameterizedDefn;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.table.ExternalTableDefn;
import org.apache.druid.catalog.model.table.InputFormats;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.HttpInputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.utils.CollectionUtils;

public class HttpTableDefn
extends ExternalTableDefn.FormattedExternalTableDefn
implements ParameterizedDefn {
    public static final String TABLE_TYPE = "http";
    public static final String URI_TEMPLATE_PROPERTY = "uriTemplate";
    public static final String USER_PROPERTY = "user";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String PASSWORD_ENV_VAR_PROPERTY = "passwordEnvVar";
    public static final String URIS_PROPERTY = "uris";
    public static final String URIS_PARAMETER = "uris";

    public HttpTableDefn() {
        super("HTTP input table", TABLE_TYPE, Arrays.asList(new ModelProperties.StringListPropertyDefn("uris"), new ModelProperties.StringPropertyDefn(USER_PROPERTY), new ModelProperties.StringPropertyDefn(PASSWORD_PROPERTY), new ModelProperties.StringPropertyDefn(PASSWORD_ENV_VAR_PROPERTY), new ModelProperties.StringPropertyDefn(URI_TEMPLATE_PROPERTY)), Collections.singletonList(INPUT_COLUMN_DEFN), InputFormats.ALL_FORMATS, Collections.singletonList(new ParameterizedDefn.ParameterImpl("uris", String.class)));
    }

    @Override
    public ResolvedTable mergeParameters(ResolvedTable table, Map<String, Object> values) {
        String urisValue = CatalogUtils.safeGet(values, "uris", String.class);
        List<String> uriValues = CatalogUtils.stringToList(urisValue);
        if (CollectionUtils.isNullOrEmpty(uriValues)) {
            throw new IAE("One or more values are required for parameter %s", new Object[]{"uris"});
        }
        String uriTemplate = table.stringProperty(URI_TEMPLATE_PROPERTY);
        if (Strings.isNullOrEmpty((String)uriTemplate)) {
            throw new IAE("Property %s must provide a URI template.", new Object[]{URI_TEMPLATE_PROPERTY});
        }
        Pattern p = Pattern.compile("\\{}");
        Matcher m = p.matcher(uriTemplate);
        if (!m.find()) {
            throw new IAE("Value [%s] for property %s must include a '{}' placeholder.", new Object[]{uriTemplate, URI_TEMPLATE_PROPERTY});
        }
        ArrayList<String> uris = new ArrayList<String>();
        for (String uri : uriValues) {
            uris.add(m.replaceFirst(uri));
        }
        HashMap<String, Object> revisedProps = new HashMap<String, Object>(table.properties());
        revisedProps.remove(URI_TEMPLATE_PROPERTY);
        revisedProps.put("uris", uris);
        return table.withProperties(revisedProps);
    }

    @Override
    protected InputSource convertSource(ResolvedTable table) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("type", TABLE_TYPE);
        jsonMap.put("httpAuthenticationUsername", table.stringProperty(USER_PROPERTY));
        String password = table.stringProperty(PASSWORD_PROPERTY);
        String passwordEnvVar = table.stringProperty(PASSWORD_ENV_VAR_PROPERTY);
        if (password != null && passwordEnvVar != null) {
            throw new ISE("Specify only one of %s or %s", new Object[]{PASSWORD_PROPERTY, PASSWORD_ENV_VAR_PROPERTY});
        }
        if (password != null) {
            jsonMap.put("httpAuthenticationPassword", ImmutableMap.of((Object)"type", (Object)"default", (Object)PASSWORD_PROPERTY, (Object)password));
        } else if (passwordEnvVar != null) {
            jsonMap.put("httpAuthenticationPassword", ImmutableMap.of((Object)"type", (Object)"environment", (Object)"variable", (Object)passwordEnvVar));
        }
        jsonMap.put("uris", HttpTableDefn.convertUriList(table.stringListProperty("uris")));
        return this.convertObject(table.jsonMapper(), jsonMap, HttpInputSource.class);
    }

    public static List<URI> convertUriList(Object value) {
        List list;
        if (value == null) {
            return null;
        }
        try {
            list = (List)value;
        }
        catch (ClassCastException e) {
            throw new IAE("Value [%s] must be a list of strings", new Object[]{value});
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String strValue : list) {
            try {
                uris.add(new URI(strValue));
            }
            catch (URISyntaxException e) {
                throw new IAE(StringUtils.format((String)"Argument [%s] is not a valid URI", (Object[])new Object[]{value}), new Object[0]);
            }
        }
        return uris;
    }

    @Override
    public void validate(ResolvedTable table) {
        super.validate(table);
        if (!table.hasProperty(URI_TEMPLATE_PROPERTY)) {
            this.convertSource(table);
        }
    }
}

