/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import org.apache.druid.catalog.model.ColumnDefn;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.table.AbstractDatasourceDefn;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;

public class DatasourceDefn
extends AbstractDatasourceDefn {
    public static final String TABLE_TYPE = "datasource";

    public DatasourceDefn() {
        super("Datasource", TABLE_TYPE, null, Collections.singletonList(new DatasourceColumnDefn()));
    }

    public static class DatasourceColumnDefn
    extends ColumnDefn {
        public static final String COLUMN_TYPE = "column";

        public DatasourceColumnDefn() {
            super("Column", COLUMN_TYPE, null);
        }

        @Override
        public void validate(ColumnSpec spec, ObjectMapper jsonMapper) {
            super.validate(spec, jsonMapper);
            this.validateScalarColumn(spec);
            if (Columns.isTimeColumn(spec.name()) && spec.sqlType() != null && !"TIMESTAMP".equalsIgnoreCase(spec.sqlType())) {
                throw new IAE(StringUtils.format((String)"%s column must have no SQL type or SQL type %s", (Object[])new Object[]{"__time", "TIMESTAMP"}), new Object[0]);
            }
        }
    }
}

