/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.facade;

import org.apache.druid.catalog.model.ColumnDefn;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.segment.column.ColumnType;

public class ColumnFacade {
    protected final ColumnDefn.ResolvedColumn column;

    public ColumnFacade(ColumnDefn.ResolvedColumn column) {
        this.column = column;
    }

    public ColumnType druidType() {
        String sqlType = this.column.spec().sqlType();
        return sqlType == null ? null : Columns.druidType(sqlType);
    }

    public static class DatasourceColumnFacade
    extends ColumnFacade {
        public DatasourceColumnFacade(ColumnDefn.ResolvedColumn column) {
            super(column);
        }

        @Override
        public ColumnType druidType() {
            if (Columns.isTimeColumn(this.column.spec().name())) {
                return ColumnType.LONG;
            }
            return super.druidType();
        }
    }
}

