/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.catalog.model.table.DatasourceDefn;
import org.apache.druid.catalog.model.table.HttpTableDefn;
import org.apache.druid.catalog.model.table.InlineTableDefn;
import org.apache.druid.catalog.model.table.LocalTableDefn;
import org.apache.druid.java.util.common.IAE;

public class TableDefnRegistry {
    private static final TableDefn[] TABLE_DEFNS = new TableDefn[]{new DatasourceDefn(), new InlineTableDefn(), new HttpTableDefn(), new LocalTableDefn()};
    private final Map<String, TableDefn> defns;
    private final ObjectMapper jsonMapper;

    public TableDefnRegistry(TableDefn[] defns, ObjectMapper jsonMapper) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TableDefn defn : defns) {
            builder.put((Object)defn.typeValue(), (Object)defn);
        }
        this.defns = builder.build();
        this.jsonMapper = jsonMapper;
    }

    public TableDefnRegistry(ObjectMapper jsonMapper) {
        this(TABLE_DEFNS, jsonMapper);
    }

    public TableDefn defnFor(String type) {
        return this.defns.get(type);
    }

    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }

    public ResolvedTable resolve(TableSpec spec) {
        String type = spec.type();
        if (Strings.isNullOrEmpty((String)type)) {
            throw new IAE("The table type is required.", new Object[0]);
        }
        TableDefn defn = this.defns.get(type);
        if (defn == null) {
            throw new IAE("Table type [%s] is not valid.", new Object[]{type});
        }
        return new ResolvedTable(defn, spec, this.jsonMapper);
    }
}

