/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.druid.catalog.model.SchemaRegistry;
import org.apache.druid.catalog.model.table.AbstractDatasourceDefn;
import org.apache.druid.catalog.model.table.ExternalTableDefn;

public class SchemaRegistryImpl
implements SchemaRegistry {
    private String EXTERNAL_RESOURCE = "EXTERNAL";
    private final Map<String, SchemaRegistry.SchemaSpec> builtIns = new HashMap<String, SchemaRegistry.SchemaSpec>();

    public SchemaRegistryImpl() {
        this.register(new SchemaDefnImpl("druid", "DATASOURCE", AbstractDatasourceDefn.tableTypes()));
        this.register(new SchemaDefnImpl("lookups", "CONFIG", null));
        this.register(new SchemaDefnImpl("INFORMATION_SCHEMA", "SYSTEM_TABLE", null));
        this.register(new SchemaDefnImpl("sys", "SYSTEM_TABLE", null));
        this.register(new SchemaDefnImpl("extern", this.EXTERNAL_RESOURCE, ExternalTableDefn.tableTypes()));
        this.register(new SchemaDefnImpl("view", "VIEW", null));
    }

    private void register(SchemaRegistry.SchemaSpec schemaDefn) {
        this.builtIns.put(schemaDefn.name(), schemaDefn);
    }

    @Override
    public SchemaRegistry.SchemaSpec schema(String name) {
        return this.builtIns.get(name);
    }

    @Override
    public Set<String> names() {
        return new TreeSet<String>(this.builtIns.keySet());
    }

    @Override
    public List<SchemaRegistry.SchemaSpec> schemas() {
        ArrayList schemas = Lists.newArrayList(this.builtIns.values());
        Collections.sort(schemas, (s1, s2) -> s1.name().compareTo(s2.name()));
        return schemas;
    }

    public static class SchemaDefnImpl
    implements SchemaRegistry.SchemaSpec {
        private final String name;
        private final String resource;
        private final Set<String> accepts;

        public SchemaDefnImpl(String name, String resource, Set<String> accepts) {
            this.name = name;
            this.resource = resource;
            this.accepts = accepts;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String securityResource() {
            return this.resource;
        }

        @Override
        public boolean writable() {
            return this.accepts != null && !this.accepts.isEmpty();
        }

        @Override
        public boolean accepts(String tableType) {
            if (this.accepts == null) {
                return false;
            }
            return this.accepts.contains(tableType);
        }
    }
}

