/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.ModelProperties;

public class ObjectDefn {
    private final String name;
    private final String typeValue;
    private final Map<String, ModelProperties.PropertyDefn<?>> properties;

    public ObjectDefn(String name, String typeValue, List<ModelProperties.PropertyDefn<?>> fields) {
        this.name = name;
        this.typeValue = typeValue;
        this.properties = ObjectDefn.toPropertyMap(fields);
    }

    protected static Map<String, ModelProperties.PropertyDefn<?>> toPropertyMap(List<ModelProperties.PropertyDefn<?>> props) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (props != null) {
            for (ModelProperties.PropertyDefn<?> prop : props) {
                builder.put((Object)prop.name(), prop);
            }
        }
        return builder.build();
    }

    public String name() {
        return this.name;
    }

    public String typeValue() {
        return this.typeValue;
    }

    public Map<String, ModelProperties.PropertyDefn<?>> properties() {
        return this.properties;
    }

    public ModelProperties.PropertyDefn<?> property(String key) {
        return this.properties.get(key);
    }

    public Map<String, Object> mergeProperties(Map<String, Object> source, Map<String, Object> update) {
        if (update == null) {
            return source;
        }
        if (source == null) {
            return update;
        }
        HashMap<String, Object> merged = new HashMap<String, Object>(source);
        for (Map.Entry<String, Object> entry : update.entrySet()) {
            if (entry.getValue() == null) {
                merged.remove(entry.getKey());
                continue;
            }
            ModelProperties.PropertyDefn<?> propDefn = this.property(entry.getKey());
            Object value = entry.getValue();
            if (propDefn != null) {
                value = propDefn.merge(merged.get(entry.getKey()), entry.getValue());
            }
            merged.put(entry.getKey(), value);
        }
        return merged;
    }

    public void validate(Map<String, Object> spec, ObjectMapper jsonMapper) {
        for (ModelProperties.PropertyDefn<?> propDefn : this.properties.values()) {
            propDefn.validate(spec.get(propDefn.name()), jsonMapper);
        }
    }
}

