/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.joda.time.Period;

public class CatalogUtils {
    public static List<String> columnNames(List<ColumnSpec> columns) {
        return columns.stream().map(col -> col.name()).collect(Collectors.toList());
    }

    public static Granularity asDruidGranularity(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return Granularities.ALL;
        }
        try {
            return new PeriodGranularity(new Period((Object)value), null, null);
        }
        catch (IllegalArgumentException e) {
            throw new IAE(StringUtils.format((String)"%s is an invalid period string", (Object[])new Object[]{value}), new Object[0]);
        }
    }

    public static List<String> stringToList(String value) {
        if (value == null) {
            return null;
        }
        return Arrays.asList(value.split(",\\s*"));
    }

    public static <T> T safeCast(Object value, Class<T> type, String propertyName) {
        if (value == null) {
            return null;
        }
        try {
            return type.cast(value);
        }
        catch (ClassCastException e) {
            throw new IAE("Value [%s] is not valid for property %s, expected type %s", new Object[]{value, propertyName, type.getSimpleName()});
        }
    }

    public static <T> T safeGet(Map<String, Object> map, String propertyName, Class<T> type) {
        return CatalogUtils.safeCast(map.get(propertyName), type, propertyName);
    }

    public static String stringListToLines(List<String> lines) {
        if (lines.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"\n", lines) + "\n";
    }

    public static String toString(Object obj) {
        ObjectMapper jsonMapper = new ObjectMapper();
        try {
            return jsonMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new ISE("Failed to serialize TableDefn", new Object[0]);
        }
    }

    public static <T> List<T> concatLists(@Nullable List<T> base, @Nullable List<T> additions) {
        return Stream.of(base, additions).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

