/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import java.util.function.ObjIntConsumer;
import org.apache.druid.server.metrics.SegmentRowCountDistribution;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SegmentRowCountDistributionTest {
    private SegmentRowCountDistribution rowCountBucket;

    @Before
    public void setUp() {
        this.rowCountBucket = new SegmentRowCountDistribution();
    }

    @Test
    public void test_bucketCountSanity() {
        this.rowCountBucket.forEachDimension((dimension, count) -> Assert.assertEquals((long)0L, (long)count));
        this.rowCountBucket.addTombstoneToDistribution();
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 0));
        this.rowCountBucket.addTombstoneToDistribution();
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(2, 0));
        this.rowCountBucket.removeTombstoneFromDistribution();
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 0));
        this.rowCountBucket.removeTombstoneFromDistribution();
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(0, 0));
        this.rowCountBucket.addRowCountToDistribution(0L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 1));
        this.rowCountBucket.addRowCountToDistribution(0L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(2, 1));
        this.rowCountBucket.removeRowCountFromDistribution(0L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 1));
        this.rowCountBucket.removeRowCountFromDistribution(0L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(0, 1));
        this.rowCountBucket.addRowCountToDistribution(1L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 2));
        this.rowCountBucket.addRowCountToDistribution(10000L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(2, 2));
        this.rowCountBucket.removeRowCountFromDistribution(1L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 2));
        this.rowCountBucket.removeRowCountFromDistribution(10000L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(0, 2));
        this.rowCountBucket.addRowCountToDistribution(10001L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 3));
        this.rowCountBucket.addRowCountToDistribution(2000000L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(2, 3));
        this.rowCountBucket.removeRowCountFromDistribution(10001L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 3));
        this.rowCountBucket.removeRowCountFromDistribution(2000000L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(0, 3));
        this.rowCountBucket.addRowCountToDistribution(2000001L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 4));
        this.rowCountBucket.addRowCountToDistribution(4000000L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(2, 4));
        this.rowCountBucket.removeRowCountFromDistribution(2000001L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 4));
        this.rowCountBucket.removeRowCountFromDistribution(4000000L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(0, 4));
        this.rowCountBucket.addRowCountToDistribution(4000001L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 5));
        this.rowCountBucket.addRowCountToDistribution(6000000L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(2, 5));
        this.rowCountBucket.removeRowCountFromDistribution(4000001L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 5));
        this.rowCountBucket.removeRowCountFromDistribution(6000000L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(0, 5));
        this.rowCountBucket.addRowCountToDistribution(6000001L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 6));
        this.rowCountBucket.addRowCountToDistribution(8000000L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(2, 6));
        this.rowCountBucket.removeRowCountFromDistribution(6000001L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 6));
        this.rowCountBucket.removeRowCountFromDistribution(8000000L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(0, 6));
        this.rowCountBucket.addRowCountToDistribution(8000001L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 7));
        this.rowCountBucket.addRowCountToDistribution(10000000L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(2, 7));
        this.rowCountBucket.removeRowCountFromDistribution(8000001L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 7));
        this.rowCountBucket.removeRowCountFromDistribution(10000000L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(0, 7));
        this.rowCountBucket.addRowCountToDistribution(10000001L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 8));
        this.rowCountBucket.addRowCountToDistribution(Long.MAX_VALUE);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(2, 8));
        this.rowCountBucket.removeRowCountFromDistribution(10000001L);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(1, 8));
        this.rowCountBucket.removeRowCountFromDistribution(Long.MAX_VALUE);
        this.rowCountBucket.forEachDimension((ObjIntConsumer)AssertBucketHasValue.assertExpected(0, 8));
    }

    @Test
    public void test_bucketDimensionFromIndex() {
        Assert.assertEquals((Object)"Tombstone", (Object)SegmentRowCountDistributionTest.getBucketDimensionFromIndex(0));
        Assert.assertEquals((Object)"0", (Object)SegmentRowCountDistributionTest.getBucketDimensionFromIndex(1));
        Assert.assertEquals((Object)"1-10k", (Object)SegmentRowCountDistributionTest.getBucketDimensionFromIndex(2));
        Assert.assertEquals((Object)"10k-2M", (Object)SegmentRowCountDistributionTest.getBucketDimensionFromIndex(3));
        Assert.assertEquals((Object)"2M-4M", (Object)SegmentRowCountDistributionTest.getBucketDimensionFromIndex(4));
        Assert.assertEquals((Object)"4M-6M", (Object)SegmentRowCountDistributionTest.getBucketDimensionFromIndex(5));
        Assert.assertEquals((Object)"6M-8M", (Object)SegmentRowCountDistributionTest.getBucketDimensionFromIndex(6));
        Assert.assertEquals((Object)"8M-10M", (Object)SegmentRowCountDistributionTest.getBucketDimensionFromIndex(7));
        Assert.assertEquals((Object)"10M+", (Object)SegmentRowCountDistributionTest.getBucketDimensionFromIndex(8));
        Assert.assertEquals((Object)"NA", (Object)SegmentRowCountDistributionTest.getBucketDimensionFromIndex(9));
    }

    private static String getBucketDimensionFromIndex(int index) {
        switch (index) {
            case 0: {
                return "Tombstone";
            }
            case 1: {
                return "0";
            }
            case 2: {
                return "1-10k";
            }
            case 3: {
                return "10k-2M";
            }
            case 4: {
                return "2M-4M";
            }
            case 5: {
                return "4M-6M";
            }
            case 6: {
                return "6M-8M";
            }
            case 7: {
                return "8M-10M";
            }
            case 8: {
                return "10M+";
            }
        }
        return "NA";
    }

    private static class AssertBucketHasValue
    implements ObjIntConsumer<String> {
        private final int expectedBucket;
        private final int expectedValue;

        private AssertBucketHasValue(int expectedBucket, int expectedValue) {
            this.expectedBucket = expectedBucket;
            this.expectedValue = expectedValue;
        }

        static AssertBucketHasValue assertExpected(int expectedValue, int expectedBucket) {
            return new AssertBucketHasValue(expectedBucket, expectedValue);
        }

        @Override
        public void accept(String s, int value) {
            if (s.equals(SegmentRowCountDistributionTest.getBucketDimensionFromIndex(this.expectedBucket))) {
                Assert.assertEquals((long)this.expectedValue, (long)value);
            } else {
                Assert.assertEquals((long)0L, (long)value);
            }
        }
    }
}

