/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.client.ServerView;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.druid.server.coordination.DataSegmentChangeHandler;
import org.apache.druid.timeline.DataSegment;

public class TestServerInventoryView
implements ServerInventoryView {
    private static final Logger log = new Logger(TestServerInventoryView.class);
    private final ConcurrentHashMap<String, DruidServer> servers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DataSegmentChangeHandler> segmentChangeHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<ServerView.SegmentCallback, Executor> segmentCallbacks = new ConcurrentHashMap();
    private final List<ServerChangeHandler> serverChangeHandlers = new ArrayList<ServerChangeHandler>();

    public void setUp() {
        this.segmentCallbacks.forEach((segmentCallback, executor) -> executor.execute(() -> ((ServerView.SegmentCallback)segmentCallback).segmentViewInitialized()));
    }

    public void sync(ServerInventoryView other) {
        for (ServerChangeHandler handler : this.serverChangeHandlers) {
            this.servers.values().forEach(x$0 -> handler.removeServer(x$0));
        }
        this.servers.clear();
        this.segmentChangeHandlers.clear();
        for (DruidServer server : other.getInventory()) {
            this.addServer(new DruidServer(server.getName(), server.getHostAndPort(), server.getHostAndTlsPort(), server.getMaxSize(), server.getType(), server.getTier(), server.getPriority()));
            DataSegmentChangeHandler handler = this.getChangeHandlerForHost(server.getName());
            for (DataSegment segment : server.iterateAllSegments()) {
                handler.addSegment(segment, null);
            }
        }
    }

    public void addServer(DruidServer server) {
        this.servers.put(server.getName(), server);
        this.segmentChangeHandlers.put(server.getName(), new SegmentChangeHandler(server));
    }

    public void removeServer(DruidServer server) {
        this.servers.remove(server.getName());
        this.segmentChangeHandlers.remove(server.getName());
        for (ServerChangeHandler handler : this.serverChangeHandlers) {
            handler.removeServer(server);
        }
    }

    public DataSegmentChangeHandler getChangeHandlerForHost(String serverName) {
        return this.segmentChangeHandlers.get(serverName);
    }

    @Nullable
    public DruidServer getInventoryValue(String serverKey) {
        return this.servers.get(serverKey);
    }

    public Collection<DruidServer> getInventory() {
        return Collections.unmodifiableCollection(this.servers.values());
    }

    public boolean isStarted() {
        return true;
    }

    public boolean isSegmentLoadedByServer(String serverKey, DataSegment segment) {
        DruidServer server = this.servers.get(serverKey);
        return server != null && server.getSegment(segment.getId()) != null;
    }

    public void registerServerRemovedCallback(Executor exec, ServerView.ServerRemovedCallback callback) {
        this.serverChangeHandlers.add(new ServerChangeHandler(callback, exec));
    }

    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
        this.segmentCallbacks.put(callback, exec);
    }

    private static class ServerChangeHandler {
        private final Executor executor;
        private final ServerView.ServerRemovedCallback callback;

        private ServerChangeHandler(ServerView.ServerRemovedCallback callback, Executor executor) {
            this.callback = callback;
            this.executor = executor;
        }

        private void removeServer(DruidServer server) {
            this.executor.execute(() -> this.callback.serverRemoved(server));
        }
    }

    private class SegmentChangeHandler
    implements DataSegmentChangeHandler {
        private final DruidServer server;

        private SegmentChangeHandler(DruidServer server) {
            this.server = server;
        }

        public void addSegment(DataSegment segment, @Nullable DataSegmentChangeCallback callback) {
            log.debug("Adding segment [%s] to server [%s]", new Object[]{segment.getId(), this.server.getName()});
            if (this.server.getSegment(segment.getId()) != null) {
                log.debug("Server [%s] already serving segment [%s]", new Object[]{this.server.getName(), segment});
            } else {
                if (this.server.getMaxSize() - this.server.getCurrSize() < segment.getSize()) {
                    throw new ISE("Not enough free space on server %s. Segment size [%d]. Current free space [%d]", new Object[]{this.server.getName(), segment.getSize(), this.server.getMaxSize() - this.server.getCurrSize()});
                }
                this.server.addDataSegment(segment);
                TestServerInventoryView.this.segmentCallbacks.forEach((segmentCallback, executor) -> executor.execute(() -> segmentCallback.segmentAdded(this.server.getMetadata(), segment)));
            }
        }

        public void removeSegment(DataSegment segment, @Nullable DataSegmentChangeCallback callback) {
            log.debug("Removing segment [%s] from server [%s]", new Object[]{segment.getId(), this.server.getName()});
            this.server.removeDataSegment(segment.getId());
            TestServerInventoryView.this.segmentCallbacks.forEach((segmentCallback, executor) -> executor.execute(() -> segmentCallback.segmentRemoved(this.server.getMetadata(), segment)));
        }
    }
}

