/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.List;
import org.apache.druid.client.DruidServer;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulation;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulationBaseTest;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;

public class SegmentLoadingTest
extends CoordinatorSimulationBaseTest {
    private DruidServer historicalT11;
    private DruidServer historicalT12;
    private DruidServer historicalT21;
    private DruidServer historicalT22;
    private final String datasource = "wiki";
    private final List<DataSegment> segments = CoordinatorSimulationBaseTest.Segments.WIKI_10X1D;

    @Override
    public void setUp() {
        this.historicalT11 = SegmentLoadingTest.createHistorical(1, "tier_t1", 10000L);
        this.historicalT12 = SegmentLoadingTest.createHistorical(2, "tier_t1", 10000L);
        this.historicalT21 = SegmentLoadingTest.createHistorical(1, "tier_t2", 10000L);
        this.historicalT22 = SegmentLoadingTest.createHistorical(2, "tier_t2", 10000L);
    }

    @Test
    public void testSecondReplicaOnAnyTierIsThrottled() {
        CoordinatorDynamicConfig dynamicConfig = SegmentLoadingTest.createDynamicConfig(0, 0, 2);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 2).forever()).withDynamicConfig(dynamicConfig).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 2L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)2L, (long)this.historicalT12.getTotalSegments());
    }

    @Test
    public void testLoadingDoesNotOverassignHistorical() {
        DruidServer historicalT11 = SegmentLoadingTest.createHistorical(1, "tier_t1", 1000L);
        CoordinatorDynamicConfig dynamicConfig = SegmentLoadingTest.createDynamicConfig(0, 0, 10);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(historicalT11).withDynamicConfig(dynamicConfig).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withImmediateSegmentLoading(false).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 2L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)2L, (long)historicalT11.getTotalSegments());
    }

    @Test
    public void testDropHappensAfterTargetReplicationOnEveryTier() {
        CoordinatorDynamicConfig dynamicConfig = CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(0).withReplicationThrottleLimit(10).withMaxNonPrimaryReplicantsToLoad(33).build();
        DruidServer historicalT31 = SegmentLoadingTest.createHistorical(1, "tier_t3", 10000L);
        DruidServer historicalT32 = SegmentLoadingTest.createHistorical(2, "tier_t3", 10000L);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withDynamicConfig(dynamicConfig).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t2", 2).andOn("tier_t3", 2).forever()).withServers(this.historicalT11, this.historicalT21, this.historicalT22, historicalT31, historicalT32).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyNotEmitted("segment/dropped/count");
        int totalAssignedInRun1 = this.getValue("segment/assigned/count", SegmentLoadingTest.filter("tier", "tier_t2")).intValue() + this.getValue("segment/assigned/count", SegmentLoadingTest.filter("tier", "tier_t3")).intValue();
        Assert.assertTrue((totalAssignedInRun1 > 0 && totalAssignedInRun1 < 40 ? 1 : 0) != 0);
        this.runCoordinatorCycle();
        this.loadQueuedSegments();
        this.verifyNotEmitted("segment/dropped/count");
        int totalLoadedAfterRun2 = this.historicalT21.getTotalSegments() + this.historicalT22.getTotalSegments() + historicalT31.getTotalSegments() + historicalT32.getTotalSegments();
        Assert.assertEquals((long)totalAssignedInRun1, (long)totalLoadedAfterRun2);
        this.runCoordinatorCycle();
        this.loadQueuedSegments();
        int totalDroppedInRun3 = this.getValue("segment/dropped/count", SegmentLoadingTest.filter("tier", "tier_t1")).intValue();
        Assert.assertTrue((totalDroppedInRun3 > 0 && totalDroppedInRun3 < 10 ? 1 : 0) != 0);
        int totalLoadedAfterRun3 = this.historicalT21.getTotalSegments() + this.historicalT22.getTotalSegments() + historicalT31.getTotalSegments() + historicalT32.getTotalSegments();
        Assert.assertEquals((long)40L, (long)totalLoadedAfterRun3);
        this.runCoordinatorCycle();
        this.loadQueuedSegments();
        int totalDroppedInRun4 = this.getValue("segment/dropped/count", SegmentLoadingTest.filter("tier", "tier_t1")).intValue();
        Assert.assertEquals((long)10L, (long)(totalDroppedInRun3 + totalDroppedInRun4));
        Assert.assertEquals((long)0L, (long)this.historicalT11.getTotalSegments());
        this.verifyDatasourceIsFullyLoaded("wiki");
    }
}

