/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.List;
import org.apache.druid.client.DruidServer;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulation;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulationBaseTest;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;

public class SegmentLoadingNegativeTest
extends CoordinatorSimulationBaseTest {
    private DruidServer historicalT11;
    private DruidServer historicalT12;
    private DruidServer historicalT21;
    private final String datasource = "wiki";
    private final List<DataSegment> segments = CoordinatorSimulationBaseTest.Segments.WIKI_10X1D;

    @Override
    public void setUp() {
        this.historicalT11 = SegmentLoadingNegativeTest.createHistorical(1, "tier_t1", 10000L);
        this.historicalT12 = SegmentLoadingNegativeTest.createHistorical(2, "tier_t1", 10000L);
        this.historicalT21 = SegmentLoadingNegativeTest.createHistorical(1, "tier_t2", 10000L);
    }

    @Test
    public void testImmediateLoadingViolatesThrottleLimit() {
        CoordinatorDynamicConfig dynamicConfig = SegmentLoadingNegativeTest.createDynamicConfig(0, 0, 2);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 2).forever()).withImmediateSegmentLoading(true).withDynamicConfig(dynamicConfig).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 10L);
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)10L, (long)this.historicalT12.getTotalSegments());
        this.verifyDatasourceIsFullyLoaded("wiki");
    }

    @Test
    public void testFirstReplicaOnAnyTierIsThrottled() {
        CoordinatorDynamicConfig dynamicConfig = SegmentLoadingNegativeTest.createDynamicConfig(0, 0, 2);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT21).withDynamicConfig(dynamicConfig).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).andOn("tier_t2", 1).forever()).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", SegmentLoadingNegativeTest.filter("tier", "tier_t2"), 2L);
        this.loadQueuedSegments();
        this.verifyDatasourceIsFullyLoaded("wiki");
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)2L, (long)this.historicalT21.getTotalSegments());
    }

    @Test
    public void testImmediateLoadingOverassignsHistorical() {
        DruidServer historicalT11 = SegmentLoadingNegativeTest.createHistorical(1, "tier_t1", 1000L);
        CoordinatorDynamicConfig dynamicConfig = SegmentLoadingNegativeTest.createDynamicConfig(0, 0, 10);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(historicalT11).withDynamicConfig(dynamicConfig).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withImmediateSegmentLoading(true).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 10L);
        Assert.assertEquals((long)2L, (long)historicalT11.getTotalSegments());
    }

    @Test
    public void testLoadOfFullyReplicatedSegmentIsNotCancelled() {
        CoordinatorDynamicConfig dynamicConfig = SegmentLoadingNegativeTest.createDynamicConfig(0, 0, 10);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withDynamicConfig(dynamicConfig).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 2).forever()).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 10L);
        this.verifyValue("segment/loadQueue/count", SegmentLoadingNegativeTest.filter("server", this.historicalT12.getName()), 10);
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT12).addDataSegment(arg_0));
        this.runCoordinatorCycle();
        this.verifyValue("segment/loadQueue/count", SegmentLoadingNegativeTest.filter("server", this.historicalT12.getName()), 10);
    }
}

