/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.List;
import org.apache.druid.client.DruidServer;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulation;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulationBaseTest;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;

public class SegmentBalancingTest
extends CoordinatorSimulationBaseTest {
    private DruidServer historicalT11;
    private DruidServer historicalT12;
    private final String datasource = "wiki";
    private final List<DataSegment> segments = CoordinatorSimulationBaseTest.Segments.WIKI_10X1D;

    @Override
    public void setUp() {
        this.historicalT11 = SegmentBalancingTest.createHistorical(1, "tier_t1", 10000L);
        this.historicalT12 = SegmentBalancingTest.createHistorical(2, "tier_t1", 10000L);
    }

    @Test
    public void testBalancingDoesNotOverReplicate() {
        this.testBalancingWithAutoSyncInventory(true);
    }

    @Test
    public void testBalancingWithStaleViewDoesNotOverReplicate() {
        this.testBalancingWithAutoSyncInventory(false);
    }

    private void testBalancingWithAutoSyncInventory(boolean autoSyncInventory) {
        CoordinatorDynamicConfig dynamicConfig = SegmentBalancingTest.createDynamicConfig(10, 0, 0);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withDynamicConfig(dynamicConfig).withAutoInventorySync(autoSyncInventory).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        if (!autoSyncInventory) {
            this.syncInventoryView();
        }
        this.runCoordinatorCycle();
        this.verifyValue("segment/moved/count", 5L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)5L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)5L, (long)this.historicalT12.getTotalSegments());
        this.verifyDatasourceIsFullyLoaded("wiki");
    }

    @Test
    public void testDropDoesNotHappenWhenLoadFails() {
        CoordinatorDynamicConfig dynamicConfig = SegmentBalancingTest.createDynamicConfig(10, 0, 0);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withDynamicConfig(dynamicConfig).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/moved/count", 5L);
        this.removeServer(this.historicalT12);
        this.loadQueuedSegments();
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)0L, (long)this.historicalT12.getTotalSegments());
        this.verifyDatasourceIsFullyLoaded("wiki");
    }

    @Test
    public void testBalancingOfFullyReplicatedSegment() {
        CoordinatorDynamicConfig dynamicConfig = SegmentBalancingTest.createDynamicConfig(10, 0, 10);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withDynamicConfig(dynamicConfig).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/moved/count", 5L);
        this.verifyValue("segment/loadQueue/count", SegmentBalancingTest.filter("server", this.historicalT12.getName()), 5);
        this.runCoordinatorCycle();
        this.verifyValue("segment/dropped/count", 0L);
        this.verifyValue("segment/loadQueue/count", SegmentBalancingTest.filter("server", this.historicalT12.getName()), 5);
        this.loadQueuedSegments();
        Assert.assertEquals((long)5L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)5L, (long)this.historicalT12.getTotalSegments());
        this.verifyDatasourceIsFullyLoaded("wiki");
    }
}

