/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.metrics.MetricsVerifier;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulation;
import org.apache.druid.timeline.DataSegment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class CoordinatorSimulationBaseTest
implements CoordinatorSimulation.CoordinatorState,
CoordinatorSimulation.ClusterState,
MetricsVerifier {
    static final double DOUBLE_DELTA = 1.0E-8;
    private CoordinatorSimulation sim;
    private MetricsVerifier metricsVerifier;

    @Before
    public abstract void setUp();

    @After
    public void tearDown() {
        if (this.sim != null) {
            this.sim.stop();
            this.sim = null;
        }
    }

    void startSimulation(CoordinatorSimulation simulation) {
        this.sim = simulation;
        simulation.start();
        this.metricsVerifier = this.sim.coordinator().getMetricsVerifier();
    }

    @Override
    public void runCoordinatorCycle() {
        this.sim.coordinator().runCoordinatorCycle();
    }

    @Override
    public MetricsVerifier getMetricsVerifier() {
        return null;
    }

    @Override
    public DruidServer getInventoryView(String serverName) {
        return this.sim.coordinator().getInventoryView(serverName);
    }

    @Override
    public void syncInventoryView() {
        this.sim.coordinator().syncInventoryView();
    }

    @Override
    public void setDynamicConfig(CoordinatorDynamicConfig dynamicConfig) {
        this.sim.coordinator().setDynamicConfig(dynamicConfig);
    }

    @Override
    public void loadQueuedSegments() {
        this.sim.cluster().loadQueuedSegments();
    }

    @Override
    public void removeServer(DruidServer server) {
        this.sim.cluster().removeServer(server);
    }

    @Override
    public void addServer(DruidServer server) {
        this.sim.cluster().addServer(server);
    }

    @Override
    public void addSegments(List<DataSegment> segments) {
        this.sim.cluster().addSegments(segments);
    }

    @Override
    public double getLoadPercentage(String datasource) {
        return this.sim.coordinator().getLoadPercentage(datasource);
    }

    void verifyDatasourceIsFullyLoaded(String datasource) {
        Assert.assertEquals((double)100.0, (double)this.getLoadPercentage(datasource), (double)1.0E-8);
    }

    public List<Number> getMetricValues(String metricName, Map<String, Object> dimensionFilters) {
        return this.metricsVerifier.getMetricValues(metricName, dimensionFilters);
    }

    static CoordinatorDynamicConfig createDynamicConfig(int maxSegmentsToMove, int maxSegmentsInNodeLoadingQueue, int replicationThrottleLimit) {
        return CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(maxSegmentsToMove).withReplicationThrottleLimit(replicationThrottleLimit).withMaxSegmentsInNodeLoadingQueue(maxSegmentsInNodeLoadingQueue).withUseBatchedSegmentSampler(true).build();
    }

    static Map<String, Object> filter(String ... dimensionValues) {
        if (dimensionValues.length < 2 || dimensionValues.length % 2 == 1) {
            throw new IllegalArgumentException("Dimension key-values must be specified in pairs.");
        }
        HashMap<String, Object> filters = new HashMap<String, Object>();
        for (int i = 0; i < dimensionValues.length; i += 2) {
            filters.put(dimensionValues[i], dimensionValues[i + 1]);
        }
        return filters;
    }

    static DruidServer createHistorical(int uniqueIdInTier, String tier, long serverSizeMb) {
        String name = tier + "__hist__" + uniqueIdInTier;
        return new DruidServer(name, name, name, serverSizeMb, ServerType.HISTORICAL, tier, 1);
    }

    static class Load {
        private final Map<String, Integer> tieredReplicants = new HashMap<String, Integer>();

        Load() {
        }

        static Load on(String tier, int numReplicas) {
            Load load = new Load();
            load.tieredReplicants.put(tier, numReplicas);
            return load;
        }

        Load andOn(String tier, int numReplicas) {
            this.tieredReplicants.put(tier, numReplicas);
            return this;
        }

        Rule forever() {
            return new ForeverLoadRule(this.tieredReplicants);
        }
    }

    static class Segments {
        static final List<DataSegment> WIKI_10X1D = CreateDataSegments.ofDatasource("wiki").forIntervals(1, Granularities.DAY).startingAt("2022-01-01").withNumPartitions(10).eachOfSizeInMb(500L);
        static final List<DataSegment> WIKI_10X100D = CreateDataSegments.ofDatasource("wiki").forIntervals(100, Granularities.DAY).startingAt("2022-01-01").withNumPartitions(10).eachOfSizeInMb(500L);
        static final List<DataSegment> KOALA_100X100D = CreateDataSegments.ofDatasource("koala").forIntervals(100, Granularities.DAY).startingAt("2022-01-01").withNumPartitions(100).eachOfSizeInMb(500L);

        Segments() {
        }
    }

    static class Metric {
        static final String ASSIGNED_COUNT = "segment/assigned/count";
        static final String MOVED_COUNT = "segment/moved/count";
        static final String UNMOVED_COUNT = "segment/unmoved/count";
        static final String DROPPED_COUNT = "segment/dropped/count";
        static final String LOAD_QUEUE_COUNT = "segment/loadQueue/count";

        Metric() {
        }
    }

    static class Tier {
        static final String T1 = "tier_t1";
        static final String T2 = "tier_t2";
        static final String T3 = "tier_t3";

        Tier() {
        }
    }

    static class DS {
        static final String WIKI = "wiki";
        static final String KOALA = "koala";

        DS() {
        }
    }
}

