/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.junit.Assert;
import org.junit.Test;

public class ForeverLoadRuleTest {
    @Test
    public void testSerdeNullTieredReplicants() throws Exception {
        ForeverLoadRule rule = new ForeverLoadRule(null);
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        Rule reread = (Rule)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)rule), Rule.class);
        Assert.assertEquals((Object)rule.getTieredReplicants(), (Object)((ForeverLoadRule)reread).getTieredReplicants());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"_default_tier", (Object)2), (Object)rule.getTieredReplicants());
    }

    @Test
    public void testMappingNullTieredReplicants() throws Exception {
        String inputJson = "{\n \"type\": \"loadForever\"\n}";
        String expectedJson = "    {\n      \"tieredReplicants\": {\n        \"_default_tier\": 2\n      },\n      \"type\": \"loadForever\"\n    }";
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        ForeverLoadRule inputForeverLoadRule = (ForeverLoadRule)jsonMapper.readValue(inputJson, ForeverLoadRule.class);
        ForeverLoadRule expectedForeverLoadRule = (ForeverLoadRule)jsonMapper.readValue(expectedJson, ForeverLoadRule.class);
        Assert.assertEquals((Object)expectedForeverLoadRule.getTieredReplicants(), (Object)inputForeverLoadRule.getTieredReplicants());
    }

    @Test(expected=IAE.class)
    public void testEmptyTieredReplicants() throws Exception {
        ForeverLoadRule rule = new ForeverLoadRule((Map)ImmutableMap.of());
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        Rule reread = (Rule)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)rule), Rule.class);
    }

    @Test(expected=IAE.class)
    public void testEmptyReplicantValue() throws Exception {
        HashMap<String, Object> tieredReplicants = new HashMap<String, Object>();
        tieredReplicants.put("tier", null);
        ForeverLoadRule rule = new ForeverLoadRule(tieredReplicants);
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        Rule reread = (Rule)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)rule), Rule.class);
    }
}

