/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.BalancerSegmentHolder;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.druid.server.coordinator.ReservoirSegmentSampler;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReservoirSegmentSamplerTest {
    private final List<DataSegment> segments = CreateDataSegments.ofDatasource("wiki").forIntervals(100, Granularities.DAY).startingAt("2022-01-01").withNumPartitions(10).eachOfSizeInMb(100L);

    @Before
    public void setUp() {
    }

    @Test
    public void testEverySegmentGetsPickedAtleastOnce() {
        int iterations = 50;
        List<ServerHolder> servers = Arrays.asList(this.createHistorical("server1", this.segments.get(0)), this.createHistorical("server2", this.segments.get(1)), this.createHistorical("server3", this.segments.get(2)), this.createHistorical("server4", this.segments.get(3)));
        HashMap<DataSegment, Integer> segmentCountMap = new HashMap<DataSegment, Integer>();
        for (int i = 0; i < iterations; ++i) {
            segmentCountMap.compute(((BalancerSegmentHolder)ReservoirSegmentSampler.getRandomBalancerSegmentHolders(servers, Collections.emptySet(), (int)1).get(0)).getSegment(), (segment, count) -> count == null ? 1 : count + 1);
        }
        Assert.assertEquals((long)4L, (long)segmentCountMap.size());
    }

    @Test
    public void getRandomBalancerSegmentHolderTestSegmentsToConsiderLimit() {
        int iterations = 50;
        DataSegment excludedSegment = this.segments.get(3);
        List<ServerHolder> servers = Arrays.asList(this.createHistorical("server1", this.segments.get(0)), this.createHistorical("server2", this.segments.get(1)), this.createHistorical("server3", this.segments.get(2)), this.createHistorical("server4", excludedSegment));
        HashMap<DataSegment, Integer> segmentCountMap = new HashMap<DataSegment, Integer>();
        double percentOfSegmentsToConsider = 75.0;
        for (int i = 0; i < iterations; ++i) {
            segmentCountMap.compute(ReservoirSegmentSampler.getRandomBalancerSegmentHolder(servers, Collections.emptySet(), (double)75.0).getSegment(), (segment, count) -> count == null ? 1 : count + 1);
        }
        Assert.assertFalse((boolean)segmentCountMap.containsKey(excludedSegment));
        Assert.assertEquals((long)3L, (long)segmentCountMap.size());
    }

    @Test
    public void testSegmentsOnBrokersAreIgnored() {
        ServerHolder historical = this.createHistorical("hist1", this.segments.get(0), this.segments.get(1));
        ServerHolder broker = new ServerHolder(new DruidServer("broker1", "broker1", null, 1000L, ServerType.BROKER, null, 1).addDataSegment(this.segments.get(2)).addDataSegment(this.segments.get(3)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester());
        List pickedSegments = ReservoirSegmentSampler.getRandomBalancerSegmentHolders(Arrays.asList(historical, broker), Collections.emptySet(), (int)10);
        Assert.assertEquals((long)2L, (long)pickedSegments.size());
        for (BalancerSegmentHolder holder : pickedSegments) {
            Assert.assertEquals((Object)historical.getServer(), (Object)holder.getFromServer());
        }
    }

    @Test
    public void testBroadcastSegmentsAreIgnored() {
        String broadcastDatasource = "ds_broadcast";
        List<DataSegment> broadcastSegments = CreateDataSegments.ofDatasource("ds_broadcast").forIntervals(4, Granularities.DAY).startingAt("2022-01-01").withNumPartitions(1).eachOfSizeInMb(100L);
        List<ServerHolder> servers = Arrays.asList(this.createHistorical("server1", broadcastSegments.toArray(new DataSegment[0])), this.createHistorical("server2", this.segments.get(0), this.segments.get(1)));
        List pickedSegments = ReservoirSegmentSampler.getRandomBalancerSegmentHolders(servers, Collections.singleton("ds_broadcast"), (int)10);
        Assert.assertEquals((long)2L, (long)pickedSegments.size());
        for (BalancerSegmentHolder holder : pickedSegments) {
            Assert.assertNotEquals((Object)"ds_broadcast", (Object)holder.getSegment().getDataSource());
        }
    }

    @Test(timeout=60000L)
    public void testNumberOfIterationsToCycleThroughAllSegments() {
        int[] samplePercentages = new int[]{100, 50, 10, 5, 1};
        int[] expectedIterations = new int[]{1, 20, 100, 200, 1000};
        int[] totalObservedIterations = new int[5];
        for (int i = 0; i < 50; ++i) {
            for (int j = 0; j < samplePercentages.length; ++j) {
                int n = j;
                totalObservedIterations[n] = totalObservedIterations[n] + this.countMinRunsWithSamplePercent(samplePercentages[j]);
            }
        }
        for (int j = 0; j < samplePercentages.length; ++j) {
            double avgObservedIterations = (double)totalObservedIterations[j] / 50.0;
            Assert.assertTrue((avgObservedIterations <= (double)expectedIterations[j] ? 1 : 0) != 0);
        }
    }

    private int countMinRunsWithSamplePercent(int samplePercentage) {
        int numIterations;
        int numSegments = this.segments.size();
        List<ServerHolder> servers = Arrays.asList(this.createHistorical("server1", this.segments.subList(0, numSegments / 2).toArray(new DataSegment[0])), this.createHistorical("server2", this.segments.subList(numSegments / 2, numSegments).toArray(new DataSegment[0])));
        HashSet pickedSegments = new HashSet();
        int sampleSize = (int)((double)(numSegments * samplePercentage) / 100.0);
        for (numIterations = 1; numIterations < 10000; ++numIterations) {
            ReservoirSegmentSampler.getRandomBalancerSegmentHolders(servers, Collections.emptySet(), (int)sampleSize).forEach(holder -> pickedSegments.add(holder.getSegment()));
            if (pickedSegments.size() >= numSegments) break;
        }
        return numIterations;
    }

    private ServerHolder createHistorical(String serverName, DataSegment ... loadedSegments) {
        DruidServer server = new DruidServer(serverName, serverName, null, 100000L, ServerType.HISTORICAL, "normal", 1);
        for (DataSegment segment : loadedSegments) {
            server.addDataSegment(segment);
        }
        return new ServerHolder(server.toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester());
    }
}

