/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class CreateDataSegments {
    private final String datasource;
    private DateTime startTime;
    private Granularity granularity;
    private int numPartitions;
    private int numIntervals;

    public static CreateDataSegments ofDatasource(String datasource) {
        return new CreateDataSegments(datasource);
    }

    private CreateDataSegments(String datasource) {
        this.datasource = datasource;
    }

    public CreateDataSegments forIntervals(int numIntervals, Granularity intervalSize) {
        this.numIntervals = numIntervals;
        this.granularity = intervalSize;
        return this;
    }

    public CreateDataSegments startingAt(String startOfFirstInterval) {
        this.startTime = DateTimes.of((String)startOfFirstInterval);
        return this;
    }

    public CreateDataSegments withNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
        return this;
    }

    public List<DataSegment> eachOfSizeInMb(long sizeMb) {
        ArrayList<NumberedDataSegment> segments = new ArrayList<NumberedDataSegment>();
        int uniqueIdInInterval = 0;
        DateTime nextStart = this.startTime;
        for (int numInterval = 0; numInterval < this.numIntervals; ++numInterval) {
            Interval nextInterval = new Interval((ReadableInstant)nextStart, (ReadableInstant)this.granularity.increment(nextStart));
            for (int numPartition = 0; numPartition < this.numPartitions; ++numPartition) {
                segments.add(new NumberedDataSegment(this.datasource, nextInterval, new NumberedShardSpec(numPartition, this.numPartitions), ++uniqueIdInInterval, sizeMb));
            }
            nextStart = this.granularity.increment(nextStart);
        }
        return Collections.unmodifiableList(segments);
    }

    private static class NumberedDataSegment
    extends DataSegment {
        private final int uniqueId;

        private NumberedDataSegment(String datasource, Interval interval, NumberedShardSpec shardSpec, int uinqueId, long size) {
            super(datasource, interval, "1", Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)shardSpec, Integer.valueOf(9), size);
            this.uniqueId = uinqueId;
        }

        public String toString() {
            return "{" + this.getDataSource() + "::" + this.uniqueId + "}";
        }
    }
}

