/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinatorStatsTest {
    private CoordinatorStats stats;

    @Before
    public void setUp() {
        this.stats = new CoordinatorStats();
    }

    @After
    public void tearDown() {
        this.stats = null;
    }

    @Test
    public void addToGlobalStat() {
        Assert.assertEquals((long)0L, (long)this.stats.getGlobalStat("stats"));
        this.stats.addToGlobalStat("stats", 1L);
        Assert.assertEquals((long)1L, (long)this.stats.getGlobalStat("stats"));
        this.stats.addToGlobalStat("stats", -11L);
        Assert.assertEquals((long)-10L, (long)this.stats.getGlobalStat("stats"));
    }

    @Test(expected=NullPointerException.class)
    public void testAddToTieredStatNonexistentStat() {
        this.stats.getTieredStat("stat", "tier");
    }

    @Test
    public void testAddToTieredStat() {
        Assert.assertFalse((boolean)this.stats.hasPerTierStats());
        this.stats.addToTieredStat("stat1", "tier1", 1L);
        this.stats.addToTieredStat("stat1", "tier2", 1L);
        this.stats.addToTieredStat("stat1", "tier1", -5L);
        this.stats.addToTieredStat("stat2", "tier1", 1L);
        this.stats.addToTieredStat("stat1", "tier2", 1L);
        Assert.assertTrue((boolean)this.stats.hasPerTierStats());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"tier1", "tier2"}), (Object)this.stats.getTiers("stat1"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"tier1"}), (Object)this.stats.getTiers("stat2"));
        Assert.assertTrue((boolean)this.stats.getTiers("stat3").isEmpty());
        Assert.assertEquals((long)-4L, (long)this.stats.getTieredStat("stat1", "tier1"));
        Assert.assertEquals((long)2L, (long)this.stats.getTieredStat("stat1", "tier2"));
        Assert.assertEquals((long)1L, (long)this.stats.getTieredStat("stat2", "tier1"));
    }

    @Test
    public void testForEachTieredStat() {
        ImmutableMap expected = ImmutableMap.of((Object)"tier1", (Object)1L, (Object)"tier2", (Object)2L, (Object)"tier3", (Object)3L);
        HashMap actual = new HashMap();
        expected.forEach((tier, count) -> this.stats.addToTieredStat("stat", tier, count.longValue()));
        this.stats.forEachTieredStat("stat0", (tier, count) -> Assert.fail());
        this.stats.forEachTieredStat("stat", actual::put);
        Assert.assertEquals((Object)expected, actual);
    }

    @Test
    public void testAccumulate() {
        this.stats.addToGlobalStat("stat1", 1L);
        this.stats.addToGlobalStat("stat2", 1L);
        this.stats.addToTieredStat("stat1", "tier1", 1L);
        this.stats.addToTieredStat("stat1", "tier2", 1L);
        this.stats.addToTieredStat("stat2", "tier1", 1L);
        this.stats.addToDutyStat("stat1", "duty1", 1L);
        this.stats.addToDutyStat("stat1", "duty2", 1L);
        this.stats.addToDutyStat("stat2", "duty1", 1L);
        CoordinatorStats stats2 = new CoordinatorStats();
        stats2.addToGlobalStat("stat1", 1L);
        stats2.addToTieredStat("stat1", "tier2", 1L);
        stats2.addToTieredStat("stat2", "tier2", 1L);
        stats2.addToTieredStat("stat3", "tier1", 1L);
        stats2.addToDutyStat("stat1", "duty2", 1L);
        stats2.addToDutyStat("stat2", "duty2", 1L);
        stats2.addToDutyStat("stat3", "duty1", 1L);
        this.stats.accumulate(stats2);
        Assert.assertEquals((long)2L, (long)this.stats.getGlobalStat("stat1"));
        Assert.assertEquals((long)1L, (long)this.stats.getGlobalStat("stat2"));
        Assert.assertEquals((long)1L, (long)this.stats.getTieredStat("stat1", "tier1"));
        Assert.assertEquals((long)2L, (long)this.stats.getTieredStat("stat1", "tier2"));
        Assert.assertEquals((long)1L, (long)this.stats.getTieredStat("stat2", "tier1"));
        Assert.assertEquals((long)1L, (long)this.stats.getTieredStat("stat2", "tier2"));
        Assert.assertEquals((long)1L, (long)this.stats.getTieredStat("stat3", "tier1"));
        Assert.assertEquals((long)1L, (long)this.stats.getDutyStat("stat1", "duty1"));
        Assert.assertEquals((long)2L, (long)this.stats.getDutyStat("stat1", "duty2"));
        Assert.assertEquals((long)1L, (long)this.stats.getDutyStat("stat2", "duty1"));
        Assert.assertEquals((long)1L, (long)this.stats.getDutyStat("stat2", "duty2"));
        Assert.assertEquals((long)1L, (long)this.stats.getDutyStat("stat3", "duty1"));
    }

    @Test
    public void testAccumulateMaxToTieredStat() {
        Assert.assertFalse((boolean)this.stats.hasPerTierStats());
        this.stats.accumulateMaxTieredStat("stat1", "tier1", 2L);
        this.stats.accumulateMaxTieredStat("stat1", "tier1", 6L);
        this.stats.accumulateMaxTieredStat("stat1", "tier1", 5L);
        this.stats.accumulateMaxTieredStat("stat2", "tier1", 5L);
        this.stats.accumulateMaxTieredStat("stat2", "tier1", 4L);
        this.stats.accumulateMaxTieredStat("stat2", "tier1", 5L);
        this.stats.accumulateMaxTieredStat("stat1", "tier2", 7L);
        this.stats.accumulateMaxTieredStat("stat1", "tier2", 9L);
        this.stats.accumulateMaxTieredStat("stat1", "tier2", 10L);
        Assert.assertTrue((boolean)this.stats.hasPerTierStats());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"tier1", "tier2"}), (Object)this.stats.getTiers("stat1"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"tier1"}), (Object)this.stats.getTiers("stat2"));
        Assert.assertTrue((boolean)this.stats.getTiers("stat3").isEmpty());
        Assert.assertEquals((long)6L, (long)this.stats.getTieredStat("stat1", "tier1"));
        Assert.assertEquals((long)5L, (long)this.stats.getTieredStat("stat2", "tier1"));
        Assert.assertEquals((long)10L, (long)this.stats.getTieredStat("stat1", "tier2"));
    }

    @Test(expected=NullPointerException.class)
    public void testGetNonexistentDutyStat() {
        this.stats.getDutyStat("stat", "duty");
    }

    @Test
    public void testAddToDutyStat() {
        Assert.assertFalse((boolean)this.stats.hasPerDutyStats());
        this.stats.addToDutyStat("stat1", "duty1", 1L);
        this.stats.addToDutyStat("stat1", "duty2", 1L);
        this.stats.addToDutyStat("stat1", "duty1", -5L);
        this.stats.addToDutyStat("stat2", "duty1", 1L);
        this.stats.addToDutyStat("stat1", "duty2", 1L);
        Assert.assertTrue((boolean)this.stats.hasPerDutyStats());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"duty1", "duty2"}), (Object)this.stats.getDuties("stat1"));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"duty1"}), (Object)this.stats.getDuties("stat2"));
        Assert.assertTrue((boolean)this.stats.getDuties("stat3").isEmpty());
        Assert.assertEquals((long)-4L, (long)this.stats.getDutyStat("stat1", "duty1"));
        Assert.assertEquals((long)2L, (long)this.stats.getDutyStat("stat1", "duty2"));
        Assert.assertEquals((long)1L, (long)this.stats.getDutyStat("stat2", "duty1"));
    }

    @Test
    public void testForEachDutyStat() {
        ImmutableMap expected = ImmutableMap.of((Object)"duty1", (Object)1L, (Object)"duty2", (Object)2L, (Object)"duty3", (Object)3L);
        HashMap actual = new HashMap();
        expected.forEach((duty, count) -> this.stats.addToDutyStat("stat", duty, count.longValue()));
        this.stats.forEachDutyStat("stat0", (duty, count) -> Assert.fail());
        this.stats.forEachDutyStat("stat", actual::put);
        Assert.assertEquals((Object)expected, actual);
    }
}

