/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ImmutableDruidServerTests;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.BalanceSegmentsTester;
import org.apache.druid.server.coordinator.BalancerSegmentHolder;
import org.apache.druid.server.coordinator.BalancerStrategy;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.CoordinatorRuntimeParamsTestHelpers;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.CostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.DruidClusterBuilder;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadPeonCallback;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BalanceSegmentsTest {
    private static final int MAX_SEGMENTS_TO_MOVE = 5;
    private DruidCoordinator coordinator;
    private ImmutableDruidServer druidServer1;
    private ImmutableDruidServer druidServer2;
    private ImmutableDruidServer druidServer3;
    private ImmutableDruidServer druidServer4;
    private List<ImmutableDruidServer> druidServers;
    private LoadQueuePeonTester peon1;
    private LoadQueuePeonTester peon2;
    private LoadQueuePeonTester peon3;
    private LoadQueuePeonTester peon4;
    private List<LoadQueuePeon> peons;
    private DataSegment segment1;
    private DataSegment segment2;
    private DataSegment segment3;
    private DataSegment segment4;
    private DataSegment segment5;
    private List<DataSegment> segments;
    private ListeningExecutorService balancerStrategyExecutor;
    private BalancerStrategy balancerStrategy;
    private Set<String> broadcastDatasources;

    @Before
    public void setUp() {
        this.coordinator = (DruidCoordinator)EasyMock.createMock(DruidCoordinator.class);
        this.druidServer1 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer2 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer3 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer4 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.segment1 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment2 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment3 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment4 = (DataSegment)EasyMock.createMock(DataSegment.class);
        this.segment5 = (DataSegment)EasyMock.createMock(DataSegment.class);
        DateTime start1 = DateTimes.of((String)"2012-01-01");
        DateTime start2 = DateTimes.of((String)"2012-02-01");
        DateTime version = DateTimes.of((String)"2012-03-01");
        this.segment1 = new DataSegment("datasource1", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 11L);
        this.segment2 = new DataSegment("datasource1", new Interval((ReadableInstant)start2, (ReadableInstant)start2.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 7L);
        this.segment3 = new DataSegment("datasource2", new Interval((ReadableInstant)start1, (ReadableInstant)start1.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 4L);
        this.segment4 = new DataSegment("datasource2", new Interval((ReadableInstant)start2, (ReadableInstant)start2.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 8L);
        this.segment5 = new DataSegment("datasourceBroadcast", new Interval((ReadableInstant)start2, (ReadableInstant)start2.plusHours(1)), version.toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 8L);
        this.segments = new ArrayList<DataSegment>();
        this.segments.add(this.segment1);
        this.segments.add(this.segment2);
        this.segments.add(this.segment3);
        this.segments.add(this.segment4);
        this.segments.add(this.segment5);
        this.peon1 = new LoadQueuePeonTester();
        this.peon2 = new LoadQueuePeonTester();
        this.peon3 = new LoadQueuePeonTester();
        this.peon4 = new LoadQueuePeonTester();
        this.druidServers = ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2, (Object)this.druidServer3, (Object)this.druidServer4);
        this.peons = ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2), (Object)((Object)this.peon3), (Object)((Object)this.peon4));
        this.balancerStrategyExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        this.balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(this.balancerStrategyExecutor);
        this.broadcastDatasources = Collections.singleton("datasourceBroadcast");
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.coordinator});
        EasyMock.verify((Object[])new Object[]{this.druidServer1});
        EasyMock.verify((Object[])new Object[]{this.druidServer2});
        EasyMock.verify((Object[])new Object[]{this.druidServer3});
        EasyMock.verify((Object[])new Object[]{this.druidServer4});
        this.balancerStrategyExecutor.shutdownNow();
    }

    @Test
    public void testMoveToEmptyServerBalancer() {
        BalanceSegmentsTest.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, this.segments);
        BalanceSegmentsTest.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.druidServer3});
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        BalanceSegmentsTest.mockCoordinator(this.coordinator);
        PredefinedPickOrderBalancerStrategy predefinedPickOrderStrategy = new PredefinedPickOrderBalancerStrategy(this.balancerStrategy, (List<BalancerSegmentHolder>)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer1, this.segment1), (Object)new BalancerSegmentHolder(this.druidServer1, this.segment2), (Object)new BalancerSegmentHolder(this.druidServer1, this.segment3), (Object)new BalancerSegmentHolder(this.druidServer1, this.segment4)));
        DruidCoordinatorRuntimeParams params = this.defaultRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2))).withBalancerStrategy((BalancerStrategy)predefinedPickOrderStrategy).withBroadcastDatasources(this.broadcastDatasources).build();
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        Assert.assertEquals((long)3L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
    }

    @Test
    public void testMoveDecommissioningMaxPercentOfMaxSegmentsToMove() {
        BalanceSegmentsTest.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, Arrays.asList(this.segment1, this.segment2));
        BalanceSegmentsTest.mockDruidServer(this.druidServer2, "2", "normal", 30L, 100L, Arrays.asList(this.segment3, this.segment4));
        BalanceSegmentsTest.mockDruidServer(this.druidServer3, "3", "normal", 0L, 100L, Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        BalanceSegmentsTest.mockCoordinator(this.coordinator);
        BalancerStrategy strategy = (BalancerStrategy)EasyMock.createMock(BalancerStrategy.class);
        EasyMock.expect((Object)strategy.pickSegmentsToMove((List)ImmutableList.of((Object)new ServerHolder(this.druidServer2, (LoadQueuePeon)this.peon2, true)), this.broadcastDatasources, 2)).andReturn((Object)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer2, this.segment3), (Object)new BalancerSegmentHolder(this.druidServer2, this.segment4)).iterator());
        EasyMock.expect((Object)strategy.pickSegmentsToMove((List)EasyMock.anyObject(), (Set)EasyMock.anyObject(), EasyMock.anyInt())).andReturn((Object)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer1, this.segment1), (Object)new BalancerSegmentHolder(this.druidServer1, this.segment2)).iterator());
        EasyMock.expect((Object)strategy.findNewSegmentHomeBalancer((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andReturn((Object)new ServerHolder(this.druidServer3, (LoadQueuePeon)this.peon3)).anyTimes();
        EasyMock.replay((Object[])new Object[]{strategy});
        DruidCoordinatorRuntimeParams params = this.defaultRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2, (Object)this.druidServer3), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2), (Object)((Object)this.peon3)), (List<Boolean>)ImmutableList.of((Object)false, (Object)true, (Object)false)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(3).withDecommissioningMaxPercentOfMaxSegmentsToMove(Integer.valueOf(60)).build()).withBalancerStrategy(strategy).withBroadcastDatasources(this.broadcastDatasources).build();
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        EasyMock.verify((Object[])new Object[]{strategy});
        Assert.assertEquals((long)3L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment3, (Object)this.segment4), (Object)this.peon3.getSegmentsToLoad());
    }

    @Test
    public void testZeroDecommissioningMaxPercentOfMaxSegmentsToMove() {
        DruidCoordinatorRuntimeParams params = this.setupParamsForDecommissioningMaxPercentOfMaxSegmentsToMove(0);
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        Assert.assertEquals((long)1L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1), (Object)this.peon3.getSegmentsToLoad());
    }

    @Test
    public void testMaxDecommissioningMaxPercentOfMaxSegmentsToMove() {
        DruidCoordinatorRuntimeParams params = this.setupParamsForDecommissioningMaxPercentOfMaxSegmentsToMove(10);
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        Assert.assertEquals((long)1L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1), (Object)this.peon3.getSegmentsToLoad());
    }

    @Test
    public void testMoveDecommissioningMaxPercentOfMaxSegmentsToMoveWithNoDecommissioning() {
        BalanceSegmentsTest.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, Arrays.asList(this.segment1, this.segment2));
        BalanceSegmentsTest.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Arrays.asList(this.segment3, this.segment4));
        BalanceSegmentsTest.mockDruidServer(this.druidServer3, "3", "normal", 0L, 100L, Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        BalanceSegmentsTest.mockCoordinator(this.coordinator);
        BalancerStrategy strategy = (BalancerStrategy)EasyMock.createMock(BalancerStrategy.class);
        EasyMock.expect((Object)strategy.pickSegmentsToMove((List)EasyMock.anyObject(), (Set)EasyMock.anyObject(), EasyMock.anyInt())).andReturn((Object)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer1, this.segment2), (Object)new BalancerSegmentHolder(this.druidServer2, this.segment3), (Object)new BalancerSegmentHolder(this.druidServer2, this.segment4)).iterator());
        EasyMock.expect((Object)strategy.findNewSegmentHomeBalancer((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andReturn((Object)new ServerHolder(this.druidServer3, (LoadQueuePeon)this.peon3)).anyTimes();
        EasyMock.replay((Object[])new Object[]{strategy});
        DruidCoordinatorRuntimeParams params = this.defaultRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2, (Object)this.druidServer3), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2), (Object)((Object)this.peon3)), (List<Boolean>)ImmutableList.of((Object)false, (Object)false, (Object)false)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(3).withDecommissioningMaxPercentOfMaxSegmentsToMove(Integer.valueOf(9)).build()).withBalancerStrategy(strategy).withBroadcastDatasources(this.broadcastDatasources).build();
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        EasyMock.verify((Object[])new Object[]{strategy});
        Assert.assertEquals((long)3L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment2, (Object)this.segment3, (Object)this.segment4), (Object)this.peon3.getSegmentsToLoad());
    }

    @Test
    public void testMoveToDecommissioningServer() {
        BalanceSegmentsTest.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, this.segments);
        BalanceSegmentsTest.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.druidServer3});
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        BalanceSegmentsTest.mockCoordinator(this.coordinator);
        BalancerStrategy strategy = (BalancerStrategy)EasyMock.createMock(BalancerStrategy.class);
        EasyMock.expect((Object)strategy.pickSegmentsToMove((List)EasyMock.anyObject(), (Set)EasyMock.anyObject(), EasyMock.anyInt())).andReturn((Object)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer1, this.segment1)).iterator()).anyTimes();
        EasyMock.expect((Object)strategy.findNewSegmentHomeBalancer((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andAnswer(() -> {
            List holders = (List)EasyMock.getCurrentArguments()[1];
            return (ServerHolder)holders.get(0);
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{strategy});
        DruidCoordinatorRuntimeParams params = this.defaultRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2)), (List<Boolean>)ImmutableList.of((Object)false, (Object)true)).withBalancerStrategy(strategy).withBroadcastDatasources(this.broadcastDatasources).build();
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        EasyMock.verify((Object[])new Object[]{strategy});
        Assert.assertEquals((long)0L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
    }

    @Test
    public void testMoveFromDecommissioningServer() {
        BalanceSegmentsTest.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, this.segments);
        BalanceSegmentsTest.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.druidServer3});
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        BalanceSegmentsTest.mockCoordinator(this.coordinator);
        ServerHolder holder2 = new ServerHolder(this.druidServer2, (LoadQueuePeon)this.peon2, false);
        BalancerStrategy strategy = (BalancerStrategy)EasyMock.createMock(BalancerStrategy.class);
        EasyMock.expect((Object)strategy.pickSegmentsToMove((List)EasyMock.anyObject(), (Set)EasyMock.anyObject(), EasyMock.anyInt())).andReturn((Object)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer1, this.segment1)).iterator()).once();
        EasyMock.expect((Object)strategy.findNewSegmentHomeBalancer((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andReturn((Object)holder2).once();
        EasyMock.replay((Object[])new Object[]{strategy});
        DruidCoordinatorRuntimeParams params = this.defaultRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2)), (List<Boolean>)ImmutableList.of((Object)true, (Object)false)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(1).build()).withBalancerStrategy(strategy).withBroadcastDatasources(this.broadcastDatasources).build();
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        EasyMock.verify((Object[])new Object[]{strategy});
        Assert.assertEquals((long)1L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
        Assert.assertEquals((long)0L, (long)this.peon1.getNumberOfSegmentsInQueue());
        Assert.assertEquals((long)1L, (long)this.peon2.getNumberOfSegmentsInQueue());
    }

    @Test
    public void testMoveMaxLoadQueueServerBalancer() {
        BalanceSegmentsTest.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, this.segments);
        BalanceSegmentsTest.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.druidServer3});
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        BalanceSegmentsTest.mockCoordinator(this.coordinator);
        PredefinedPickOrderBalancerStrategy predefinedPickOrderStrategy = new PredefinedPickOrderBalancerStrategy(this.balancerStrategy, (List<BalancerSegmentHolder>)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer1, this.segment1), (Object)new BalancerSegmentHolder(this.druidServer1, this.segment2), (Object)new BalancerSegmentHolder(this.druidServer1, this.segment3), (Object)new BalancerSegmentHolder(this.druidServer1, this.segment4)));
        DruidCoordinatorRuntimeParams params = this.defaultRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2))).withBalancerStrategy((BalancerStrategy)predefinedPickOrderStrategy).withBroadcastDatasources(this.broadcastDatasources).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).withMaxSegmentsInNodeLoadingQueue(1).build()).build();
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        Assert.assertEquals((long)1L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
    }

    @Test
    public void testMoveSameSegmentTwice() {
        BalanceSegmentsTest.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, this.segments);
        BalanceSegmentsTest.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.druidServer3});
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        BalanceSegmentsTest.mockCoordinator(this.coordinator);
        PredefinedPickOrderBalancerStrategy predefinedPickOrderStrategy = new PredefinedPickOrderBalancerStrategy(this.balancerStrategy, (List<BalancerSegmentHolder>)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer1, this.segment1)));
        DruidCoordinatorRuntimeParams params = this.defaultRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2))).withBalancerStrategy((BalancerStrategy)predefinedPickOrderStrategy).withBroadcastDatasources(this.broadcastDatasources).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(2).build()).build();
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        Assert.assertEquals((long)1L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
    }

    @Test
    public void testRun1() {
        BalanceSegmentsTest.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, this.segments);
        BalanceSegmentsTest.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.druidServer3});
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        BalanceSegmentsTest.mockCoordinator(this.coordinator);
        DruidCoordinatorRuntimeParams params = this.defaultRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2))).build();
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        Assert.assertTrue((params.getCoordinatorStats().getTieredStat("movedCount", "normal") > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testRun2() {
        BalanceSegmentsTest.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, this.segments);
        BalanceSegmentsTest.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Collections.emptyList());
        BalanceSegmentsTest.mockDruidServer(this.druidServer3, "3", "normal", 0L, 100L, Collections.emptyList());
        BalanceSegmentsTest.mockDruidServer(this.druidServer4, "4", "normal", 0L, 100L, Collections.emptyList());
        BalanceSegmentsTest.mockCoordinator(this.coordinator);
        DruidCoordinatorRuntimeParams params = this.defaultRuntimeParamsBuilder(this.druidServers, this.peons).build();
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        Assert.assertTrue((params.getCoordinatorStats().getTieredStat("movedCount", "normal") > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testThatDynamicConfigIsHonoredWhenPickingSegmentToMove() {
        BalanceSegmentsTest.mockDruidServer(this.druidServer1, "1", "normal", 50L, 100L, Arrays.asList(this.segment1, this.segment2));
        BalanceSegmentsTest.mockDruidServer(this.druidServer2, "2", "normal", 30L, 100L, Arrays.asList(this.segment3, this.segment4));
        BalanceSegmentsTest.mockDruidServer(this.druidServer3, "3", "normal", 0L, 100L, Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        BalanceSegmentsTest.mockCoordinator(this.coordinator);
        BalancerStrategy strategy = (BalancerStrategy)EasyMock.createMock(BalancerStrategy.class);
        EasyMock.expect((Object)strategy.pickSegmentsToMove((List)ImmutableList.of((Object)new ServerHolder(this.druidServer3, (LoadQueuePeon)this.peon3, false), (Object)new ServerHolder(this.druidServer2, (LoadQueuePeon)this.peon2, false), (Object)new ServerHolder(this.druidServer1, (LoadQueuePeon)this.peon1, false)), this.broadcastDatasources, 40.0)).andReturn((Object)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer2, this.segment3)).iterator());
        EasyMock.expect((Object)strategy.findNewSegmentHomeBalancer((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andReturn((Object)new ServerHolder(this.druidServer3, (LoadQueuePeon)this.peon3)).anyTimes();
        EasyMock.replay((Object[])new Object[]{strategy});
        DruidCoordinatorRuntimeParams params = this.defaultRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2, (Object)this.druidServer3), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2), (Object)((Object)this.peon3)), (List<Boolean>)ImmutableList.of((Object)false, (Object)false, (Object)false)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(1).withUseBatchedSegmentSampler(false).withPercentOfSegmentsToConsiderPerMove(40.0).build()).withBalancerStrategy(strategy).withBroadcastDatasources(this.broadcastDatasources).build();
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        EasyMock.verify((Object[])new Object[]{strategy});
        Assert.assertEquals((long)1L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment3), (Object)this.peon3.getSegmentsToLoad());
    }

    @Test
    public void testUseBatchedSegmentSampler() {
        BalanceSegmentsTest.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, this.segments);
        BalanceSegmentsTest.mockDruidServer(this.druidServer2, "2", "normal", 0L, 100L, Collections.emptyList());
        BalanceSegmentsTest.mockDruidServer(this.druidServer3, "3", "normal", 0L, 100L, Collections.emptyList());
        BalanceSegmentsTest.mockDruidServer(this.druidServer4, "4", "normal", 0L, 100L, Collections.emptyList());
        BalanceSegmentsTest.mockCoordinator(this.coordinator);
        DruidCoordinatorRuntimeParams params = this.defaultRuntimeParamsBuilder(this.druidServers, this.peons).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(2).withUseBatchedSegmentSampler(true).build()).withBroadcastDatasources(this.broadcastDatasources).build();
        params = new BalanceSegmentsTester(this.coordinator).run(params);
        Assert.assertEquals((long)2L, (long)params.getCoordinatorStats().getTieredStat("movedCount", "normal"));
    }

    private DruidCoordinatorRuntimeParams.Builder defaultRuntimeParamsBuilder(List<ImmutableDruidServer> druidServers, List<LoadQueuePeon> peons) {
        return this.defaultRuntimeParamsBuilder(druidServers, peons, druidServers.stream().map(s -> false).collect(Collectors.toList()));
    }

    private DruidCoordinatorRuntimeParams.Builder defaultRuntimeParamsBuilder(List<ImmutableDruidServer> druidServers, List<LoadQueuePeon> peons, List<Boolean> decommissioning) {
        return CoordinatorRuntimeParamsTestHelpers.newBuilder().withDruidCluster(DruidClusterBuilder.newBuilder().addTier("normal", (ServerHolder[])IntStream.range(0, druidServers.size()).mapToObj(i -> new ServerHolder((ImmutableDruidServer)druidServers.get(i), (LoadQueuePeon)peons.get(i), ((Boolean)decommissioning.get(i)).booleanValue())).toArray(ServerHolder[]::new)).build()).withLoadManagementPeons(IntStream.range(0, peons.size()).boxed().collect(Collectors.toMap(i -> String.valueOf(i + 1), peons::get))).withUsedSegmentsInTest(this.segments).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(5).build()).withBroadcastDatasources(this.broadcastDatasources).withBalancerStrategy(this.balancerStrategy);
    }

    private static void mockDruidServer(ImmutableDruidServer druidServer, String name, String tier, long currentSize, long maxSize, List<DataSegment> segments) {
        EasyMock.expect((Object)druidServer.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)druidServer.getTier()).andReturn((Object)tier).anyTimes();
        EasyMock.expect((Object)druidServer.getCurrSize()).andReturn((Object)currentSize).atLeastOnce();
        EasyMock.expect((Object)druidServer.getMaxSize()).andReturn((Object)maxSize).atLeastOnce();
        ImmutableDruidServerTests.expectSegments(druidServer, segments);
        EasyMock.expect((Object)druidServer.getHost()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)druidServer.getType()).andReturn((Object)ServerType.HISTORICAL).anyTimes();
        if (!segments.isEmpty()) {
            segments.forEach(s -> EasyMock.expect((Object)druidServer.getSegment(s.getId())).andReturn(s).anyTimes());
        }
        EasyMock.expect((Object)druidServer.getSegment((SegmentId)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{druidServer});
    }

    private static void mockCoordinator(DruidCoordinator coordinator) {
        coordinator.moveSegment((DruidCoordinatorRuntimeParams)EasyMock.anyObject(), (ImmutableDruidServer)EasyMock.anyObject(), (ImmutableDruidServer)EasyMock.anyObject(), (DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{coordinator});
    }

    private DruidCoordinatorRuntimeParams setupParamsForDecommissioningMaxPercentOfMaxSegmentsToMove(int percent) {
        BalanceSegmentsTest.mockDruidServer(this.druidServer1, "1", "normal", 30L, 100L, Arrays.asList(this.segment1, this.segment3));
        BalanceSegmentsTest.mockDruidServer(this.druidServer2, "2", "normal", 30L, 100L, Arrays.asList(this.segment2, this.segment3));
        BalanceSegmentsTest.mockDruidServer(this.druidServer3, "3", "normal", 0L, 100L, Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{this.druidServer4});
        BalanceSegmentsTest.mockCoordinator(this.coordinator);
        BalancerStrategy strategy = (BalancerStrategy)EasyMock.createMock(BalancerStrategy.class);
        EasyMock.expect((Object)strategy.pickSegmentsToMove((List)ImmutableList.of((Object)new ServerHolder(this.druidServer2, (LoadQueuePeon)this.peon2, true)), this.broadcastDatasources, 100.0)).andReturn((Object)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer2, this.segment2)).iterator());
        EasyMock.expect((Object)strategy.pickSegmentsToMove((List)EasyMock.anyObject(), (Set)EasyMock.anyObject(), EasyMock.anyInt())).andReturn((Object)ImmutableList.of((Object)new BalancerSegmentHolder(this.druidServer1, this.segment1)).iterator());
        EasyMock.expect((Object)strategy.findNewSegmentHomeBalancer((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andReturn((Object)new ServerHolder(this.druidServer3, (LoadQueuePeon)this.peon3)).anyTimes();
        EasyMock.replay((Object[])new Object[]{strategy});
        return this.defaultRuntimeParamsBuilder((List<ImmutableDruidServer>)ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2, (Object)this.druidServer3), (List<LoadQueuePeon>)ImmutableList.of((Object)((Object)this.peon1), (Object)((Object)this.peon2), (Object)((Object)this.peon3)), (List<Boolean>)ImmutableList.of((Object)false, (Object)true, (Object)false)).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(1).withDecommissioningMaxPercentOfMaxSegmentsToMove(Integer.valueOf(percent)).build()).withBalancerStrategy(strategy).withBroadcastDatasources(this.broadcastDatasources).build();
    }

    private static class PredefinedPickOrderBalancerStrategy
    implements BalancerStrategy {
        private final BalancerStrategy delegate;
        private final List<BalancerSegmentHolder> pickOrder;
        private final AtomicInteger pickCounter = new AtomicInteger(0);

        PredefinedPickOrderBalancerStrategy(BalancerStrategy delegate, List<BalancerSegmentHolder> pickOrder) {
            this.delegate = delegate;
            this.pickOrder = pickOrder;
        }

        public ServerHolder findNewSegmentHomeBalancer(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
            return this.delegate.findNewSegmentHomeBalancer(proposalSegment, serverHolders);
        }

        public ServerHolder findNewSegmentHomeReplicator(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
            return this.delegate.findNewSegmentHomeReplicator(proposalSegment, serverHolders);
        }

        public Iterator<BalancerSegmentHolder> pickSegmentsToMove(List<ServerHolder> serverHolders, Set<String> broadcastDatasources, int numberOfSegments) {
            return this.pickOrder.iterator();
        }

        public Iterator<BalancerSegmentHolder> pickSegmentsToMove(List<ServerHolder> serverHolders, Set<String> broadcastDatasources, double percentOfSegmentsToConsider) {
            return this.pickOrder.iterator();
        }

        public void emitStats(String tier, CoordinatorStats stats, List<ServerHolder> serverHolderList) {
            this.delegate.emitStats(tier, stats, serverHolderList);
        }
    }
}

