/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.server.coordination.ChangeRequestHistory;
import org.apache.druid.server.coordination.ChangeRequestsSnapshot;
import org.apache.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.druid.server.coordination.SegmentChangeRequestNoop;
import org.junit.Assert;
import org.junit.Test;

public class ChangeRequestHistoryTest {
    @Test
    public void testSimple() throws Exception {
        ChangeRequestHistory history = new ChangeRequestHistory();
        Assert.assertEquals((long)0L, (long)history.getLastCounter().getCounter());
        history.addChangeRequest((Object)new SegmentChangeRequestNoop());
        Assert.assertEquals((long)1L, (long)history.getLastCounter().getCounter());
        ChangeRequestsSnapshot snapshot = (ChangeRequestsSnapshot)history.getRequestsSince(ChangeRequestHistory.Counter.ZERO).get();
        Assert.assertEquals((long)1L, (long)snapshot.getRequests().size());
        Assert.assertEquals((long)1L, (long)snapshot.getCounter().getCounter());
        history.addChangeRequest((Object)new SegmentChangeRequestNoop());
        Assert.assertEquals((long)2L, (long)history.getLastCounter().getCounter());
        snapshot = (ChangeRequestsSnapshot)history.getRequestsSince(snapshot.getCounter()).get();
        Assert.assertEquals((long)1L, (long)snapshot.getRequests().size());
        Assert.assertEquals((long)2L, (long)snapshot.getCounter().getCounter());
        snapshot = (ChangeRequestsSnapshot)history.getRequestsSince(ChangeRequestHistory.Counter.ZERO).get();
        Assert.assertEquals((long)2L, (long)snapshot.getRequests().size());
        Assert.assertEquals((long)2L, (long)snapshot.getCounter().getCounter());
    }

    @Test
    public void testTruncatedHistory() throws Exception {
        ChangeRequestHistory history = new ChangeRequestHistory(2);
        history.addChangeRequest((Object)new SegmentChangeRequestNoop());
        ChangeRequestHistory.Counter one = history.getLastCounter();
        history.addChangeRequest((Object)new SegmentChangeRequestNoop());
        ChangeRequestHistory.Counter two = history.getLastCounter();
        history.addChangeRequest((Object)new SegmentChangeRequestNoop());
        ChangeRequestHistory.Counter three = history.getLastCounter();
        history.addChangeRequest((Object)new SegmentChangeRequestNoop());
        ChangeRequestHistory.Counter four = history.getLastCounter();
        Assert.assertTrue((boolean)((ChangeRequestsSnapshot)history.getRequestsSince(ChangeRequestHistory.Counter.ZERO).get()).isResetCounter());
        Assert.assertTrue((boolean)((ChangeRequestsSnapshot)history.getRequestsSince(one).get()).isResetCounter());
        Assert.assertTrue((boolean)((ChangeRequestsSnapshot)history.getRequestsSince(two).get()).isResetCounter());
        ChangeRequestsSnapshot snapshot = (ChangeRequestsSnapshot)history.getRequestsSince(three).get();
        Assert.assertEquals((long)1L, (long)snapshot.getRequests().size());
        Assert.assertEquals((long)4L, (long)snapshot.getCounter().getCounter());
    }

    @Test
    public void testCounterHashMismatch() throws Exception {
        ChangeRequestHistory history = new ChangeRequestHistory(3);
        Assert.assertTrue((boolean)((ChangeRequestsSnapshot)history.getRequestsSince(new ChangeRequestHistory.Counter(0L, 1234L)).get()).isResetCounter());
        history.addChangeRequest((Object)new SegmentChangeRequestNoop());
        ChangeRequestHistory.Counter one = history.getLastCounter();
        history.addChangeRequest((Object)new SegmentChangeRequestNoop());
        ChangeRequestHistory.Counter two = history.getLastCounter();
        Assert.assertTrue((boolean)((ChangeRequestsSnapshot)history.getRequestsSince(new ChangeRequestHistory.Counter(0L, 1234L)).get()).isResetCounter());
        ChangeRequestsSnapshot snapshot = (ChangeRequestsSnapshot)history.getRequestsSince(one).get();
        Assert.assertEquals((long)1L, (long)snapshot.getRequests().size());
        Assert.assertEquals((long)2L, (long)snapshot.getCounter().getCounter());
        Assert.assertTrue((boolean)((ChangeRequestsSnapshot)history.getRequestsSince(new ChangeRequestHistory.Counter(1L, 1234L)).get()).isResetCounter());
        history.addChangeRequest((Object)new SegmentChangeRequestNoop());
        ChangeRequestHistory.Counter three = history.getLastCounter();
        history.addChangeRequest((Object)new SegmentChangeRequestNoop());
        ChangeRequestHistory.Counter four = history.getLastCounter();
        snapshot = (ChangeRequestsSnapshot)history.getRequestsSince(two).get();
        Assert.assertEquals((long)2L, (long)snapshot.getRequests().size());
        Assert.assertEquals((long)4L, (long)snapshot.getCounter().getCounter());
        Assert.assertTrue((boolean)((ChangeRequestsSnapshot)history.getRequestsSince(new ChangeRequestHistory.Counter(2L, 1234L)).get()).isResetCounter());
    }

    @Test
    public void testCancel() {
        ChangeRequestHistory history = new ChangeRequestHistory();
        ListenableFuture future = history.getRequestsSince(ChangeRequestHistory.Counter.ZERO);
        Assert.assertEquals((long)1L, (long)history.waitingFutures.size());
        final AtomicBoolean callbackExcecuted = new AtomicBoolean(false);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<ChangeRequestsSnapshot<DataSegmentChangeRequest>>(){

            public void onSuccess(ChangeRequestsSnapshot result) {
                callbackExcecuted.set(true);
            }

            public void onFailure(Throwable t) {
                callbackExcecuted.set(true);
            }
        });
        future.cancel(true);
        Assert.assertEquals((long)0L, (long)history.waitingFutures.size());
        Assert.assertFalse((boolean)callbackExcecuted.get());
    }

    @Test
    public void testNonImmediateFuture() throws Exception {
        ChangeRequestHistory history = new ChangeRequestHistory();
        ListenableFuture future = history.getRequestsSince(ChangeRequestHistory.Counter.ZERO);
        Assert.assertFalse((boolean)future.isDone());
        history.addChangeRequest((Object)new SegmentChangeRequestNoop());
        ChangeRequestsSnapshot snapshot = (ChangeRequestsSnapshot)future.get(1L, TimeUnit.MINUTES);
        Assert.assertEquals((long)1L, (long)snapshot.getCounter().getCounter());
        Assert.assertEquals((long)1L, (long)snapshot.getRequests().size());
    }

    @Test
    public void testStop() {
        ChangeRequestHistory history = new ChangeRequestHistory();
        ListenableFuture future = history.getRequestsSince(ChangeRequestHistory.Counter.ZERO);
        Assert.assertEquals((long)1L, (long)history.waitingFutures.size());
        final AtomicBoolean callbackExcecuted = new AtomicBoolean(false);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<ChangeRequestsSnapshot<DataSegmentChangeRequest>>(){

            public void onSuccess(ChangeRequestsSnapshot result) {
                callbackExcecuted.set(true);
            }

            public void onFailure(Throwable t) {
                callbackExcecuted.set(true);
            }
        });
        history.stop();
        history.addChangeRequest((Object)new SegmentChangeRequestNoop());
        Assert.assertEquals((long)0L, (long)history.waitingFutures.size());
        Assert.assertTrue((boolean)callbackExcecuted.get());
        Assert.assertTrue((boolean)future.isDone());
        Throwable thrown = Assert.assertThrows(ExecutionException.class, () -> future.get());
        Assert.assertEquals((Object)"java.lang.IllegalStateException: Server is shutting down.", (Object)thrown.getMessage());
    }
}

