/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.server.SetAndVerifyContextQueryRunner;
import org.apache.druid.server.initialization.ServerConfig;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class SetAndVerifyContextQueryRunnerTest {
    @Test
    public void testTimeoutIsUsedIfTimeoutIsNonZero() throws InterruptedException {
        ScanQuery query = new Druids.ScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.ETERNITY))).context((Map)ImmutableMap.of((Object)"timeout", (Object)1)).build();
        ServerConfig defaultConfig = new ServerConfig();
        QueryRunner mockRunner = (QueryRunner)EasyMock.createMock(QueryRunner.class);
        SetAndVerifyContextQueryRunner queryRunner = new SetAndVerifyContextQueryRunner(defaultConfig, mockRunner);
        Query transformed = queryRunner.withTimeoutAndMaxScatterGatherBytes((Query)query, defaultConfig);
        Thread.sleep(100L);
        Assert.assertTrue((System.currentTimeMillis() > transformed.context().getLong("queryFailTime") ? 1 : 0) != 0);
    }

    @Test
    public void testTimeoutDefaultTooBigAndOverflows() {
        ScanQuery query = new Druids.ScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.ETERNITY))).build();
        ServerConfig defaultConfig = new ServerConfig(){

            public long getDefaultQueryTimeout() {
                return Long.MAX_VALUE;
            }
        };
        QueryRunner mockRunner = (QueryRunner)EasyMock.createMock(QueryRunner.class);
        SetAndVerifyContextQueryRunner queryRunner = new SetAndVerifyContextQueryRunner(defaultConfig, mockRunner);
        Query transformed = queryRunner.withTimeoutAndMaxScatterGatherBytes((Query)query, defaultConfig);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)transformed.context().getLong("queryFailTime"));
    }

    @Test
    public void testTimeoutZeroIsNotImmediateTimeoutDefaultServersideMax() {
        ScanQuery query = new Druids.ScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.ETERNITY))).context((Map)ImmutableMap.of((Object)"timeout", (Object)0)).build();
        ServerConfig defaultConfig = new ServerConfig();
        QueryRunner mockRunner = (QueryRunner)EasyMock.createMock(QueryRunner.class);
        SetAndVerifyContextQueryRunner queryRunner = new SetAndVerifyContextQueryRunner(defaultConfig, mockRunner);
        Query transformed = queryRunner.withTimeoutAndMaxScatterGatherBytes((Query)query, defaultConfig);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)transformed.context().getLong("queryFailTime"));
    }

    @Test
    public void testTimeoutZeroIsNotImmediateTimeoutExplicitServersideMax() {
        ScanQuery query = new Druids.ScanQueryBuilder().dataSource("foo").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.ETERNITY))).context((Map)ImmutableMap.of((Object)"timeout", (Object)0)).build();
        ServerConfig defaultConfig = new ServerConfig(){

            public long getMaxQueryTimeout() {
                return 10000L;
            }
        };
        QueryRunner mockRunner = (QueryRunner)EasyMock.createMock(QueryRunner.class);
        SetAndVerifyContextQueryRunner queryRunner = new SetAndVerifyContextQueryRunner(defaultConfig, mockRunner);
        Query transformed = queryRunner.withTimeoutAndMaxScatterGatherBytes((Query)query, defaultConfig);
        Assert.assertTrue((System.currentTimeMillis() < transformed.context().getLong("queryFailTime") ? 1 : 0) != 0);
    }
}

