/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.UUID;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class RealtimeTuningConfigTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorMessageIsMeaningfulWhenUnableToCreateTemporaryDirectory() {
        String propertyName = "java.io.tmpdir";
        String originalValue = System.getProperty(propertyName);
        String nonExistedDirectory = "/tmp/" + UUID.randomUUID();
        try {
            System.setProperty(propertyName, nonExistedDirectory);
            RealtimeTuningConfig.makeDefaultTuningConfig(null);
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)("java.io.tmpdir (" + nonExistedDirectory + ") does not exist")));
        }
        finally {
            System.setProperty(propertyName, originalValue);
        }
    }

    @Test
    public void testSpecificBasePersistDirectory() {
        RealtimeTuningConfig tuningConfig = RealtimeTuningConfig.makeDefaultTuningConfig((File)new File("/tmp/nonexistent"));
        Assert.assertEquals((Object)new File("/tmp/nonexistent"), (Object)tuningConfig.getBasePersistDirectory());
    }

    @Test
    public void testSerdeWithDefaults() throws Exception {
        String jsonStr = "{\"type\":\"realtime\"}";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        RealtimeTuningConfig config = (RealtimeTuningConfig)mapper.readValue(mapper.writeValueAsString(mapper.readValue(jsonStr, TuningConfig.class)), TuningConfig.class);
        Assert.assertEquals((Object)new OnheapIncrementalIndex.Spec(), (Object)config.getAppendableIndexSpec());
        Assert.assertEquals((long)0L, (long)config.getHandoffConditionTimeout());
        Assert.assertEquals((long)0L, (long)config.getAlertTimeout());
        Assert.assertEquals((Object)new IndexSpec(), (Object)config.getIndexSpec());
        Assert.assertEquals((Object)new IndexSpec(), (Object)config.getIndexSpecForIntermediatePersists());
        Assert.assertEquals((Object)new Period((Object)"PT10M"), (Object)config.getIntermediatePersistPeriod());
        Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)config.getShardSpec());
        Assert.assertEquals((long)0L, (long)config.getMaxPendingPersists());
        Assert.assertEquals((long)1000000L, (long)config.getMaxRowsInMemory());
        Assert.assertEquals((long)0L, (long)config.getMergeThreadPriority());
        Assert.assertEquals((long)0L, (long)config.getPersistThreadPriority());
        Assert.assertEquals((Object)new Period((Object)"PT10M"), (Object)config.getWindowPeriod());
        Assert.assertFalse((boolean)config.isReportParseExceptions());
    }

    @Test
    public void testSerdeWithNonDefaults() throws Exception {
        String jsonStr = "{\n  \"type\": \"realtime\",\n  \"maxRowsInMemory\": 100,\n  \"intermediatePersistPeriod\": \"PT1H\",\n  \"windowPeriod\": \"PT1H\",\n  \"maxPendingPersists\": 100,\n  \"persistThreadPriority\": 100,\n  \"mergeThreadPriority\": 100,\n  \"reportParseExceptions\": true,\n  \"handoffConditionTimeout\": 100,\n  \"alertTimeout\": 70,\n  \"indexSpec\": { \"metricCompression\" : \"NONE\" },\n  \"indexSpecForIntermediatePersists\": { \"dimensionCompression\" : \"uncompressed\" },\n  \"appendableIndexSpec\": { \"type\" : \"onheap\" }\n}";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        RealtimeTuningConfig config = (RealtimeTuningConfig)mapper.readValue(mapper.writeValueAsString(mapper.readValue(jsonStr, TuningConfig.class)), TuningConfig.class);
        Assert.assertEquals((Object)new OnheapIncrementalIndex.Spec(), (Object)config.getAppendableIndexSpec());
        Assert.assertEquals((long)100L, (long)config.getHandoffConditionTimeout());
        Assert.assertEquals((long)70L, (long)config.getAlertTimeout());
        Assert.assertEquals((Object)new Period((Object)"PT1H"), (Object)config.getIntermediatePersistPeriod());
        Assert.assertEquals((Object)new NumberedShardSpec(0, 1), (Object)config.getShardSpec());
        Assert.assertEquals((long)100L, (long)config.getMaxPendingPersists());
        Assert.assertEquals((long)100L, (long)config.getMaxRowsInMemory());
        Assert.assertEquals((long)100L, (long)config.getMergeThreadPriority());
        Assert.assertEquals((long)100L, (long)config.getPersistThreadPriority());
        Assert.assertEquals((Object)new Period((Object)"PT1H"), (Object)config.getWindowPeriod());
        Assert.assertEquals((Object)true, (Object)config.isReportParseExceptions());
        Assert.assertEquals((Object)new IndexSpec(null, null, CompressionStrategy.NONE, null), (Object)config.getIndexSpec());
        Assert.assertEquals((Object)new IndexSpec(null, CompressionStrategy.UNCOMPRESSED, null, null), (Object)config.getIndexSpecForIntermediatePersists());
    }
}

