/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.ObjectOrErrorResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.NoDelayScheduledExecutorService;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.RpcException;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClientImpl;
import org.apache.druid.rpc.ServiceClosedException;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceNotAvailableException;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.stubbing.OngoingStubbing;

public class ServiceClientImplTest {
    private static final String SERVICE_NAME = "test-service";
    private static final ServiceLocation SERVER1 = new ServiceLocation("example.com", -1, 8888, "/q");
    private static final ServiceLocation SERVER2 = new ServiceLocation("example.com", -1, 9999, "/q");
    private static final ServiceLocation SERVER3 = new ServiceLocation("example.com", -1, 1111, "/q");
    private static final ServiceLocation SERVER4 = new ServiceLocation("example.com", -1, 2222, "/q");
    private static final ServiceLocation SERVER5 = new ServiceLocation("example.com", -1, 3333, "/q");
    private ScheduledExecutorService exec;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    private HttpClient httpClient;
    @Mock
    private ServiceLocator serviceLocator;
    private ServiceClient serviceClient;

    @Before
    public void setUp() {
        this.exec = new NoDelayScheduledExecutorService((ExecutorService)Execs.directExecutor());
    }

    @After
    public void tearDown() throws Exception {
        this.exec.shutdownNow();
        if (!this.exec.awaitTermination(30L, TimeUnit.SECONDS)) {
            throw new ISE("Unable to shutdown executor in time", new Object[0]);
        }
    }

    @Test
    public void test_request_ok() throws Exception {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        ImmutableMap expectedResponseObject = ImmutableMap.of((Object)"foo", (Object)"bar");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1, SERVER2));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.valueResponse(expectedResponseObject));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.noRetries());
        Map<String, String> response = ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder);
        Assert.assertEquals((Object)expectedResponseObject, response);
    }

    @Test
    public void test_request_serverError() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1, SERVER2));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.errorResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR, null, "oh no"));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.builder().maxAttempts(2L).build());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(HttpResponseException.class));
        HttpResponseException httpResponseException = (HttpResponseException)e.getCause();
        Assert.assertEquals((Object)HttpResponseStatus.INTERNAL_SERVER_ERROR, (Object)httpResponseException.getResponse().getStatus());
        Assert.assertEquals((Object)"oh no", (Object)httpResponseException.getResponse().getContent());
    }

    @Test
    public void test_request_serverErrorRetry() throws Exception {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        ImmutableMap expectedResponseObject = ImmutableMap.of((Object)"foo", (Object)"bar");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1, SERVER2));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.errorResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR, null, "oh no")).thenReturn(ServiceClientImplTest.valueResponse(expectedResponseObject));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        Map<String, String> response = ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder);
        Assert.assertEquals((Object)expectedResponseObject, response);
    }

    @Test
    public void test_request_ioError() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1, SERVER2));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn((Object)Futures.immediateFailedFuture((Throwable)new IOException("oh no")));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.builder().maxAttempts(2L).build());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Service [test-service] request [GET https://example.com:8888/q/foo] encountered exception on attempt #2")));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(RpcException.class));
        MatcherAssert.assertThat((Object)e.getCause().getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
        MatcherAssert.assertThat((Object)e.getCause().getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"oh no")));
    }

    @Test
    public void test_request_ioErrorRetry() throws Exception {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        ImmutableMap expectedResponseObject = ImmutableMap.of((Object)"foo", (Object)"bar");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1, SERVER2));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn((Object)Futures.immediateFailedFuture((Throwable)new IOException("oh no"))).thenReturn(ServiceClientImplTest.valueResponse(expectedResponseObject));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        Map<String, String> response = ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder);
        Assert.assertEquals((Object)expectedResponseObject, response);
    }

    @Test
    public void test_request_nullResponseFromClient() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1, SERVER2));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn((Object)Futures.immediateFuture(null));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.builder().maxAttempts(2L).build());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(RpcException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Service [test-service] request [GET https://example.com:8888/q/foo] encountered exception on attempt #2")));
    }

    @Test
    public void test_request_nullResponseFromClientRetry() throws Exception {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        ImmutableMap expectedResponseObject = ImmutableMap.of((Object)"foo", (Object)"bar");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1, SERVER2));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn((Object)Futures.immediateFuture(null)).thenReturn(ServiceClientImplTest.valueResponse(expectedResponseObject));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        Map<String, String> response = ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder);
        Assert.assertEquals((Object)expectedResponseObject, response);
    }

    @Test
    public void test_request_followRedirect() throws Exception {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        ImmutableMap expectedResponseObject = ImmutableMap.of((Object)"foo", (Object)"bar");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1, SERVER2));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER2).getUrl().toString()));
        this.expectHttpCall(requestBuilder, SERVER2).thenReturn(ServiceClientImplTest.valueResponse(expectedResponseObject));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.noRetries());
        Map<String, String> response = ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder);
        Assert.assertEquals((Object)expectedResponseObject, response);
    }

    @Test
    public void test_request_tooLongRedirectChain() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1, SERVER2, SERVER3, SERVER4, SERVER5));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER2).getUrl().toString()));
        this.expectHttpCall(requestBuilder, SERVER2).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER3).getUrl().toString()));
        this.expectHttpCall(requestBuilder, SERVER3).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER4).getUrl().toString()));
        this.expectHttpCall(requestBuilder, SERVER4).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER5).getUrl().toString()));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.noRetries());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ServiceNotAvailableException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"issued too many redirects")));
    }

    @Test
    public void test_request_tooLongRedirectChainRetry() throws Exception {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        ImmutableMap expectedResponseObject = ImmutableMap.of((Object)"foo", (Object)"bar");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1, SERVER2, SERVER3, SERVER4, SERVER5));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER2).getUrl().toString()));
        this.expectHttpCall(requestBuilder, SERVER2).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER3).getUrl().toString()));
        this.expectHttpCall(requestBuilder, SERVER3).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER4).getUrl().toString()));
        this.expectHttpCall(requestBuilder, SERVER4).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER5).getUrl().toString()));
        this.expectHttpCall(requestBuilder, SERVER5).thenReturn(ServiceClientImplTest.valueResponse(expectedResponseObject));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.builder().maxAttempts(2L).build());
        Map<String, String> response = ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder);
        Assert.assertEquals((Object)expectedResponseObject, response);
    }

    @Test
    public void test_request_selfRedirectLoop() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER1).getUrl().toString()));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.builder().maxAttempts(10L).build());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ServiceNotAvailableException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"issued too many redirects")));
    }

    @Test
    public void test_request_twoServerRedirectLoop() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1, SERVER2));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER2).getUrl().toString()));
        this.expectHttpCall(requestBuilder, SERVER2).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER1).getUrl().toString()));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.builder().maxAttempts(10L).build());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ServiceNotAvailableException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"issued too many redirects")));
    }

    @Test
    public void test_request_redirectInvalid() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.redirectResponse("invalid-url"));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(RpcException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"redirected to invalid URL [invalid-url]")));
    }

    @Test
    public void test_request_redirectNil() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.errorResponse(HttpResponseStatus.TEMPORARY_REDIRECT, null, null));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(RpcException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"redirected to invalid URL [null]")));
    }

    @Test
    public void test_request_dontFollowRedirectToUnknownServer() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.redirectResponse(requestBuilder.build(SERVER2).getUrl().toString()));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.noRetries());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ServiceNotAvailableException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"issued redirect to unknown URL [https://example.com:9999/q/foo]")));
    }

    @Test
    public void test_request_serviceUnavailable() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceClientImplTest.locations(new ServiceLocation[0]));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.noRetries());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ServiceNotAvailableException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Service [test-service] is not available")));
    }

    @Test
    public void test_request_serviceUnavailableRetry() throws Exception {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        ImmutableMap expectedResponseObject = ImmutableMap.of((Object)"foo", (Object)"bar");
        Mockito.when((Object)this.serviceLocator.locate()).thenReturn((Object)Futures.immediateFuture((Object)ServiceClientImplTest.locations(new ServiceLocation[0]))).thenReturn((Object)Futures.immediateFuture((Object)ServiceClientImplTest.locations(SERVER1)));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.valueResponse(expectedResponseObject));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.builder().maxAttempts(2L).build());
        Map<String, String> response = ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder);
        Assert.assertEquals((Object)expectedResponseObject, response);
    }

    @Test
    public void test_request_serviceUnavailableNoRetry() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceClientImplTest.locations(new ServiceLocation[0]));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.builder().retryNotAvailable(false).maxAttempts(-1L).build());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ServiceNotAvailableException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Service [test-service] is not available")));
    }

    @Test
    public void test_request_serviceClosed() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceLocations.closed());
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(ServiceClosedException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Service [test-service] is closed")));
    }

    @Test
    public void test_request_serviceLocatorException() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall((ListenableFuture<ServiceLocations>)Futures.immediateFailedFuture((Throwable)new ISE("oh no", new Object[0])));
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> ServiceClientImplTest.doRequest(this.serviceClient, requestBuilder));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(RpcException.class));
        MatcherAssert.assertThat((Object)e.getCause().getCause(), (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Service [test-service] locator encountered exception")));
        MatcherAssert.assertThat((Object)e.getCause().getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"oh no")));
    }

    @Test
    public void test_request_cancelBeforeServiceLocated() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall((ListenableFuture<ServiceLocations>)SettableFuture.create());
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        ListenableFuture<Map<String, String>> response = ServiceClientImplTest.doAsyncRequest(this.serviceClient, requestBuilder);
        Assert.assertTrue((boolean)response.cancel(true));
        Assert.assertTrue((boolean)response.isCancelled());
    }

    @Test
    public void test_request_cancelDuringRetry() {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.GET, "/foo");
        this.stubLocatorCall(ServiceClientImplTest.locations(SERVER1, SERVER2));
        this.expectHttpCall(requestBuilder, SERVER1).thenReturn(ServiceClientImplTest.errorResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR, null, "oh no")).thenReturn((Object)SettableFuture.create());
        this.serviceClient = this.makeServiceClient((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        ListenableFuture<Map<String, String>> response = ServiceClientImplTest.doAsyncRequest(this.serviceClient, requestBuilder);
        Assert.assertTrue((boolean)response.cancel(true));
        Assert.assertTrue((boolean)response.isCancelled());
    }

    @Test
    public void test_computeBackoffMs() {
        StandardRetryPolicy retryPolicy = StandardRetryPolicy.unlimited();
        Assert.assertEquals((long)100L, (long)ServiceClientImpl.computeBackoffMs((ServiceRetryPolicy)retryPolicy, (long)0L));
        Assert.assertEquals((long)200L, (long)ServiceClientImpl.computeBackoffMs((ServiceRetryPolicy)retryPolicy, (long)1L));
        Assert.assertEquals((long)3200L, (long)ServiceClientImpl.computeBackoffMs((ServiceRetryPolicy)retryPolicy, (long)5L));
        Assert.assertEquals((long)30000L, (long)ServiceClientImpl.computeBackoffMs((ServiceRetryPolicy)retryPolicy, (long)20L));
    }

    @Test
    public void test_serviceLocationNoPathFromUri() {
        Assert.assertNull((Object)ServiceClientImpl.serviceLocationNoPathFromUri((String)"/"));
        Assert.assertEquals((Object)new ServiceLocation("1.2.3.4", 9999, -1, ""), (Object)ServiceClientImpl.serviceLocationNoPathFromUri((String)"http://1.2.3.4:9999/foo"));
        Assert.assertEquals((Object)new ServiceLocation("1.2.3.4", 80, -1, ""), (Object)ServiceClientImpl.serviceLocationNoPathFromUri((String)"http://1.2.3.4/foo"));
        Assert.assertEquals((Object)new ServiceLocation("1.2.3.4", -1, 9999, ""), (Object)ServiceClientImpl.serviceLocationNoPathFromUri((String)"https://1.2.3.4:9999/foo"));
        Assert.assertEquals((Object)new ServiceLocation("1.2.3.4", -1, 443, ""), (Object)ServiceClientImpl.serviceLocationNoPathFromUri((String)"https://1.2.3.4/foo"));
    }

    @Test
    public void test_isRedirect() {
        Assert.assertTrue((boolean)ServiceClientImpl.isRedirect((HttpResponseStatus)HttpResponseStatus.FOUND));
        Assert.assertTrue((boolean)ServiceClientImpl.isRedirect((HttpResponseStatus)HttpResponseStatus.MOVED_PERMANENTLY));
        Assert.assertTrue((boolean)ServiceClientImpl.isRedirect((HttpResponseStatus)HttpResponseStatus.TEMPORARY_REDIRECT));
        Assert.assertFalse((boolean)ServiceClientImpl.isRedirect((HttpResponseStatus)HttpResponseStatus.OK));
    }

    private <T> OngoingStubbing<ListenableFuture<Either<StringFullResponseHolder, T>>> expectHttpCall(RequestBuilder requestBuilder, ServiceLocation location) {
        Request expectedRequest = requestBuilder.build(location);
        return Mockito.when((Object)this.httpClient.go((Request)ArgumentMatchers.argThat(request -> request != null && expectedRequest.getMethod().equals((Object)request.getMethod()) && expectedRequest.getUrl().equals(request.getUrl())), (HttpResponseHandler)ArgumentMatchers.any(ObjectOrErrorResponseHandler.class), (Duration)ArgumentMatchers.eq((Object)RequestBuilder.DEFAULT_TIMEOUT)));
    }

    private void stubLocatorCall(ServiceLocations locations) {
        this.stubLocatorCall((ListenableFuture<ServiceLocations>)Futures.immediateFuture((Object)locations));
    }

    private void stubLocatorCall(ListenableFuture<ServiceLocations> locations) {
        ((ServiceLocator)Mockito.doReturn(locations).when((Object)this.serviceLocator)).locate();
    }

    private ServiceClient makeServiceClient(ServiceRetryPolicy retryPolicy) {
        return new ServiceClientImpl(SERVICE_NAME, this.httpClient, this.serviceLocator, retryPolicy, this.exec);
    }

    private static Map<String, String> doRequest(ServiceClient serviceClient, RequestBuilder requestBuilder) throws InterruptedException, ExecutionException {
        return (Map)serviceClient.request(requestBuilder, null);
    }

    private static ListenableFuture<Map<String, String>> doAsyncRequest(ServiceClient serviceClient, RequestBuilder requestBuilder) {
        return serviceClient.asyncRequest(requestBuilder, null);
    }

    private static <T> ListenableFuture<Either<StringFullResponseHolder, T>> valueResponse(T o) {
        return Futures.immediateFuture((Object)Either.value(o));
    }

    private static <T> ListenableFuture<Either<StringFullResponseHolder, T>> errorResponse(HttpResponseStatus responseStatus, @Nullable Map<String, String> headers, @Nullable String content) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, responseStatus);
        if (headers != null) {
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                response.headers().add(headerEntry.getKey(), (Object)headerEntry.getValue());
            }
        }
        if (content != null) {
            response.setContent(ChannelBuffers.wrappedBuffer((ByteBuffer)ByteBuffer.wrap(StringUtils.toUtf8((String)content))));
        }
        StringFullResponseHolder errorHolder = new StringFullResponseHolder((HttpResponse)response, StandardCharsets.UTF_8);
        return Futures.immediateFuture((Object)Either.error((Object)errorHolder));
    }

    private static <T> ListenableFuture<Either<StringFullResponseHolder, T>> redirectResponse(String newLocation) {
        return ServiceClientImplTest.errorResponse(HttpResponseStatus.TEMPORARY_REDIRECT, (Map<String, String>)ImmutableMap.of((Object)"location", (Object)newLocation), null);
    }

    private static ServiceLocations locations(ServiceLocation ... locations) {
        return ServiceLocations.forLocations((Set)ImmutableSet.copyOf((Object[])locations));
    }
}

