/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.junit.Assert;

public class MockServiceClient
implements ServiceClient {
    private final Queue<Expectation> expectations = new ArrayDeque<Expectation>(16);

    public <IntermediateType, FinalType> ListenableFuture<FinalType> asyncRequest(RequestBuilder requestBuilder, HttpResponseHandler<IntermediateType, FinalType> handler) {
        Expectation expectation = this.expectations.poll();
        Assert.assertEquals((String)"request", (Object)(expectation == null ? null : expectation.request), (Object)requestBuilder);
        if (expectation.response.isValue()) {
            ClientResponse response = handler.done(handler.handleResponse((HttpResponse)expectation.response.valueOrThrow(), chunkNum -> 0L));
            return Futures.immediateFuture((Object)response.getObj());
        }
        return Futures.immediateFailedFuture((Throwable)((Throwable)expectation.response.error()));
    }

    public ServiceClient withRetryPolicy(ServiceRetryPolicy retryPolicy) {
        return this;
    }

    public MockServiceClient expect(RequestBuilder request, HttpResponse response) {
        this.expectations.add(new Expectation(request, (Either<Throwable, HttpResponse>)Either.value((Object)response)));
        return this;
    }

    public MockServiceClient expect(RequestBuilder request, HttpResponseStatus status, Map<String, String> headers, byte[] content) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            response.headers().set(headerEntry.getKey(), (Object)headerEntry.getValue());
        }
        if (content != null) {
            response.setContent(ChannelBuffers.wrappedBuffer((byte[])content));
        }
        return this.expect(request, (HttpResponse)response);
    }

    public MockServiceClient expect(RequestBuilder request, Throwable e) {
        this.expectations.add(new Expectation(request, (Either<Throwable, HttpResponse>)Either.error((Object)e)));
        return this;
    }

    public void verify() {
        Assert.assertTrue((String)"all requests were made", (boolean)this.expectations.isEmpty());
    }

    private static class Expectation {
        private final RequestBuilder request;
        private final Either<Throwable, HttpResponse> response;

        public Expectation(RequestBuilder request, Either<Throwable, HttpResponse> response) {
            this.request = request;
            this.response = response;
        }

        public String toString() {
            return "Expectation{request=" + this.request + ", response=" + this.response + '}';
        }
    }
}

