/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SQLMetadataSegmentPublisher;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.UnknownSegmentIdsException;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SqlSegmentsMetadataManagerTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private SqlSegmentsMetadataManager sqlSegmentsMetadataManager;
    private SQLMetadataSegmentPublisher publisher;
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
    private final DataSegment segment1 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia", "2012-03-15T00:00:00.000/2012-03-16T00:00:00.000", "2012-03-16T00:36:30.848Z", "index/y=2012/m=03/d=15/2012-03-16T00:36:30.848Z/0/index.zip", 0);
    private final DataSegment segment2 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia", "2012-01-05T00:00:00.000/2012-01-06T00:00:00.000", "2012-01-06T22:19:12.565Z", "wikipedia/index/y=2012/m=01/d=05/2012-01-06T22:19:12.565Z/0/index.zip", 0);

    private static DataSegment createSegment(String dataSource, String interval, String version, String bucketKey, int binaryVersion) {
        return new DataSegment(dataSource, Intervals.of((String)interval), version, (Map)ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)"test", (Object)"key", (Object)(dataSource + "/" + bucketKey)), (List)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3"), (List)ImmutableList.of((Object)"count", (Object)"value"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(binaryVersion), 1234L);
    }

    private void publish(DataSegment segment, boolean used) throws IOException {
        boolean partitioned = !(segment.getShardSpec() instanceof NoneShardSpec);
        this.publisher.publishSegment(segment.getId().toString(), segment.getDataSource(), DateTimes.nowUtc().toString(), segment.getInterval().getStart().toString(), segment.getInterval().getEnd().toString(), partitioned, segment.getVersion(), used, this.jsonMapper.writeValueAsBytes((Object)segment));
    }

    @Before
    public void setUp() throws Exception {
        TestDerbyConnector connector = this.derbyConnectorRule.getConnector();
        SegmentsMetadataManagerConfig config = new SegmentsMetadataManagerConfig();
        config.setPollDuration(Period.seconds((int)3));
        this.sqlSegmentsMetadataManager = new SqlSegmentsMetadataManager(this.jsonMapper, Suppliers.ofInstance((Object)config), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)connector);
        this.sqlSegmentsMetadataManager.start();
        this.publisher = new SQLMetadataSegmentPublisher(this.jsonMapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)connector);
        connector.createSegmentTable();
        this.publisher.publishSegment(this.segment1);
        this.publisher.publishSegment(this.segment2);
    }

    @After
    public void teardown() {
        if (this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically()) {
            this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
        }
        this.sqlSegmentsMetadataManager.stop();
    }

    @Test
    public void testPollPeriodically() {
        DataSourcesSnapshot dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertNull((Object)dataSourcesSnapshot);
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        this.sqlSegmentsMetadataManager.useLatestSnapshotIfWithinDelay();
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.PeriodicDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"wikipedia"), (Object)this.sqlSegmentsMetadataManager.retrieveAllDataSourceNames());
        Assert.assertEquals((Object)ImmutableList.of((Object)"wikipedia"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Collection)dataSourcesSnapshot.getDataSource("wikipedia").getSegments()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot()));
    }

    @Test
    public void testPollOnDemand() {
        DataSourcesSnapshot dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertNull((Object)dataSourcesSnapshot);
        Assert.assertFalse((boolean)this.sqlSegmentsMetadataManager.useLatestSnapshotIfWithinDelay());
        Assert.assertNull((Object)dataSourcesSnapshot);
        this.sqlSegmentsMetadataManager.forceOrWaitOngoingDatabasePoll();
        Assert.assertFalse((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.OnDemandDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"wikipedia"), (Object)this.sqlSegmentsMetadataManager.retrieveAllDataSourceNames());
        Assert.assertEquals((Object)ImmutableList.of((Object)"wikipedia"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Collection)dataSourcesSnapshot.getDataSource("wikipedia").getSegments()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot()));
    }

    @Test(timeout=60000L)
    public void testPollPeriodicallyAndOnDemandInterleave() throws Exception {
        DataSourcesSnapshot dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertNull((Object)dataSourcesSnapshot);
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        this.sqlSegmentsMetadataManager.useLatestSnapshotIfWithinDelay();
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.PeriodicDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableList.of((Object)"wikipedia"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        String newDataSource2 = "wikipedia2";
        DataSegment newSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        this.publisher.publishSegment(newSegment2);
        this.sqlSegmentsMetadataManager.forceOrWaitOngoingDatabasePoll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.OnDemandDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableList.of((Object)"wikipedia2", (Object)"wikipedia"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        String newDataSource3 = "wikipedia3";
        DataSegment newSegment3 = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia3");
        this.publisher.publishSegment(newSegment3);
        while (this.sqlSegmentsMetadataManager.getDataSourcesSnapshot().getDataSource("wikipedia3") == null) {
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.PeriodicDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableList.of((Object)"wikipedia2", (Object)"wikipedia3", (Object)"wikipedia"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
    }

    @Test
    public void testPrepareImmutableDataSourceWithUsedSegmentsAwaitsPollOnRestart() throws IOException {
        DataSegment newSegment = this.pollThenStopThenStartIntro();
        Assert.assertEquals((Object)ImmutableSet.of((Object)newSegment), (Object)ImmutableSet.copyOf((Collection)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments("wikipedia2").getSegments()));
    }

    @Test
    public void testGetDataSourceWithUsedSegmentsAwaitsPollOnRestart() throws IOException {
        DataSegment newSegment = this.pollThenStopThenStartIntro();
        Assert.assertEquals((Object)ImmutableSet.of((Object)newSegment), (Object)ImmutableSet.copyOf((Collection)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments("wikipedia2").getSegments()));
    }

    @Test
    public void testPrepareImmutableDataSourcesWithAllUsedSegmentsAwaitsPollOnRestart() throws IOException {
        DataSegment newSegment = this.pollThenStopThenStartIntro();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment), (Object)ImmutableSet.copyOf(this.sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments().stream().flatMap(dataSource -> dataSource.getSegments().stream()).iterator()));
    }

    @Test
    public void testIterateAllUsedSegmentsAwaitsPollOnRestart() throws IOException {
        DataSegment newSegment = this.pollThenStopThenStartIntro();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    private DataSegment pollThenStopThenStartIntro() throws IOException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
        Assert.assertFalse((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"wikipedia"), (Object)this.sqlSegmentsMetadataManager.retrieveAllDataSourceNames());
        DataSegment newSegment = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        this.publisher.publishSegment(newSegment);
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        return newSegment;
    }

    @Test
    public void testPollWithCorruptedSegment() {
        this.publisher.publishSegment("corrupt-segment-id", "corrupt-datasource", "corrupt-create-date", "corrupt-start-date", "corrupt-end-date", true, "corrupt-version", true, StringUtils.toUtf8((String)"corrupt-payload"));
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertEquals((Object)"wikipedia", (Object)((ImmutableDruidDataSource)Iterables.getOnlyElement((Iterable)this.sqlSegmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments())).getName());
    }

    @Test
    public void testGetUnusedSegmentIntervals() {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        int numChangedSegments = this.sqlSegmentsMetadataManager.markAsUnusedAllSegmentsInDataSource("wikipedia");
        Assert.assertEquals((long)2L, (long)numChangedSegments);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.segment2.getInterval()), (Object)this.sqlSegmentsMetadataManager.getUnusedSegmentIntervals("wikipedia", DateTimes.of((String)"3000"), 1));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.segment2.getInterval()), (Object)this.sqlSegmentsMetadataManager.getUnusedSegmentIntervals("wikipedia", DateTimes.of((int)2012, (int)1, (int)7, (int)0, (int)0), 1));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.segment2.getInterval(), (Object)this.segment1.getInterval()), (Object)this.sqlSegmentsMetadataManager.getUnusedSegmentIntervals("wikipedia", DateTimes.of((String)"3000"), 5));
    }

    @Test(timeout=60000L)
    public void testMarkAsUnusedAllSegmentsInDataSource() throws IOException, InterruptedException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        this.publisher.publishSegment(newSegment);
        this.awaitDataSourceAppeared("wikipedia2");
        int numChangedSegments = this.sqlSegmentsMetadataManager.markAsUnusedAllSegmentsInDataSource("wikipedia2");
        Assert.assertEquals((long)1L, (long)numChangedSegments);
        this.awaitDataSourceDisappeared("wikipedia2");
        Assert.assertNull((Object)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments("wikipedia2"));
    }

    private static DataSegment createNewSegment1(String newDataSource) {
        return SqlSegmentsMetadataManagerTest.createSegment(newDataSource, "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
    }

    private static DataSegment createNewSegment2(String newDataSource) {
        return SqlSegmentsMetadataManagerTest.createSegment(newDataSource, "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
    }

    @Test(timeout=60000L)
    public void testMarkSegmentAsUnused() throws IOException, InterruptedException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment = SqlSegmentsMetadataManagerTest.createSegment("wikipedia2", "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", "2017-10-15T20:19:12.565Z", "wikipedia2/index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        this.publisher.publishSegment(newSegment);
        this.awaitDataSourceAppeared("wikipedia2");
        Assert.assertNotNull((Object)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments("wikipedia2"));
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.markSegmentAsUnused(newSegment.getId()));
        this.awaitDataSourceDisappeared("wikipedia2");
        Assert.assertNull((Object)this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments("wikipedia2"));
    }

    private void awaitDataSourceAppeared(String newDataSource) throws InterruptedException {
        while (this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments(newDataSource) == null) {
            Thread.sleep(1000L);
        }
    }

    private void awaitDataSourceDisappeared(String dataSource) throws InterruptedException {
        while (this.sqlSegmentsMetadataManager.getImmutableDataSourceWithUsedSegments(dataSource) != null) {
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegments() throws Exception {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia2", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        DataSegment newSegment2 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia2", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 1);
        DataSegment newSegment3 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia2", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 1);
        this.publish(newSegment1, false);
        this.publish(newSegment2, false);
        this.publish(newSegment3, false);
        ImmutableSet segmentIds = ImmutableSet.of((Object)newSegment1.getId().toString(), (Object)newSegment2.getId().toString(), (Object)newSegment3.getId().toString());
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)2L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegments("wikipedia2", (Set)segmentIds));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment1, (Object)newSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test(expected=UnknownSegmentIdsException.class)
    public void testMarkAsUsedNonOvershadowedSegmentsInvalidDataSource() throws Exception {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        this.publish(newSegment1, false);
        this.publish(newSegment2, false);
        ImmutableSet segmentIds = ImmutableSet.of((Object)newSegment1.getId().toString(), (Object)newSegment2.getId().toString());
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)0L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegments("wrongDataSource", (Set)segmentIds));
    }

    @Test(expected=UnknownSegmentIdsException.class)
    public void testMarkAsUsedNonOvershadowedSegmentsWithInvalidSegmentIds() throws UnknownSegmentIdsException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        ImmutableSet segmentIds = ImmutableSet.of((Object)newSegment1.getId().toString(), (Object)newSegment2.getId().toString());
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)0L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegments("wikipedia2", (Set)segmentIds));
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsInInterval() throws IOException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia2", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 1);
        DataSegment newSegment3 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia2", "2017-10-19T00:00:00.000/2017-10-20T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        DataSegment newSegment4 = SqlSegmentsMetadataManagerTest.createNewSegment2("wikipedia2");
        this.publish(newSegment1, false);
        this.publish(newSegment2, false);
        this.publish(newSegment3, false);
        this.publish(newSegment4, false);
        Interval theInterval = Intervals.of((String)"2017-10-15T00:00:00.000/2017-10-18T00:00:00.000");
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)2L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval("wikipedia2", theInterval));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment1, (Object)newSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMarkAsUsedNonOvershadowedSegmentsInIntervalWithInvalidInterval() throws IOException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment2("wikipedia2");
        this.publish(newSegment1, false);
        this.publish(newSegment2, false);
        Interval theInterval = Intervals.of((String)"2017-10-22T00:00:00.000/2017-10-02T00:00:00.000");
        this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval("wikipedia2", theInterval);
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsInIntervalWithOverlappingInterval() throws IOException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia2", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        DataSegment newSegment2 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia2", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 1);
        DataSegment newSegment3 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia2", "2017-10-19T00:00:00.000/2017-10-22T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        DataSegment newSegment4 = SqlSegmentsMetadataManagerTest.createNewSegment2("wikipedia2");
        this.publish(newSegment1, false);
        this.publish(newSegment2, false);
        this.publish(newSegment3, false);
        this.publish(newSegment4, false);
        Interval theInterval = Intervals.of((String)"2017-10-16T00:00:00.000/2017-10-20T00:00:00.000");
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
        Assert.assertEquals((long)1L, (long)this.sqlSegmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval("wikipedia2", theInterval));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkSegmentsAsUnused() throws IOException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        this.publisher.publishSegment(newSegment1);
        this.publisher.publishSegment(newSegment2);
        ImmutableSet segmentIds = ImmutableSet.of((Object)newSegment1.getId(), (Object)newSegment1.getId());
        Assert.assertEquals((long)segmentIds.size(), (long)this.sqlSegmentsMetadataManager.markSegmentsAsUnused((Set)segmentIds));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUnusedSegmentsInInterval() throws IOException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment2("wikipedia2");
        DataSegment newSegment3 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia2", "2017-10-19T00:00:00.000/2017-10-20T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        this.publisher.publishSegment(newSegment1);
        this.publisher.publishSegment(newSegment2);
        this.publisher.publishSegment(newSegment3);
        Interval theInterval = Intervals.of((String)"2017-10-15T00:00:00.000/2017-10-18T00:00:00.000");
        Assert.assertEquals((long)2L, (long)this.sqlSegmentsMetadataManager.markAsUnusedSegmentsInInterval("wikipedia2", theInterval));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment3), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMarkAsUnusedSegmentsInIntervalWithInvalidInterval() throws IOException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment2("wikipedia2");
        this.publisher.publishSegment(newSegment1);
        this.publisher.publishSegment(newSegment2);
        Interval theInterval = Intervals.of((String)"2017-10-22T00:00:00.000/2017-10-02T00:00:00.000");
        this.sqlSegmentsMetadataManager.markAsUnusedSegmentsInInterval("wikipedia2", theInterval);
    }

    @Test
    public void testMarkAsUnusedSegmentsInIntervalWithOverlappingInterval() throws IOException {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia2", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        DataSegment newSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment2("wikipedia2");
        DataSegment newSegment3 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia2", "2017-10-19T00:00:00.000/2017-10-22T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        this.publisher.publishSegment(newSegment1);
        this.publisher.publishSegment(newSegment2);
        this.publisher.publishSegment(newSegment3);
        Interval theInterval = Intervals.of((String)"2017-10-16T00:00:00.000/2017-10-20T00:00:00.000");
        Assert.assertEquals((long)1L, (long)this.sqlSegmentsMetadataManager.markAsUnusedSegmentsInInterval("wikipedia2", theInterval));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment1, (Object)newSegment3), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadataManager.iterateAllUsedSegments()));
    }

    @Test
    public void testStopAndStart() {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
    }

    @Test
    public void testIterateAllUsedNonOvershadowedSegmentsForDatasourceInterval() throws Exception {
        Interval theInterval = Intervals.of((String)"2012-03-15T00:00:00.000/2012-03-20T00:00:00.000");
        Optional segments = this.sqlSegmentsMetadataManager.iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval("wikipedia", theInterval, true);
        Assert.assertTrue((boolean)segments.isPresent());
        ImmutableSet dataSegmentSet = ImmutableSet.copyOf((Iterable)((Iterable)segments.get()));
        Assert.assertEquals((long)1L, (long)dataSegmentSet.size());
        Assert.assertTrue((boolean)dataSegmentSet.contains(this.segment1));
        DataSegment newSegment2 = SqlSegmentsMetadataManagerTest.createSegment("wikipedia", "2012-03-16T00:00:00.000/2012-03-17T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        this.publisher.publishSegment(newSegment2);
        segments = this.sqlSegmentsMetadataManager.iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval("wikipedia", theInterval, false);
        Assert.assertTrue((boolean)segments.isPresent());
        dataSegmentSet = ImmutableSet.copyOf((Iterable)((Iterable)segments.get()));
        Assert.assertEquals((long)1L, (long)dataSegmentSet.size());
        Assert.assertTrue((boolean)dataSegmentSet.contains(this.segment1));
        segments = this.sqlSegmentsMetadataManager.iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval("wikipedia", theInterval, true);
        Assert.assertTrue((boolean)segments.isPresent());
        dataSegmentSet = ImmutableSet.copyOf((Iterable)((Iterable)segments.get()));
        Assert.assertEquals((long)2L, (long)dataSegmentSet.size());
        Assert.assertTrue((boolean)dataSegmentSet.contains(this.segment1));
        Assert.assertTrue((boolean)dataSegmentSet.contains(newSegment2));
    }
}

