/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class SegmentPublishResultTest {
    private final ObjectMapper objectMapper = new DefaultObjectMapper().setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT));

    @Test
    public void testSerdeOkResult() throws IOException {
        SegmentPublishResult original = SegmentPublishResult.ok((Set)ImmutableSet.of((Object)SegmentPublishResultTest.segment(Intervals.of((String)"2018/2019")), (Object)SegmentPublishResultTest.segment(Intervals.of((String)"2019/2020"))));
        String json = this.objectMapper.writeValueAsString((Object)original);
        SegmentPublishResult fromJson = (SegmentPublishResult)this.objectMapper.readValue(json, SegmentPublishResult.class);
        Assert.assertEquals((Object)original, (Object)fromJson);
    }

    @Test
    public void testSerdeFailResult() throws IOException {
        SegmentPublishResult original = SegmentPublishResult.fail((String)"test");
        String json = this.objectMapper.writeValueAsString((Object)original);
        SegmentPublishResult fromJson = (SegmentPublishResult)this.objectMapper.readValue(json, SegmentPublishResult.class);
        Assert.assertEquals((Object)original, (Object)fromJson);
    }

    private static DataSegment segment(Interval interval) {
        return new DataSegment("ds", interval, "version", null, null, null, null, Integer.valueOf(9), 10L);
    }
}

