/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.List;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.LocalDataStorageDruidModule;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.loading.OmniDataSegmentKiller;
import org.apache.druid.segment.loading.RandomStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.StorageLocation;
import org.apache.druid.segment.loading.StorageLocationSelectorStrategy;
import org.junit.Assert;
import org.junit.Test;

public class LocalDataStorageDruidModuleTest {
    @Test
    public void testSegmentKillerBoundSingleton() {
        Injector injector = LocalDataStorageDruidModuleTest.createInjector();
        OmniDataSegmentKiller killer = (OmniDataSegmentKiller)injector.getInstance(OmniDataSegmentKiller.class);
        Assert.assertTrue((boolean)killer.getKillers().containsKey("local"));
        Assert.assertSame((Object)((Supplier)killer.getKillers().get("local")).get(), (Object)((Supplier)killer.getKillers().get("local")).get());
    }

    private static Injector createInjector() {
        return GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of((Object)new LocalDataStorageDruidModule(), binder -> {
            binder.bind((TypeLiteral)new TypeLiteral<List<StorageLocation>>(){}).toInstance((Object)ImmutableList.of());
            binder.bind(ColumnConfig.class).toInstance(() -> 0);
            binder.bind(StorageLocationSelectorStrategy.class).toInstance((Object)new RandomStorageLocationSelectorStrategy((List)ImmutableList.of()));
        }));
    }
}

