/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import java.util.Iterator;

public class RangeIterable
implements Iterable<Integer> {
    private final int end;
    private final int start;
    private final int increment;

    public RangeIterable(int end) {
        this(0, end);
    }

    public RangeIterable(int start, int end) {
        this(start, end, 1);
    }

    public RangeIterable(int start, int end, int i) {
        this.start = start;
        this.end = end;
        this.increment = i;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int curr;
            {
                this.curr = RangeIterable.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.curr < RangeIterable.this.end;
            }

            @Override
            public Integer next() {
                try {
                    Integer n = this.curr;
                    return n;
                }
                finally {
                    this.curr += RangeIterable.this.increment;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

