/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.catalog.CatalogTest;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.LocalTableDefn;
import org.apache.druid.catalog.model.table.TableBuilder;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CatalogTest.class})
public class LocalTableTest {
    private final ObjectMapper mapper = new ObjectMapper();
    private final LocalTableDefn tableDefn = new LocalTableDefn();
    private final TableBuilder baseBuilder = TableBuilder.of((TableDefn)this.tableDefn).description("local file input").format("csv").column("x", "VARCHAR").column("y", "BIGINT");

    @Test
    public void testFullyDefined() {
        ResolvedTable table = this.baseBuilder.copy().property("baseDir", (Object)"/tmp").property("fileFilter", (Object)"*.csv").property("files", Collections.singletonList("my.csv")).buildResolved(this.mapper);
        table.validate();
        TableDefnRegistry registry = new TableDefnRegistry(this.mapper);
        Assert.assertNotNull((Object)registry.resolve(table.spec()));
        ExternalTableSpec externSpec = this.tableDefn.convertToExtern(table);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource();
        Assert.assertEquals((Object)"/tmp", (Object)sourceSpec.getBaseDir().toString());
        Assert.assertEquals((Object)"*.csv", (Object)sourceSpec.getFilter());
        Assert.assertEquals((Object)"my.csv", (Object)((File)sourceSpec.getFiles().get(0)).toString());
        CsvInputFormat csvFormat = (CsvInputFormat)externSpec.inputFormat();
        Assert.assertEquals(Arrays.asList("x", "y"), (Object)csvFormat.getColumns());
        RowSignature sig = externSpec.signature();
        Assert.assertEquals(Arrays.asList("x", "y"), (Object)sig.getColumnNames());
        Assert.assertEquals((Object)ColumnType.STRING, sig.getColumnType(0).get());
        Assert.assertEquals((Object)ColumnType.LONG, sig.getColumnType(1).get());
    }

    @Test
    public void testNoFilter() {
        ResolvedTable table = this.baseBuilder.copy().property("baseDir", (Object)"/tmp").property("files", Collections.singletonList("my.csv")).buildResolved(this.mapper);
        table.validate();
        ExternalTableSpec externSpec = this.tableDefn.convertToExtern(table);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource();
        Assert.assertEquals((Object)"/tmp", (Object)sourceSpec.getBaseDir().toString());
        Assert.assertEquals((Object)"*", (Object)sourceSpec.getFilter());
        Assert.assertEquals((Object)"my.csv", (Object)((File)sourceSpec.getFiles().get(0)).toString());
    }

    @Test
    public void testNoFiles() {
        ResolvedTable table = this.baseBuilder.copy().property("baseDir", (Object)"/tmp").property("fileFilter", (Object)"*.csv").buildResolved(this.mapper);
        table.validate();
        ExternalTableSpec externSpec = this.tableDefn.convertToExtern(table);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource();
        Assert.assertEquals((Object)"/tmp", (Object)sourceSpec.getBaseDir().toString());
        Assert.assertEquals((Object)"*.csv", (Object)sourceSpec.getFilter());
        Assert.assertTrue((boolean)sourceSpec.getFiles().isEmpty());
    }

    @Test
    public void testNoFilesOrFlter() {
        ResolvedTable table = this.baseBuilder.copy().property("baseDir", (Object)"/tmp").buildResolved(this.mapper);
        Assert.assertThrows(IAE.class, () -> table.validate());
    }

    @Test
    public void testNoProperties() {
        ResolvedTable table = this.baseBuilder.buildResolved(this.mapper);
        table.validate();
    }

    @Test
    public void testFilesParameter() {
        ResolvedTable table = this.baseBuilder.copy().property("baseDir", (Object)"/tmp").buildResolved(this.mapper);
        LocalTableDefn parameterizedTable = this.tableDefn;
        Assert.assertEquals((long)2L, (long)parameterizedTable.parameters().size());
        Assert.assertNotNull((Object)parameterizedTable.parameter("fileFilter"));
        Assert.assertNotNull((Object)parameterizedTable.parameter("files"));
        ImmutableMap params = ImmutableMap.of((Object)"files", (Object)"foo.csv,bar.csv");
        ExternalTableSpec externSpec = parameterizedTable.applyParameters(table, (Map)params);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource();
        Assert.assertEquals((Object)"/tmp", (Object)sourceSpec.getBaseDir().toString());
        Assert.assertEquals((Object)"*", (Object)sourceSpec.getFilter());
        Assert.assertEquals(Arrays.asList(new File("foo.csv"), new File("bar.csv")), (Object)sourceSpec.getFiles());
    }

    @Test
    public void testFilterParameter() {
        ResolvedTable table = this.baseBuilder.copy().property("baseDir", (Object)"/tmp").buildResolved(this.mapper);
        ImmutableMap params = ImmutableMap.of((Object)"fileFilter", (Object)"Oct*.csv");
        ExternalTableSpec externSpec = this.tableDefn.applyParameters(table, (Map)params);
        LocalInputSource sourceSpec = (LocalInputSource)externSpec.inputSource();
        Assert.assertEquals((Object)"/tmp", (Object)sourceSpec.getBaseDir().toString());
        Assert.assertEquals((Object)"Oct*.csv", (Object)sourceSpec.getFilter());
        Assert.assertTrue((boolean)sourceSpec.getFiles().isEmpty());
    }
}

