/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.CatalogTest;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.catalog.model.table.InputFormats;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.DelimitedInputFormat;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CatalogTest.class})
public class InputFormatTest {
    private final ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testCsvFormat() {
        InputFormats.InputFormatDefn converter = InputFormats.CSV_FORMAT_DEFN;
        List<ColumnSpec> cols = Arrays.asList(new ColumnSpec("type", "x", "VARCHAR", null), new ColumnSpec("type", "y", "BIGINT", null));
        ImmutableMap args = ImmutableMap.of((Object)"listDelimiter", (Object)"|", (Object)"skipRows", (Object)1);
        TableSpec spec = new TableSpec("type", (Map)args, cols);
        ResolvedTable table = new ResolvedTable(null, spec, this.mapper);
        CsvInputFormat expectedFormat = new CsvInputFormat(Arrays.asList("x", "y"), "|", Boolean.valueOf(false), Boolean.valueOf(false), 1);
        InputFormat inputFormat = converter.convert(table);
        Assert.assertEquals((Object)expectedFormat, (Object)inputFormat);
        args = ImmutableMap.of();
        spec = new TableSpec("type", (Map)args, cols);
        table = new ResolvedTable(null, spec, this.mapper);
        expectedFormat = new CsvInputFormat(Arrays.asList("x", "y"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0);
        inputFormat = converter.convert(table);
        Assert.assertEquals((Object)expectedFormat, (Object)inputFormat);
        args = ImmutableMap.of((Object)"skipRows", (Object)"bogus");
        spec = new TableSpec("type", (Map)args, cols);
        table = new ResolvedTable(null, spec, this.mapper);
        Assert.assertThrows(Exception.class, () -> converter.convert(table));
        args = ImmutableMap.of((Object)"skipRows", (Object)1);
        spec = new TableSpec("type", (Map)args, null);
        table = new ResolvedTable(null, spec, this.mapper);
        Assert.assertThrows(Exception.class, () -> converter.convert(table));
    }

    @Test
    public void testDelimitedTextFormat() {
        InputFormats.InputFormatDefn converter = InputFormats.DELIMITED_FORMAT_DEFN;
        List<ColumnSpec> cols = Arrays.asList(new ColumnSpec("type", "x", "VARCHAR", null), new ColumnSpec("type", "y", "BIGINT", null));
        ImmutableMap args = ImmutableMap.of((Object)"delimiter", (Object)",", (Object)"listDelimiter", (Object)"|", (Object)"skipRows", (Object)1);
        TableSpec spec = new TableSpec("type", (Map)args, cols);
        ResolvedTable table = new ResolvedTable(null, spec, this.mapper);
        DelimitedInputFormat expectedFormat = new DelimitedInputFormat(Arrays.asList("x", "y"), "|", ",", Boolean.valueOf(false), Boolean.valueOf(false), 1);
        InputFormat inputFormat = converter.convert(table);
        Assert.assertEquals((Object)expectedFormat, (Object)inputFormat);
    }

    @Test
    public void testJsonFormat() {
        InputFormats.InputFormatDefn converter = InputFormats.JSON_FORMAT_DEFN;
        List<ColumnSpec> cols = Arrays.asList(new ColumnSpec("type", "x", "VARCHAR", null), new ColumnSpec("type", "y", "BIGINT", null));
        ImmutableMap args = ImmutableMap.of((Object)"keepNulls", (Object)true);
        TableSpec spec = new TableSpec("type", (Map)args, cols);
        ResolvedTable table = new ResolvedTable(null, spec, this.mapper);
        InputFormat inputFormat = converter.convert(table);
        Assert.assertEquals((Object)new JsonInputFormat(null, null, Boolean.valueOf(true), null, null), (Object)inputFormat);
        TableSpec spec2 = new TableSpec("type", null, cols);
        ResolvedTable table2 = new ResolvedTable(null, spec2, this.mapper);
        InputFormat inputFormat2 = converter.convert(table2);
        Assert.assertEquals((Object)new JsonInputFormat(null, null, null, null, null), (Object)inputFormat2);
    }

    @Test
    public void testGenericFormat() {
        InputFormats.GenericFormatDefn converter = InputFormats.GENERIC_FORMAT_DEFN;
        List<ColumnSpec> cols = Arrays.asList(new ColumnSpec("type", "x", "VARCHAR", null), new ColumnSpec("type", "y", "BIGINT", null));
        ImmutableMap args = ImmutableMap.of((Object)"skipRows", (Object)1);
        TableSpec spec = new TableSpec("type", (Map)args, null);
        ResolvedTable table = new ResolvedTable(null, spec, this.mapper);
        Assert.assertThrows(Exception.class, () -> InputFormatTest.lambda$testGenericFormat$2((InputFormats.InputFormatDefn)converter, table));
        args = ImmutableMap.of((Object)"inputFormatSpec", (Object)ImmutableMap.of((Object)"type", (Object)"csv", (Object)"listDelimiter", (Object)"|", (Object)"skipHeaderRows", (Object)1, (Object)"findColumnsFromHeader", (Object)false, (Object)"columns", Arrays.asList("x", "y")));
        spec = new TableSpec("type", (Map)args, cols);
        table = new ResolvedTable(null, spec, this.mapper);
        CsvInputFormat expectedFormat = new CsvInputFormat(Arrays.asList("x", "y"), "|", Boolean.valueOf(false), Boolean.valueOf(false), 1);
        InputFormat inputFormat = converter.convert(table);
        Assert.assertEquals((Object)expectedFormat, (Object)inputFormat);
        args = ImmutableMap.of((Object)"type", (Object)"csv", (Object)"skipRows", (Object)1);
        spec = new TableSpec("type", (Map)args, cols);
        table = new ResolvedTable(null, spec, this.mapper);
        Assert.assertThrows(Exception.class, () -> InputFormatTest.lambda$testGenericFormat$3((InputFormats.InputFormatDefn)converter, table));
        args = ImmutableMap.of((Object)"inputFormatSpec", (Object)ImmutableMap.builder().put((Object)"type", (Object)"tsv").put((Object)"delimiter", (Object)",").put((Object)"listDelimiter", (Object)"|").put((Object)"skipHeaderRows", (Object)1).put((Object)"findColumnsFromHeader", (Object)false).put((Object)"columns", Arrays.asList("x", "y")).build());
        spec = new TableSpec("type", (Map)args, cols);
        table = new ResolvedTable(null, spec, this.mapper);
        expectedFormat = new DelimitedInputFormat(Arrays.asList("x", "y"), "|", ",", Boolean.valueOf(false), Boolean.valueOf(false), 1);
        inputFormat = converter.convert(table);
        Assert.assertEquals((Object)expectedFormat, (Object)inputFormat);
        args = ImmutableMap.of((Object)"inputFormatSpec", (Object)ImmutableMap.of((Object)"type", (Object)"json", (Object)"keepNullColumns", (Object)true));
        spec = new TableSpec("type", (Map)args, cols);
        table = new ResolvedTable(null, spec, this.mapper);
        InputFormat inputFormat2 = converter.convert(table);
        Assert.assertEquals((Object)new JsonInputFormat(null, null, Boolean.valueOf(true), null, null), (Object)inputFormat2);
    }

    private static /* synthetic */ void lambda$testGenericFormat$3(InputFormats.InputFormatDefn converter, ResolvedTable table) throws Throwable {
        converter.convert(table);
    }

    private static /* synthetic */ void lambda$testGenericFormat$2(InputFormats.InputFormatDefn converter, ResolvedTable table) throws Throwable {
        converter.convert(table);
    }
}

