/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import org.apache.druid.catalog.CatalogTest;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.InlineTableDefn;
import org.apache.druid.catalog.model.table.TableBuilder;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CatalogTest.class})
public class InlineTableTest {
    private final ObjectMapper mapper = new ObjectMapper();
    private final InlineTableDefn tableDefn = new InlineTableDefn();
    private final TableBuilder baseBuilder = TableBuilder.of((TableDefn)this.tableDefn).description("inline input").format("csv").column("x", "VARCHAR").column("y", "BIGINT");

    @Test
    public void testEmptyData() {
        ResolvedTable table = this.baseBuilder.buildResolved(this.mapper);
        Assert.assertThrows(IAE.class, () -> table.validate());
    }

    @Test
    public void testValidData() {
        ResolvedTable table = this.baseBuilder.copy().data(new String[]{"a,b", "c,d"}).buildResolved(this.mapper);
        table.validate();
        TableDefnRegistry registry = new TableDefnRegistry(this.mapper);
        Assert.assertNotNull((Object)registry.resolve(table.spec()));
        ExternalTableSpec externSpec = this.tableDefn.convertToExtern(table);
        InlineInputSource inlineSpec = (InlineInputSource)externSpec.inputSource();
        Assert.assertEquals((Object)"a,b\nc,d\n", (Object)inlineSpec.getData());
        CsvInputFormat csvFormat = (CsvInputFormat)externSpec.inputFormat();
        Assert.assertEquals(Arrays.asList("x", "y"), (Object)csvFormat.getColumns());
        RowSignature sig = externSpec.signature();
        Assert.assertEquals(Arrays.asList("x", "y"), (Object)sig.getColumnNames());
        Assert.assertEquals((Object)ColumnType.STRING, sig.getColumnType(0).get());
        Assert.assertEquals((Object)ColumnType.LONG, sig.getColumnType(1).get());
    }
}

