/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.catalog.CatalogTest;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.TableDefnRegistry;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.HttpTableDefn;
import org.apache.druid.catalog.model.table.TableBuilder;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.HttpInputSource;
import org.apache.druid.data.input.impl.HttpInputSourceConfig;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.metadata.DefaultPasswordProvider;
import org.apache.druid.metadata.EnvironmentVariablePasswordProvider;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CatalogTest.class})
public class HttpInputTableTest {
    private final ObjectMapper mapper = new ObjectMapper();
    private final HttpTableDefn tableDefn = new HttpTableDefn();
    private final TableBuilder baseBuilder = TableBuilder.of((TableDefn)this.tableDefn).description("http input").format("csv").column("x", "VARCHAR").column("y", "BIGINT");

    public HttpInputTableTest() {
        this.mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(HttpInputSourceConfig.class, (Object)new HttpInputSourceConfig(HttpInputSourceConfig.DEFAULT_ALLOWED_PROTOCOLS)));
    }

    @Test
    public void testHappyPath() {
        ResolvedTable table = this.baseBuilder.copy().property("user", (Object)"bob").property("password", (Object)"secret").property("uris", Collections.singletonList("http://foo.com/my.csv")).buildResolved(this.mapper);
        table.validate();
        TableDefnRegistry registry = new TableDefnRegistry(this.mapper);
        Assert.assertNotNull((Object)registry.resolve(table.spec()));
        ExternalTableSpec externSpec = this.tableDefn.convertToExtern(table);
        HttpInputSource sourceSpec = (HttpInputSource)externSpec.inputSource();
        Assert.assertEquals((Object)"bob", (Object)sourceSpec.getHttpAuthenticationUsername());
        Assert.assertEquals((Object)"secret", (Object)((DefaultPasswordProvider)sourceSpec.getHttpAuthenticationPasswordProvider()).getPassword());
        Assert.assertEquals((Object)"http://foo.com/my.csv", (Object)((URI)sourceSpec.getUris().get(0)).toString());
        CsvInputFormat csvFormat = (CsvInputFormat)externSpec.inputFormat();
        Assert.assertEquals(Arrays.asList("x", "y"), (Object)csvFormat.getColumns());
        RowSignature sig = externSpec.signature();
        Assert.assertEquals(Arrays.asList("x", "y"), (Object)sig.getColumnNames());
        Assert.assertEquals((Object)ColumnType.STRING, sig.getColumnType(0).get());
        Assert.assertEquals((Object)ColumnType.LONG, sig.getColumnType(1).get());
    }

    @Test
    public void testEnvPassword() {
        ResolvedTable table = this.baseBuilder.copy().property("user", (Object)"bob").property("passwordEnvVar", (Object)"SECRET").property("uris", Collections.singletonList("http://foo.com/my.csv")).buildResolved(this.mapper);
        table.validate();
        ExternalTableSpec externSpec = this.tableDefn.convertToExtern(table);
        HttpInputSource sourceSpec = (HttpInputSource)externSpec.inputSource();
        Assert.assertEquals((Object)"bob", (Object)sourceSpec.getHttpAuthenticationUsername());
        Assert.assertEquals((Object)"SECRET", (Object)((EnvironmentVariablePasswordProvider)sourceSpec.getHttpAuthenticationPasswordProvider()).getVariable());
    }

    @Test
    public void testParameters() {
        ResolvedTable table = this.baseBuilder.copy().property("user", (Object)"bob").property("passwordEnvVar", (Object)"SECRET").property("uriTemplate", (Object)"http://foo.com/{}").buildResolved(this.mapper);
        table.validate();
        HttpTableDefn parameterizedTable = this.tableDefn;
        Assert.assertEquals((long)1L, (long)parameterizedTable.parameters().size());
        Assert.assertNotNull((Object)parameterizedTable.parameter("uris"));
        ImmutableMap params = ImmutableMap.of((Object)"uris", (Object)"foo.csv,bar.csv");
        ExternalTableSpec externSpec = parameterizedTable.applyParameters(table, (Map)params);
        HttpInputSource sourceSpec = (HttpInputSource)externSpec.inputSource();
        Assert.assertEquals((Object)"bob", (Object)sourceSpec.getHttpAuthenticationUsername());
        Assert.assertEquals((Object)"SECRET", (Object)((EnvironmentVariablePasswordProvider)sourceSpec.getHttpAuthenticationPasswordProvider()).getVariable());
        Assert.assertEquals((Object)HttpTableDefn.convertUriList(Arrays.asList("http://foo.com/foo.csv", "http://foo.com/bar.csv")), (Object)sourceSpec.getUris());
    }

    @Test
    public void testNoTemplate() {
        ResolvedTable table = this.baseBuilder.copy().property("uris", Collections.singletonList("http://foo.com/my.csv")).buildResolved(this.mapper);
        table.validate();
        ImmutableMap params = ImmutableMap.of((Object)"uris", (Object)"foo.csv,bar.csv");
        Assert.assertThrows(IAE.class, () -> this.lambda$testNoTemplate$0(table, (Map)params));
    }

    @Test
    public void testNoParameters() {
        ResolvedTable table = this.baseBuilder.copy().property("uriTemplate", (Object)"http://foo.com/{}").buildResolved(this.mapper);
        ImmutableMap params = ImmutableMap.of();
        Assert.assertThrows(IAE.class, () -> this.lambda$testNoParameters$1(table, (Map)params));
    }

    @Test
    public void testInvalidParameters() {
        ResolvedTable table = this.baseBuilder.copy().property("uriTemplate", (Object)"//foo.com/{}").buildResolved(this.mapper);
        ImmutableMap params = ImmutableMap.of((Object)"uris", (Object)"foo.csv");
        Assert.assertThrows(IAE.class, () -> this.lambda$testInvalidParameters$2(table, (Map)params));
    }

    @Test
    public void testInvalidURI() {
        ResolvedTable table = this.baseBuilder.copy().property("uris", Collections.singletonList("//foo.com")).buildResolved(this.mapper);
        Assert.assertThrows(IAE.class, () -> table.validate());
    }

    private /* synthetic */ void lambda$testInvalidParameters$2(ResolvedTable table, Map params) throws Throwable {
        this.tableDefn.applyParameters(table, params);
    }

    private /* synthetic */ void lambda$testNoParameters$1(ResolvedTable table, Map params) throws Throwable {
        this.tableDefn.applyParameters(table, params);
    }

    private /* synthetic */ void lambda$testNoTemplate$0(ResolvedTable table, Map params) throws Throwable {
        this.tableDefn.applyParameters(table, params);
    }
}

