/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.server.initialization.jetty.JettyServerModule;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JettyServerModuleTest {
    @Test
    public void testJettyServerModule() {
        final ArrayList events = new ArrayList();
        ServiceEmitter serviceEmitter = new ServiceEmitter("service", "host", (Emitter)Mockito.mock(Emitter.class)){

            public void emit(Event event) {
                events.add(event);
            }
        };
        QueuedThreadPool jettyServerThreadPool = (QueuedThreadPool)Mockito.mock(QueuedThreadPool.class);
        JettyServerModule.setJettyServerThreadPool((QueuedThreadPool)jettyServerThreadPool);
        Mockito.when((Object)jettyServerThreadPool.getThreads()).thenReturn((Object)100);
        Mockito.when((Object)jettyServerThreadPool.getIdleThreads()).thenReturn((Object)40);
        Mockito.when((Object)jettyServerThreadPool.isLowOnThreads()).thenReturn((Object)true);
        Mockito.when((Object)jettyServerThreadPool.getMinThreads()).thenReturn((Object)30);
        Mockito.when((Object)jettyServerThreadPool.getMaxThreads()).thenReturn((Object)100);
        Mockito.when((Object)jettyServerThreadPool.getQueueSize()).thenReturn((Object)50);
        Mockito.when((Object)jettyServerThreadPool.getBusyThreads()).thenReturn((Object)60);
        JettyServerModule.JettyMonitor jettyMonitor = new JettyServerModule.JettyMonitor("ds", "t0");
        jettyMonitor.doMonitor(serviceEmitter);
        Assert.assertEquals((long)8L, (long)events.size());
        List<Pair> expectedEvents = Arrays.asList(new Pair((Object)"jetty/numOpenConnections", (Object)0), new Pair((Object)"jetty/threadPool/total", (Object)100), new Pair((Object)"jetty/threadPool/idle", (Object)40), new Pair((Object)"jetty/threadPool/isLowOnThreads", (Object)1), new Pair((Object)"jetty/threadPool/min", (Object)30), new Pair((Object)"jetty/threadPool/max", (Object)100), new Pair((Object)"jetty/threadPool/queueSize", (Object)50), new Pair((Object)"jetty/threadPool/busy", (Object)60));
        for (int i = 0; i < expectedEvents.size(); ++i) {
            Pair expected = expectedEvents.get(i);
            ServiceMetricEvent actual = (ServiceMetricEvent)events.get(i);
            Assert.assertEquals((Object)expected.lhs, (Object)actual.getMetric());
            Assert.assertEquals((Object)expected.rhs, (Object)actual.getValue());
        }
    }
}

