/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.KillRules;
import org.joda.time.Duration;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillRulesTest {
    @Mock
    private MetadataRuleManager mockRuleManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    @Mock
    private ServiceEmitter mockServiceEmitter;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private KillRules killRules;

    @Before
    public void setup() {
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getDatabaseRuleManager()).thenReturn((Object)this.mockRuleManager);
    }

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorRuleKillPeriod(new Duration(Long.MAX_VALUE)).withCoordinatorRuleKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killRules = new KillRules((DruidCoordinatorConfig)druidCoordinatorConfig);
        this.killRules.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockRuleManager});
    }

    @Test
    public void testRunNotSkipIfLastRunMoreThanPeriod() {
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getEmitter()).thenReturn((Object)this.mockServiceEmitter);
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorRuleKillPeriod(new Duration((Object)"PT6S")).withCoordinatorRuleKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killRules = new KillRules((DruidCoordinatorConfig)druidCoordinatorConfig);
        this.killRules.run(this.mockDruidCoordinatorRuntimeParams);
        ((MetadataRuleManager)Mockito.verify((Object)this.mockRuleManager)).removeRulesForEmptyDatasourcesOlderThan(ArgumentMatchers.anyLong());
        ((ServiceEmitter)Mockito.verify((Object)this.mockServiceEmitter)).emit((ServiceEventBuilder)ArgumentMatchers.any(ServiceEventBuilder.class));
    }

    @Test
    public void testConstructorFailIfInvalidPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorRuleKillPeriod(new Duration((Object)"PT3S")).withCoordinatorRuleKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("coordinator rule kill period must be >= druid.coordinator.period.metadataStoreManagementPeriod");
        this.killRules = new KillRules((DruidCoordinatorConfig)druidCoordinatorConfig);
    }

    @Test
    public void testConstructorFailIfInvalidRetainDuration() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorRuleKillPeriod(new Duration((Object)"PT6S")).withCoordinatorRuleKillDurationToRetain(new Duration((Object)"PT-1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("coordinator rule kill retainDuration must be >= 0");
        this.killRules = new KillRules((DruidCoordinatorConfig)druidCoordinatorConfig);
    }
}

