/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.joda.time.Duration;

public class TestDruidCoordinatorConfig
extends DruidCoordinatorConfig {
    private final Duration coordinatorStartDelay;
    private final Duration coordinatorPeriod;
    private final Duration coordinatorIndexingPeriod;
    private final Duration metadataStoreManagementPeriod;
    private final Duration loadTimeoutDelay;
    private final Duration coordinatorKillPeriod;
    private final Duration coordinatorKillDurationToRetain;
    private final Duration coordinatorSupervisorKillPeriod;
    private final Duration coordinatorSupervisorKillDurationToRetain;
    private final Duration coordinatorAuditKillPeriod;
    private final Duration coordinatorAuditKillDurationToRetain;
    private final Duration coordinatorCompactionKillPeriod;
    private final Duration coordinatorRuleKillPeriod;
    private final Duration coordinatorRuleKillDurationToRetain;
    private final Duration coordinatorDatasourceKillPeriod;
    private final Duration coordinatorDatasourceKillDurationToRetain;
    private final Duration loadQueuePeonRepeatDelay;
    private final int coordinatorKillMaxSegments;
    private final boolean compactionSkipLockedIntervals;
    private final boolean coordinatorKillIgnoreDurationToRetain;
    private final String loadQueuePeonType;
    private final Duration httpLoadQueuePeonRepeatDelay;
    private final int curatorLoadQueuePeonNumCallbackThreads;
    private final Duration httpLoadQueuePeonHostTimeout;
    private final int httpLoadQueuePeonBatchSize;

    public TestDruidCoordinatorConfig(Duration coordinatorStartDelay, Duration coordinatorPeriod, Duration coordinatorIndexingPeriod, Duration metadataStoreManagementPeriod, Duration loadTimeoutDelay, Duration coordinatorKillPeriod, Duration coordinatorKillDurationToRetain, Duration coordinatorSupervisorKillPeriod, Duration coordinatorSupervisorKillDurationToRetain, Duration coordinatorAuditKillPeriod, Duration coordinatorAuditKillDurationToRetain, Duration coordinatorCompactionKillPeriod, Duration coordinatorRuleKillPeriod, Duration coordinatorRuleKillDurationToRetain, Duration coordinatorDatasourceKillPeriod, Duration coordinatorDatasourceKillDurationToRetain, int coordinatorKillMaxSegments, Duration loadQueuePeonRepeatDelay, boolean compactionSkipLockedIntervals, boolean coordinatorKillIgnoreDurationToRetain, String loadQueuePeonType, Duration httpLoadQueuePeonRepeatDelay, Duration httpLoadQueuePeonHostTimeout, int httpLoadQueuePeonBatchSize, int curatorLoadQueuePeonNumCallbackThreads) {
        this.coordinatorStartDelay = coordinatorStartDelay;
        this.coordinatorPeriod = coordinatorPeriod;
        this.coordinatorIndexingPeriod = coordinatorIndexingPeriod;
        this.metadataStoreManagementPeriod = metadataStoreManagementPeriod;
        this.loadTimeoutDelay = loadTimeoutDelay;
        this.coordinatorKillPeriod = coordinatorKillPeriod;
        this.coordinatorKillDurationToRetain = coordinatorKillDurationToRetain;
        this.coordinatorSupervisorKillPeriod = coordinatorSupervisorKillPeriod;
        this.coordinatorSupervisorKillDurationToRetain = coordinatorSupervisorKillDurationToRetain;
        this.coordinatorAuditKillPeriod = coordinatorAuditKillPeriod;
        this.coordinatorAuditKillDurationToRetain = coordinatorAuditKillDurationToRetain;
        this.coordinatorCompactionKillPeriod = coordinatorCompactionKillPeriod;
        this.coordinatorRuleKillPeriod = coordinatorRuleKillPeriod;
        this.coordinatorRuleKillDurationToRetain = coordinatorRuleKillDurationToRetain;
        this.coordinatorDatasourceKillPeriod = coordinatorDatasourceKillPeriod;
        this.coordinatorDatasourceKillDurationToRetain = coordinatorDatasourceKillDurationToRetain;
        this.coordinatorKillMaxSegments = coordinatorKillMaxSegments;
        this.loadQueuePeonRepeatDelay = loadQueuePeonRepeatDelay;
        this.compactionSkipLockedIntervals = compactionSkipLockedIntervals;
        this.coordinatorKillIgnoreDurationToRetain = coordinatorKillIgnoreDurationToRetain;
        this.loadQueuePeonType = loadQueuePeonType;
        this.httpLoadQueuePeonRepeatDelay = httpLoadQueuePeonRepeatDelay;
        this.httpLoadQueuePeonHostTimeout = httpLoadQueuePeonHostTimeout;
        this.httpLoadQueuePeonBatchSize = httpLoadQueuePeonBatchSize;
        this.curatorLoadQueuePeonNumCallbackThreads = curatorLoadQueuePeonNumCallbackThreads;
    }

    public Duration getCoordinatorStartDelay() {
        return this.coordinatorStartDelay;
    }

    public Duration getCoordinatorPeriod() {
        return this.coordinatorPeriod;
    }

    public Duration getCoordinatorIndexingPeriod() {
        return this.coordinatorIndexingPeriod;
    }

    public Duration getCoordinatorMetadataStoreManagementPeriod() {
        return this.metadataStoreManagementPeriod;
    }

    public Duration getCoordinatorKillPeriod() {
        return this.coordinatorKillPeriod;
    }

    public Duration getCoordinatorKillDurationToRetain() {
        return this.coordinatorKillDurationToRetain;
    }

    public Duration getCoordinatorSupervisorKillPeriod() {
        return this.coordinatorSupervisorKillPeriod;
    }

    public Duration getCoordinatorSupervisorKillDurationToRetain() {
        return this.coordinatorSupervisorKillDurationToRetain;
    }

    public Duration getCoordinatorAuditKillPeriod() {
        return this.coordinatorAuditKillPeriod;
    }

    public Duration getCoordinatorAuditKillDurationToRetain() {
        return this.coordinatorAuditKillDurationToRetain;
    }

    public Duration getCoordinatorCompactionKillPeriod() {
        return this.coordinatorCompactionKillPeriod;
    }

    public Duration getCoordinatorRuleKillPeriod() {
        return this.coordinatorRuleKillPeriod;
    }

    public Duration getCoordinatorRuleKillDurationToRetain() {
        return this.coordinatorRuleKillDurationToRetain;
    }

    public Duration getCoordinatorDatasourceKillPeriod() {
        return this.coordinatorDatasourceKillPeriod;
    }

    public Duration getCoordinatorDatasourceKillDurationToRetain() {
        return this.coordinatorDatasourceKillDurationToRetain;
    }

    public int getCoordinatorKillMaxSegments() {
        return this.coordinatorKillMaxSegments;
    }

    public Duration getLoadTimeoutDelay() {
        return this.loadTimeoutDelay == null ? super.getLoadTimeoutDelay() : this.loadTimeoutDelay;
    }

    public Duration getLoadQueuePeonRepeatDelay() {
        return this.loadQueuePeonRepeatDelay;
    }

    public boolean getCompactionSkipLockedIntervals() {
        return this.compactionSkipLockedIntervals;
    }

    public boolean getCoordinatorKillIgnoreDurationToRetain() {
        return this.coordinatorKillIgnoreDurationToRetain;
    }

    public String getLoadQueuePeonType() {
        return this.loadQueuePeonType;
    }

    public Duration getHttpLoadQueuePeonRepeatDelay() {
        return this.httpLoadQueuePeonRepeatDelay;
    }

    public int getNumCuratorCallBackThreads() {
        return this.curatorLoadQueuePeonNumCallbackThreads;
    }

    public Duration getHttpLoadQueuePeonHostTimeout() {
        return this.httpLoadQueuePeonHostTimeout;
    }

    public int getHttpLoadQueuePeonBatchSize() {
        return this.httpLoadQueuePeonBatchSize;
    }

    public static class Builder {
        private static final Duration DEFAULT_COORDINATOR_START_DELAY = new Duration((Object)"PT300s");
        private static final Duration DEFAULT_COORDINATOR_PERIOD = new Duration((Object)"PT60s");
        private static final Duration DEFAULT_COORDINATOR_INDEXING_PERIOD = new Duration((Object)"PT1800s");
        private static final Duration DEFAULT_METADATA_STORE_MANAGEMENT_PERIOD = new Duration((Object)"PT3600s");
        private static final Duration DEFAULT_COORDINATOR_KILL_PERIOD = new Duration((Object)"PT86400s");
        private static final Duration DEFAULT_COORDINATOR_KILL_DURATION_TO_RETAION = new Duration((Object)"PT7776000s");
        private static final boolean DEFAULT_COORDINATOR_KILL_IGNORE_DURATION_TO_RETAIN = false;
        private static final int DEFAULT_COORDINATOR_KILL_MAX_SEGMENTS = 100;
        private static final Duration DEFAULT_COORDINATOR_SUPERVISOR_KILL_PERIOD = new Duration((Object)"PT86400s");
        private static final Duration DEFAULT_COORDINATOR_SUPERVISOR_KILL_DURATION_TO_RETAIN = new Duration((Object)"PT7776000s");
        private static final Duration DEFAULT_COORDINATOR_COMPACTION_KILL_PERIOD = new Duration((Object)"PT86400s");
        private static final Duration DEFAULT_COORDINATOR_RULE_KILL_PERIOD = new Duration((Object)"PT86400s");
        private static final Duration DEFAULT_COORDINATOR_RULE_KILL_DURATION_TO_RETAIN = new Duration((Object)"PT7776000s");
        private static final Duration DEFAULT_COORDINATOR_DATASOURCE_KILL_PERIOD = new Duration((Object)"PT86400s");
        private static final Duration DEFAULT_COORDINATOR_DATASOURCE_KILL_DURATION_TO_RETAIN = new Duration((Object)"PT7776000s");
        private static final Duration DEFAULT_LOAD_TIMEOUT_DELAY = new Duration(900000L);
        private static final Duration DEFAULT_LOAD_QUEUE_PEON_REPEAT_DELAY = Duration.millis((long)50L);
        private static final String DEFAULT_LOAD_QUEUE_PEON_TYPE = "curator";
        private static final int DEFAULT_CURATOR_LOAD_QUEUE_PEON_NUM_CALLBACK_THREADS = 2;
        private static final Duration DEFAULT_HTTP_LOAD_QUEUE_PEON_REPEAT_DELAY = Duration.millis((long)60000L);
        private static final Duration DEFAULT_HTTP_LOAD_QUEUE_PEON_HOST_TIMEOUT = Duration.millis((long)300000L);
        private static final int DEFAULT_HTTP_LOAD_QUEUE_PEON_BATCH_SIZE = 1;
        private static final boolean DEFAULT_COMPACTION_SKIP_LOCKED_INTERVALS = true;
        private static final Duration DEFAULT_COORDINATOR_AUDIT_KILL_PERIOD = new Duration((Object)"PT86400s");
        private static final Duration DEFAULT_COORDINATOR_AUTIT_KILL_DURATION_TO_RETAIN = new Duration((Object)"PT7776000s");
        private Duration coordinatorStartDelay;
        private Duration coordinatorPeriod;
        private Duration coordinatorIndexingPeriod;
        private Duration metadataStoreManagementPeriod;
        private Duration coordinatorKillPeriod;
        private Duration coordinatorKillDurationToRetain;
        private Boolean coordinatorKillIgnoreDurationToRetain;
        private Integer coordinatorKillMaxSegments;
        private Duration coordinatorSupervisorKillPeriod;
        private Duration coordinatorSupervisorKillDurationToRetain;
        private Duration coordinatorCompactionKillPeriod;
        private Duration coordinatorRuleKillPeriod;
        private Duration coordinatorRuleKillDurationToRetain;
        private Duration coordinatorDatasourceKillPeriod;
        private Duration coordinatorDatasourceKillDurationToRetain;
        private Duration loadTimeoutDelay;
        private Duration loadQueuePeonRepeatDelay;
        private String loadQueuePeonType;
        private Duration httpLoadQueuePeonRepeatDelay;
        private Integer curatorLoadQueuePeonNumCallbackThreads;
        private Duration httpLoadQueuePeonHostTimeout;
        private Integer httpLoadQueuePeonBatchSize;
        private Boolean compactionSkippedLockedIntervals;
        private Duration coordinatorAuditKillPeriod;
        private Duration coordinatorAuditKillDurationToRetain;

        public Builder withCoordinatorStartDelay(Duration coordinatorStartDelay) {
            this.coordinatorStartDelay = coordinatorStartDelay;
            return this;
        }

        public Builder withCoordinatorPeriod(Duration coordinatorPeriod) {
            this.coordinatorPeriod = coordinatorPeriod;
            return this;
        }

        public Builder withCoordinatorIndexingPeriod(Duration coordinatorIndexingPeriod) {
            this.coordinatorIndexingPeriod = coordinatorIndexingPeriod;
            return this;
        }

        public Builder withMetadataStoreManagementPeriod(Duration metadataStoreManagementPeriod) {
            this.metadataStoreManagementPeriod = metadataStoreManagementPeriod;
            return this;
        }

        public Builder withCoordinatorKillPeriod(Duration coordinatorKillPeriod) {
            this.coordinatorKillPeriod = coordinatorKillPeriod;
            return this;
        }

        public Builder withCoordinatorKillDurationToRetain(Duration coordinatorKillDurationToRetain) {
            this.coordinatorKillDurationToRetain = coordinatorKillDurationToRetain;
            return this;
        }

        public Builder withCoordinatorKillIgnoreDurationToRetain(boolean coordinatorKillIgnoreDurationToRetain) {
            this.coordinatorKillIgnoreDurationToRetain = coordinatorKillIgnoreDurationToRetain;
            return this;
        }

        public Builder withCoordinatorKillMaxSegments(int coordinatorKillMaxSegments) {
            this.coordinatorKillMaxSegments = coordinatorKillMaxSegments;
            return this;
        }

        public Builder withCoordinatorSupervisorKillPeriod(Duration coordinatorSupervisorKillPeriod) {
            this.coordinatorSupervisorKillPeriod = coordinatorSupervisorKillPeriod;
            return this;
        }

        public Builder withCoordinatorSupervisorKillDurationToRetain(Duration coordinatorSupervisorKillDurationToRetain) {
            this.coordinatorSupervisorKillDurationToRetain = coordinatorSupervisorKillDurationToRetain;
            return this;
        }

        public Builder withCoordinatorCompactionKillPeriod(Duration coordinatorCompactionKillPeriod) {
            this.coordinatorCompactionKillPeriod = coordinatorCompactionKillPeriod;
            return this;
        }

        public Builder withCoordinatorRuleKillPeriod(Duration coordinatorRuleKillPeriod) {
            this.coordinatorRuleKillPeriod = coordinatorRuleKillPeriod;
            return this;
        }

        public Builder withCoordinatorRuleKillDurationToRetain(Duration coordinatorRuleKillDurationToRetain) {
            this.coordinatorRuleKillDurationToRetain = coordinatorRuleKillDurationToRetain;
            return this;
        }

        public Builder withCoordinatorDatasourceKillPeriod(Duration coordinatorDatasourceKillPeriod) {
            this.coordinatorDatasourceKillPeriod = coordinatorDatasourceKillPeriod;
            return this;
        }

        public Builder withCoordinatorDatasourceKillDurationToRetain(Duration coordinatorDatasourceKillDurationToRetain) {
            this.coordinatorDatasourceKillDurationToRetain = coordinatorDatasourceKillDurationToRetain;
            return this;
        }

        public Builder withLoadTimeoutDelay(Duration loadTimeoutDelay) {
            this.loadTimeoutDelay = loadTimeoutDelay;
            return this;
        }

        public Builder withLoadQueuePeonRepeatDelay(Duration loadQueuePeonRepeatDelay) {
            this.loadQueuePeonRepeatDelay = loadQueuePeonRepeatDelay;
            return this;
        }

        public Builder withLoadQueuePeonType(String loadQueuePeonType) {
            this.loadQueuePeonType = loadQueuePeonType;
            return this;
        }

        public Builder withHttpLoadQueuePeonRepeatDelay(Duration httpLoadQueuePeonRepeatDelay) {
            this.httpLoadQueuePeonRepeatDelay = httpLoadQueuePeonRepeatDelay;
            return this;
        }

        public Builder withCuratorLoadQueuePeonNumCallbackThreads(int curatorLoadQueuePeonNumCallbackThreads) {
            this.curatorLoadQueuePeonNumCallbackThreads = curatorLoadQueuePeonNumCallbackThreads;
            return this;
        }

        public Builder withHttpLoadQueuePeonHostTimeout(Duration httpLoadQueuePeonHostTimeout) {
            this.httpLoadQueuePeonHostTimeout = httpLoadQueuePeonHostTimeout;
            return this;
        }

        public Builder withHttpLoadQueuePeonBatchSize(int httpLoadQueuePeonBatchSize) {
            this.httpLoadQueuePeonBatchSize = httpLoadQueuePeonBatchSize;
            return this;
        }

        public Builder withCompactionSkippedLockedIntervals(boolean compactionSkippedLockedIntervals) {
            this.compactionSkippedLockedIntervals = compactionSkippedLockedIntervals;
            return this;
        }

        public Builder withCoordianatorAuditKillPeriod(Duration coordinatorAuditKillPeriod) {
            this.coordinatorAuditKillPeriod = coordinatorAuditKillPeriod;
            return this;
        }

        public Builder withCoordinatorAuditKillDurationToRetain(Duration coordinatorAuditKillDurationToRetain) {
            this.coordinatorAuditKillDurationToRetain = coordinatorAuditKillDurationToRetain;
            return this;
        }

        public TestDruidCoordinatorConfig build() {
            return new TestDruidCoordinatorConfig(this.coordinatorStartDelay == null ? DEFAULT_COORDINATOR_START_DELAY : this.coordinatorStartDelay, this.coordinatorPeriod == null ? DEFAULT_COORDINATOR_PERIOD : this.coordinatorPeriod, this.coordinatorIndexingPeriod == null ? DEFAULT_COORDINATOR_INDEXING_PERIOD : this.coordinatorIndexingPeriod, this.metadataStoreManagementPeriod == null ? DEFAULT_METADATA_STORE_MANAGEMENT_PERIOD : this.metadataStoreManagementPeriod, this.loadTimeoutDelay == null ? DEFAULT_LOAD_TIMEOUT_DELAY : this.loadTimeoutDelay, this.coordinatorKillPeriod == null ? DEFAULT_COORDINATOR_KILL_PERIOD : this.coordinatorKillPeriod, this.coordinatorKillDurationToRetain == null ? DEFAULT_COORDINATOR_KILL_DURATION_TO_RETAION : this.coordinatorKillDurationToRetain, this.coordinatorSupervisorKillPeriod == null ? DEFAULT_COORDINATOR_SUPERVISOR_KILL_PERIOD : this.coordinatorSupervisorKillPeriod, this.coordinatorSupervisorKillDurationToRetain == null ? DEFAULT_COORDINATOR_SUPERVISOR_KILL_DURATION_TO_RETAIN : this.coordinatorSupervisorKillDurationToRetain, this.coordinatorAuditKillPeriod == null ? DEFAULT_COORDINATOR_AUDIT_KILL_PERIOD : this.coordinatorAuditKillPeriod, this.coordinatorAuditKillDurationToRetain == null ? DEFAULT_COORDINATOR_AUTIT_KILL_DURATION_TO_RETAIN : this.coordinatorAuditKillDurationToRetain, this.coordinatorCompactionKillPeriod == null ? DEFAULT_COORDINATOR_COMPACTION_KILL_PERIOD : this.coordinatorCompactionKillPeriod, this.coordinatorRuleKillPeriod == null ? DEFAULT_COORDINATOR_RULE_KILL_PERIOD : this.coordinatorRuleKillPeriod, this.coordinatorRuleKillDurationToRetain == null ? DEFAULT_COORDINATOR_RULE_KILL_DURATION_TO_RETAIN : this.coordinatorRuleKillDurationToRetain, this.coordinatorDatasourceKillPeriod == null ? DEFAULT_COORDINATOR_DATASOURCE_KILL_PERIOD : this.coordinatorDatasourceKillPeriod, this.coordinatorDatasourceKillDurationToRetain == null ? DEFAULT_COORDINATOR_DATASOURCE_KILL_DURATION_TO_RETAIN : this.coordinatorDatasourceKillDurationToRetain, this.coordinatorKillMaxSegments == null ? 100 : this.coordinatorKillMaxSegments, this.loadQueuePeonRepeatDelay == null ? DEFAULT_LOAD_QUEUE_PEON_REPEAT_DELAY : this.loadQueuePeonRepeatDelay, this.compactionSkippedLockedIntervals == null ? true : this.compactionSkippedLockedIntervals, this.coordinatorKillIgnoreDurationToRetain == null ? false : this.coordinatorKillIgnoreDurationToRetain, this.loadQueuePeonType == null ? DEFAULT_LOAD_QUEUE_PEON_TYPE : this.loadQueuePeonType, this.httpLoadQueuePeonRepeatDelay == null ? DEFAULT_HTTP_LOAD_QUEUE_PEON_REPEAT_DELAY : this.httpLoadQueuePeonRepeatDelay, this.httpLoadQueuePeonHostTimeout == null ? DEFAULT_HTTP_LOAD_QUEUE_PEON_HOST_TIMEOUT : this.httpLoadQueuePeonHostTimeout, this.httpLoadQueuePeonBatchSize == null ? 1 : this.httpLoadQueuePeonBatchSize, this.curatorLoadQueuePeonNumCallbackThreads == null ? 2 : this.curatorLoadQueuePeonNumCallbackThreads);
        }
    }
}

