/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.Properties;
import org.apache.druid.java.util.common.config.Config;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.skife.config.ConfigurationObjectFactory;

public class DruidCoordinatorConfigTest {
    @Test
    public void testDeserialization() {
        ConfigurationObjectFactory factory = Config.createFactory((Properties)new Properties());
        DruidCoordinatorConfig config = (DruidCoordinatorConfig)factory.build(DruidCoordinatorConfig.class);
        Assert.assertEquals((Object)new Duration((Object)"PT300s"), (Object)config.getCoordinatorStartDelay());
        Assert.assertEquals((Object)new Duration((Object)"PT60s"), (Object)config.getCoordinatorPeriod());
        Assert.assertEquals((Object)new Duration((Object)"PT1800s"), (Object)config.getCoordinatorIndexingPeriod());
        Assert.assertEquals((long)86400000L, (long)config.getCoordinatorKillPeriod().getMillis());
        Assert.assertEquals((long)7776000000L, (long)config.getCoordinatorKillDurationToRetain().getMillis());
        Assert.assertEquals((long)100L, (long)config.getCoordinatorKillMaxSegments());
        Assert.assertEquals((Object)new Duration(900000L), (Object)config.getLoadTimeoutDelay());
        Assert.assertEquals((Object)Duration.millis((long)50L), (Object)config.getLoadQueuePeonRepeatDelay());
        Assert.assertTrue((boolean)config.getCompactionSkipLockedIntervals());
        Assert.assertFalse((boolean)config.getCoordinatorKillIgnoreDurationToRetain());
        Properties props = new Properties();
        props.setProperty("druid.coordinator.startDelay", "PT1s");
        props.setProperty("druid.coordinator.period", "PT1s");
        props.setProperty("druid.coordinator.period.indexingPeriod", "PT1s");
        props.setProperty("druid.coordinator.kill.on", "true");
        props.setProperty("druid.coordinator.kill.period", "PT1s");
        props.setProperty("druid.coordinator.kill.durationToRetain", "PT1s");
        props.setProperty("druid.coordinator.kill.maxSegments", "10000");
        props.setProperty("druid.coordinator.kill.pendingSegments.on", "true");
        props.setProperty("druid.coordinator.load.timeout", "PT1s");
        props.setProperty("druid.coordinator.loadqueuepeon.repeatDelay", "PT0.100s");
        props.setProperty("druid.coordinator.compaction.skipLockedIntervals", "false");
        props.setProperty("druid.coordinator.kill.ignoreDurationToRetain", "true");
        factory = Config.createFactory((Properties)props);
        config = (DruidCoordinatorConfig)factory.build(DruidCoordinatorConfig.class);
        Assert.assertEquals((Object)new Duration((Object)"PT1s"), (Object)config.getCoordinatorStartDelay());
        Assert.assertEquals((Object)new Duration((Object)"PT1s"), (Object)config.getCoordinatorPeriod());
        Assert.assertEquals((Object)new Duration((Object)"PT1s"), (Object)config.getCoordinatorIndexingPeriod());
        Assert.assertEquals((Object)new Duration((Object)"PT1s"), (Object)config.getCoordinatorKillPeriod());
        Assert.assertEquals((Object)new Duration((Object)"PT1s"), (Object)config.getCoordinatorKillDurationToRetain());
        Assert.assertEquals((long)10000L, (long)config.getCoordinatorKillMaxSegments());
        Assert.assertEquals((Object)new Duration((Object)"PT1s"), (Object)config.getLoadTimeoutDelay());
        Assert.assertEquals((Object)Duration.millis((long)100L), (Object)config.getLoadQueuePeonRepeatDelay());
        Assert.assertFalse((boolean)config.getCompactionSkipLockedIntervals());
        Assert.assertTrue((boolean)config.getCoordinatorKillIgnoreDurationToRetain());
        props = new Properties();
        props.setProperty("druid.coordinator.kill.durationToRetain", "PT-1s");
        factory = Config.createFactory((Properties)props);
        config = (DruidCoordinatorConfig)factory.build(DruidCoordinatorConfig.class);
        Assert.assertEquals((Object)new Duration((Object)"PT-1s"), (Object)config.getCoordinatorKillDurationToRetain());
    }
}

