/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;

public class TestStorageLocation {
    private static final Logger log = new Logger(TestStorageLocation.class);
    private final File cacheDir;
    private final File infoDir;
    private final ObjectMapper jsonMapper;

    public TestStorageLocation(TemporaryFolder temporaryFolder) throws IOException {
        this.cacheDir = temporaryFolder.newFolder();
        this.infoDir = temporaryFolder.newFolder();
        log.info("Creating tmp test files in [%s]", new Object[]{this.infoDir});
        this.jsonMapper = TestHelper.makeJsonMapper();
    }

    public File getInfoDir() {
        return this.infoDir;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public void writeSegmentInfoToCache(DataSegment segment) {
        if (!this.infoDir.exists()) {
            this.infoDir.mkdir();
        }
        File segmentInfoCacheFile = new File(this.infoDir, segment.getId().toString());
        try {
            this.jsonMapper.writeValue(segmentInfoCacheFile, (Object)segment);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((boolean)segmentInfoCacheFile.exists());
    }

    public void deleteSegmentInfoFromCache(DataSegment segment) {
        File segmentInfoCacheFile = new File(this.infoDir, segment.getId().toString());
        if (segmentInfoCacheFile.exists()) {
            segmentInfoCacheFile.delete();
        }
        Assert.assertFalse((boolean)segmentInfoCacheFile.exists());
    }

    public void checkInfoCache(Set<DataSegment> expectedSegments) {
        Assert.assertTrue((boolean)this.infoDir.exists());
        File[] files = this.infoDir.listFiles();
        Set segmentsInFiles = Arrays.stream(files).map(file -> {
            try {
                return (DataSegment)this.jsonMapper.readValue(file, DataSegment.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet());
        Assert.assertEquals(expectedSegments, segmentsInFiles);
    }

    public StorageLocationConfig toStorageLocationConfig() throws IOException {
        FileUtils.mkdirp((File)this.cacheDir);
        return new StorageLocationConfig(this.cacheDir, 100L, Double.valueOf(100.0));
    }

    public StorageLocationConfig toStorageLocationConfig(long maxSize, Double freeSpacePercent) throws IOException {
        FileUtils.mkdirp((File)this.cacheDir);
        return new StorageLocationConfig(this.cacheDir, maxSize, freeSpacePercent);
    }
}

