/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.LoadSpec;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentLocalCacheLoader;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordination.TestStorageLocation;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SegmentLoadDropHandlerCacheTest {
    private static final long MAX_SIZE = 1000L;
    private static final long SEGMENT_SIZE = 100L;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private SegmentLoadDropHandler loadDropHandler;
    private TestStorageLocation storageLoc;
    private ObjectMapper objectMapper;
    private DataSegmentAnnouncer segmentAnnouncer;

    @Before
    public void setup() throws IOException {
        this.storageLoc = new TestStorageLocation(this.temporaryFolder);
        SegmentLoaderConfig config = new SegmentLoaderConfig().withLocations(Collections.singletonList(this.storageLoc.toStorageLocationConfig(1000L, null))).withInfoDir(this.storageLoc.getInfoDir());
        this.objectMapper = TestHelper.makeJsonMapper();
        this.objectMapper.registerSubtypes(new Class[]{TestLoadSpec.class});
        this.objectMapper.registerSubtypes(new Class[]{TestSegmentizerFactory.class});
        SegmentLocalCacheManager cacheManager = new SegmentLocalCacheManager(config, this.objectMapper);
        SegmentManager segmentManager = new SegmentManager((SegmentLoader)new SegmentLocalCacheLoader((SegmentCacheManager)cacheManager, TestIndex.INDEX_IO, this.objectMapper));
        this.segmentAnnouncer = (DataSegmentAnnouncer)Mockito.mock(DataSegmentAnnouncer.class);
        this.loadDropHandler = new SegmentLoadDropHandler(this.objectMapper, config, this.segmentAnnouncer, (DataSegmentServerAnnouncer)Mockito.mock(DataSegmentServerAnnouncer.class), segmentManager, (SegmentCacheManager)cacheManager, new ServerTypeConfig(ServerType.HISTORICAL));
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
    }

    @Test
    public void testLoadLocalCache() throws IOException, SegmentLoadingException {
        File cacheDir = this.storageLoc.getCacheDir();
        int numSegments = 10;
        ArrayList<DataSegment> expectedSegments = new ArrayList<DataSegment>();
        for (int i = 0; i < numSegments; ++i) {
            String name = "segment-" + i;
            DataSegment segment = this.makeSegment("test", name);
            this.storageLoc.writeSegmentInfoToCache(segment);
            String storageDir = DataSegmentPusher.getDefaultStorageDir((DataSegment)segment, (boolean)false);
            File segmentDir = new File(cacheDir, storageDir);
            new TestLoadSpec(100, name).loadSegment(segmentDir);
            expectedSegments.add(segment);
        }
        this.loadDropHandler.start();
        ArgumentCaptor argCaptor = ArgumentCaptor.forClass(Iterable.class);
        ((DataSegmentAnnouncer)Mockito.verify((Object)this.segmentAnnouncer)).announceSegments((Iterable)argCaptor.capture());
        ArrayList<DataSegment> announcedSegments = new ArrayList<DataSegment>();
        ((Iterable)argCaptor.getValue()).forEach(announcedSegments::add);
        announcedSegments.sort(Comparator.comparing(DataSegment::getVersion));
        Assert.assertEquals(expectedSegments, announcedSegments);
        Mockito.reset((Object[])new DataSegmentAnnouncer[]{this.segmentAnnouncer});
        DataSegment newSegment = this.makeSegment("test", "new-segment");
        this.loadDropHandler.addSegment(newSegment, null);
        ((DataSegmentAnnouncer)Mockito.verify((Object)this.segmentAnnouncer, (VerificationMode)Mockito.never())).announceSegment((DataSegment)ArgumentMatchers.any());
        ((DataSegmentAnnouncer)Mockito.verify((Object)this.segmentAnnouncer, (VerificationMode)Mockito.never())).announceSegments((Iterable)ArgumentMatchers.any());
        this.loadDropHandler.removeSegment((DataSegment)expectedSegments.get(0), null, false);
        this.loadDropHandler.addSegment(newSegment, null);
        ((DataSegmentAnnouncer)Mockito.verify((Object)this.segmentAnnouncer)).announceSegment(newSegment);
    }

    private DataSegment makeSegment(String dataSource, String name) {
        return new DataSegment(dataSource, Intervals.utc((long)(System.currentTimeMillis() - 60000L), (long)System.currentTimeMillis()), name, (Map)ImmutableMap.of((Object)"type", (Object)"test", (Object)"name", (Object)name, (Object)"size", (Object)100L), Arrays.asList("dim1", "dim2", "dim3"), Arrays.asList("metric1", "metric2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 100L);
    }

    @JsonTypeName(value="testSegmentFactory")
    public static class TestSegmentizerFactory
    implements SegmentizerFactory {
        public Segment factorize(DataSegment segment, File parentDir, boolean lazy, SegmentLazyLoadFailCallback loadFailed) {
            return (Segment)Mockito.mock(Segment.class);
        }
    }

    @JsonTypeName(value="test")
    public static class TestLoadSpec
    implements LoadSpec {
        private final int size;
        private final String name;

        @JsonCreator
        public TestLoadSpec(@JsonProperty(value="size") int size, @JsonProperty(value="name") String name) {
            this.size = size;
            this.name = name;
        }

        public LoadSpec.LoadSpecResult loadSegment(File destDir) throws SegmentLoadingException {
            File segmentFile = new File(destDir, "segment");
            File factoryJson = new File(destDir, "factory.json");
            try {
                FileUtils.mkdirp((File)destDir);
                segmentFile.createNewFile();
                factoryJson.createNewFile();
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Failed to create files under dir '%s'", new Object[]{destDir.getAbsolutePath()});
            }
            try {
                byte[] bytes = new byte[this.size];
                ThreadLocalRandom.current().nextBytes(bytes);
                Files.write((byte[])bytes, (File)segmentFile);
                Files.write((byte[])"{\"type\":\"testSegmentFactory\"}".getBytes(StandardCharsets.UTF_8), (File)factoryJson);
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Failed to write data in directory %s", new Object[]{destDir.getAbsolutePath()});
            }
            return new LoadSpec.LoadSpecResult((long)this.size);
        }
    }
}

