/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.plumber;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.MapCache;
import org.apache.druid.data.input.Committer;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DefaultQueryRunnerFactoryConglomerate;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.handoff.SegmentHandoffNotifier;
import org.apache.druid.segment.handoff.SegmentHandoffNotifierFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.FireDepartmentTest;
import org.apache.druid.segment.realtime.FireHydrant;
import org.apache.druid.segment.realtime.SegmentPublisher;
import org.apache.druid.segment.realtime.plumber.Committers;
import org.apache.druid.segment.realtime.plumber.IntervalStartVersioningPolicy;
import org.apache.druid.segment.realtime.plumber.MessageTimeRejectionPolicyFactory;
import org.apache.druid.segment.realtime.plumber.NoopRejectionPolicyFactory;
import org.apache.druid.segment.realtime.plumber.RealtimePlumber;
import org.apache.druid.segment.realtime.plumber.RealtimePlumberSchool;
import org.apache.druid.segment.realtime.plumber.RejectionPolicyFactory;
import org.apache.druid.segment.realtime.plumber.Sink;
import org.apache.druid.segment.realtime.plumber.VersioningPolicy;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RealtimePlumberSchoolTest
extends InitializedNullHandlingTest {
    private final RejectionPolicyFactory rejectionPolicy;
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;
    private RealtimePlumber plumber;
    private RealtimePlumberSchool realtimePlumberSchool;
    private DataSegmentAnnouncer announcer;
    private SegmentPublisher segmentPublisher;
    private DataSegmentPusher dataSegmentPusher;
    private SegmentHandoffNotifier handoffNotifier;
    private SegmentHandoffNotifierFactory handoffNotifierFactory;
    private ServiceEmitter emitter;
    private RealtimeTuningConfig tuningConfig;
    private DataSchema schema;
    private DataSchema schema2;
    private FireDepartmentMetrics metrics;
    private File tmpDir;

    @Parameterized.Parameters(name="rejectionPolicy = {0}, segmentWriteOutMediumFactory = {1}")
    public static Collection<?> constructorFeeder() {
        RejectionPolicyFactory[] rejectionPolicies = new RejectionPolicyFactory[]{new NoopRejectionPolicyFactory(), new MessageTimeRejectionPolicyFactory()};
        ArrayList<Object[]> constructors = new ArrayList<Object[]>();
        for (RejectionPolicyFactory rejectionPolicy : rejectionPolicies) {
            constructors.add(new Object[]{rejectionPolicy, OffHeapMemorySegmentWriteOutMediumFactory.instance()});
            constructors.add(new Object[]{rejectionPolicy, TmpFileSegmentWriteOutMediumFactory.instance()});
        }
        return constructors;
    }

    public RealtimePlumberSchoolTest(RejectionPolicyFactory rejectionPolicy, SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.rejectionPolicy = rejectionPolicy;
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
    }

    @Before
    public void setUp() throws Exception {
        this.tmpDir = FileUtils.createTempDir();
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        this.schema = new DataSchema("test", (Map)jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("timestamp", "auto", null), DimensionsSpec.EMPTY, null, null, null), null), Map.class), new AggregatorFactory[]{new CountAggregatorFactory("rows")}, (GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.NONE, null), null, (ObjectMapper)jsonMapper);
        this.schema2 = new DataSchema("test", (Map)jsonMapper.convertValue((Object)new StringInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("timestamp", "auto", null), DimensionsSpec.EMPTY, null, null, null), null), Map.class), new AggregatorFactory[]{new CountAggregatorFactory("rows")}, (GranularitySpec)new UniformGranularitySpec(Granularities.YEAR, Granularities.NONE, null), null, (ObjectMapper)jsonMapper);
        this.announcer = (DataSegmentAnnouncer)EasyMock.createMock(DataSegmentAnnouncer.class);
        this.announcer.announceSegment((DataSegment)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        this.segmentPublisher = (SegmentPublisher)EasyMock.createNiceMock(SegmentPublisher.class);
        this.dataSegmentPusher = (DataSegmentPusher)EasyMock.createNiceMock(DataSegmentPusher.class);
        this.handoffNotifierFactory = (SegmentHandoffNotifierFactory)EasyMock.createNiceMock(SegmentHandoffNotifierFactory.class);
        this.handoffNotifier = (SegmentHandoffNotifier)EasyMock.createNiceMock(SegmentHandoffNotifier.class);
        EasyMock.expect((Object)this.handoffNotifierFactory.createSegmentHandoffNotifier(EasyMock.anyString())).andReturn((Object)this.handoffNotifier).anyTimes();
        EasyMock.expect((Object)this.handoffNotifier.registerSegmentHandoffCallback((SegmentDescriptor)EasyMock.anyObject(), (Executor)EasyMock.anyObject(), (Runnable)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        this.emitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        EasyMock.replay((Object[])new Object[]{this.announcer, this.segmentPublisher, this.dataSegmentPusher, this.handoffNotifierFactory, this.handoffNotifier, this.emitter});
        this.tuningConfig = new RealtimeTuningConfig(null, Integer.valueOf(1), null, null, null, null, null, (VersioningPolicy)new IntervalStartVersioningPolicy(), this.rejectionPolicy, null, null, null, null, 0, 0, Boolean.valueOf(false), null, null, null, null);
        this.realtimePlumberSchool = new RealtimePlumberSchool(this.emitter, (QueryRunnerFactoryConglomerate)new DefaultQueryRunnerFactoryConglomerate(new HashMap()), this.dataSegmentPusher, this.announcer, this.segmentPublisher, this.handoffNotifierFactory, (QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, (JoinableFactory)NoopJoinableFactory.INSTANCE, TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)this.segmentWriteOutMediumFactory), TestHelper.getTestIndexIO(), MapCache.create((long)0L), FireDepartmentTest.NO_CACHE_CONFIG, new CachePopulatorStats(), TestHelper.makeJsonMapper());
        this.metrics = new FireDepartmentMetrics();
        this.plumber = (RealtimePlumber)this.realtimePlumberSchool.findPlumber(this.schema, this.tuningConfig, this.metrics);
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.announcer, this.segmentPublisher, this.dataSegmentPusher, this.handoffNotifierFactory, this.handoffNotifier, this.emitter});
        FileUtils.deleteDirectory((File)new File(this.tuningConfig.getBasePersistDirectory(), this.schema.getDataSource()));
        FileUtils.deleteDirectory((File)this.tmpDir);
    }

    @Test(timeout=60000L)
    public void testPersist() throws Exception {
        this.testPersist(null);
    }

    @Test(timeout=60000L)
    public void testPersistWithCommitMetadata() throws Exception {
        String commitMetadata = "dummyCommitMetadata";
        this.testPersist(commitMetadata);
        this.plumber = (RealtimePlumber)this.realtimePlumberSchool.findPlumber(this.schema, this.tuningConfig, this.metrics);
        Assert.assertEquals((Object)commitMetadata, (Object)this.plumber.startJob());
    }

    private void testPersist(final Object commitMetadata) throws Exception {
        Sink sink = new Sink(Intervals.utc((long)0L, (long)TimeUnit.HOURS.toMillis(1L)), this.schema, this.tuningConfig.getShardSpec(), DateTimes.of((String)"2014-12-01T12:34:56.789").toString(), this.tuningConfig.getAppendableIndexSpec(), this.tuningConfig.getMaxRowsInMemory(), this.tuningConfig.getMaxBytesInMemoryOrDefault(), true, this.tuningConfig.getDedupColumn());
        this.plumber.getSinks().put(0L, sink);
        Assert.assertNull((Object)this.plumber.startJob());
        InputRow row = (InputRow)EasyMock.createNiceMock(InputRow.class);
        EasyMock.expect((Object)row.getTimestampFromEpoch()).andReturn((Object)0L);
        EasyMock.expect((Object)row.getDimensions()).andReturn(new ArrayList());
        EasyMock.replay((Object[])new Object[]{row});
        final CountDownLatch doneSignal = new CountDownLatch(1);
        Committer committer = new Committer(){

            public Object getMetadata() {
                return commitMetadata;
            }

            public void run() {
                doneSignal.countDown();
            }
        };
        this.plumber.add(row, Suppliers.ofInstance((Object)committer));
        this.plumber.persist(committer);
        doneSignal.await();
        this.plumber.getSinks().clear();
        this.plumber.finishJob();
    }

    @Test(timeout=60000L)
    public void testPersistFails() throws Exception {
        Sink sink = new Sink(Intervals.utc((long)0L, (long)TimeUnit.HOURS.toMillis(1L)), this.schema, this.tuningConfig.getShardSpec(), DateTimes.of((String)"2014-12-01T12:34:56.789").toString(), this.tuningConfig.getAppendableIndexSpec(), this.tuningConfig.getMaxRowsInMemory(), this.tuningConfig.getMaxBytesInMemoryOrDefault(), true, this.tuningConfig.getDedupColumn());
        this.plumber.getSinks().put(0L, sink);
        this.plumber.startJob();
        InputRow row = (InputRow)EasyMock.createNiceMock(InputRow.class);
        EasyMock.expect((Object)row.getTimestampFromEpoch()).andReturn((Object)0L);
        EasyMock.expect((Object)row.getDimensions()).andReturn(new ArrayList());
        EasyMock.replay((Object[])new Object[]{row});
        this.plumber.add(row, Suppliers.ofInstance((Object)Committers.nil()));
        CountDownLatch doneSignal = new CountDownLatch(1);
        this.plumber.persist((Committer)RealtimePlumberSchoolTest.supplierFromRunnable(() -> {
            doneSignal.countDown();
            throw new RuntimeException();
        }).get());
        doneSignal.await();
        while (this.metrics.failedPersists() < 1L) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)this.metrics.failedPersists());
    }

    @Test(timeout=60000L)
    public void testPersistHydrantGaps() throws Exception {
        String commitMetadata = "dummyCommitMetadata";
        this.testPersistHydrantGapsHelper(commitMetadata);
    }

    private void testPersistHydrantGapsHelper(final Object commitMetadata) throws Exception {
        Interval testInterval = new Interval((ReadableInstant)DateTimes.of((String)"1970-01-01"), (ReadableInstant)DateTimes.of((String)"1971-01-01"));
        RealtimePlumber plumber2 = (RealtimePlumber)this.realtimePlumberSchool.findPlumber(this.schema2, this.tuningConfig, this.metrics);
        Sink sink = new Sink(testInterval, this.schema2, this.tuningConfig.getShardSpec(), DateTimes.of((String)"2014-12-01T12:34:56.789").toString(), this.tuningConfig.getAppendableIndexSpec(), this.tuningConfig.getMaxRowsInMemory(), this.tuningConfig.getMaxBytesInMemoryOrDefault(), true, this.tuningConfig.getDedupColumn());
        plumber2.getSinks().put(0L, sink);
        Assert.assertNull((Object)plumber2.startJob());
        final CountDownLatch doneSignal = new CountDownLatch(1);
        Committer committer = new Committer(){

            public Object getMetadata() {
                return commitMetadata;
            }

            public void run() {
                doneSignal.countDown();
            }
        };
        plumber2.add(this.getTestInputRow("1970-01-01"), Suppliers.ofInstance((Object)committer));
        plumber2.add(this.getTestInputRow("1970-02-01"), Suppliers.ofInstance((Object)committer));
        plumber2.add(this.getTestInputRow("1970-03-01"), Suppliers.ofInstance((Object)committer));
        plumber2.add(this.getTestInputRow("1970-04-01"), Suppliers.ofInstance((Object)committer));
        plumber2.add(this.getTestInputRow("1970-05-01"), Suppliers.ofInstance((Object)committer));
        plumber2.persist(committer);
        doneSignal.await();
        plumber2.getSinks().clear();
        plumber2.finishJob();
        File persistDir = plumber2.computePersistDir(this.schema2, testInterval);
        for (int i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)new File(persistDir, String.valueOf(i)).exists());
        }
        FileUtils.deleteDirectory((File)new File(persistDir, "1"));
        FileUtils.deleteDirectory((File)new File(persistDir, "3"));
        RealtimePlumber restoredPlumber = (RealtimePlumber)this.realtimePlumberSchool.findPlumber(this.schema2, this.tuningConfig, this.metrics);
        restoredPlumber.bootstrapSinksFromDisk();
        Map sinks = restoredPlumber.getSinks();
        Assert.assertEquals((long)1L, (long)sinks.size());
        ArrayList hydrants = Lists.newArrayList((Iterable)((Iterable)sinks.get(new Long(0L))));
        DateTime startTime = DateTimes.of((String)"1970-01-01T00:00:00.000Z");
        Interval expectedInterval = new Interval((ReadableInstant)startTime, (ReadableInstant)DateTimes.of((String)"1971-01-01T00:00:00.000Z"));
        Assert.assertEquals((long)0L, (long)((FireHydrant)hydrants.get(0)).getCount());
        Assert.assertEquals((Object)expectedInterval, (Object)((FireHydrant)hydrants.get(0)).getSegmentDataInterval());
        Assert.assertEquals((long)2L, (long)((FireHydrant)hydrants.get(1)).getCount());
        Assert.assertEquals((Object)expectedInterval, (Object)((FireHydrant)hydrants.get(1)).getSegmentDataInterval());
        Assert.assertEquals((long)4L, (long)((FireHydrant)hydrants.get(2)).getCount());
        Assert.assertEquals((Object)expectedInterval, (Object)((FireHydrant)hydrants.get(2)).getSegmentDataInterval());
        FileUtils.deleteDirectory((File)new File(persistDir, "0"));
        FileUtils.deleteDirectory((File)new File(persistDir, "2"));
        FileUtils.deleteDirectory((File)new File(persistDir, "4"));
        RealtimePlumber restoredPlumber2 = (RealtimePlumber)this.realtimePlumberSchool.findPlumber(this.schema2, this.tuningConfig, this.metrics);
        restoredPlumber2.bootstrapSinksFromDisk();
        Assert.assertEquals((long)0L, (long)restoredPlumber2.getSinks().size());
    }

    @Test(timeout=60000L)
    public void testDimOrderInheritance() throws Exception {
        String commitMetadata = "dummyCommitMetadata";
        this.testDimOrderInheritanceHelper(commitMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDimOrderInheritanceHelper(final Object commitMetadata) throws Exception {
        ImmutableList expectedDims = ImmutableList.of((Object)ImmutableList.of((Object)"dimD"), (Object)ImmutableList.of((Object)"dimC"), (Object)ImmutableList.of((Object)"dimA"), (Object)ImmutableList.of((Object)"dimB"), (Object)ImmutableList.of((Object)"dimE"), (Object)ImmutableList.of((Object)"dimD", (Object)"dimC", (Object)"dimA", (Object)"dimB", (Object)"dimE"));
        RealtimePlumber plumber = (RealtimePlumber)this.realtimePlumberSchool.findPlumber(this.schema2, this.tuningConfig, this.metrics);
        Assert.assertNull((Object)plumber.startJob());
        final CountDownLatch doneSignal = new CountDownLatch(1);
        Committer committer = new Committer(){

            public Object getMetadata() {
                return commitMetadata;
            }

            public void run() {
                doneSignal.countDown();
            }
        };
        plumber.add(this.getTestInputRowFull("1970-01-01", (List<String>)ImmutableList.of((Object)"dimD"), (List<String>)ImmutableList.of((Object)"1")), Suppliers.ofInstance((Object)committer));
        plumber.add(this.getTestInputRowFull("1970-01-01", (List<String>)ImmutableList.of((Object)"dimC"), (List<String>)ImmutableList.of((Object)"1")), Suppliers.ofInstance((Object)committer));
        plumber.add(this.getTestInputRowFull("1970-01-01", (List<String>)ImmutableList.of((Object)"dimA"), (List<String>)ImmutableList.of((Object)"1")), Suppliers.ofInstance((Object)committer));
        plumber.add(this.getTestInputRowFull("1970-01-01", (List<String>)ImmutableList.of((Object)"dimB"), (List<String>)ImmutableList.of((Object)"1")), Suppliers.ofInstance((Object)committer));
        plumber.add(this.getTestInputRowFull("1970-01-01", (List<String>)ImmutableList.of((Object)"dimE"), (List<String>)ImmutableList.of((Object)"1")), Suppliers.ofInstance((Object)committer));
        plumber.add(this.getTestInputRowFull("1970-01-01", (List<String>)ImmutableList.of((Object)"dimA", (Object)"dimB", (Object)"dimC", (Object)"dimD", (Object)"dimE"), (List<String>)ImmutableList.of((Object)"1")), Suppliers.ofInstance((Object)committer));
        plumber.persist(committer);
        doneSignal.await();
        plumber.getSinks().clear();
        plumber.finishJob();
        RealtimePlumber restoredPlumber = (RealtimePlumber)this.realtimePlumberSchool.findPlumber(this.schema2, this.tuningConfig, this.metrics);
        restoredPlumber.bootstrapSinksFromDisk();
        Map sinks = restoredPlumber.getSinks();
        Assert.assertEquals((long)1L, (long)sinks.size());
        ArrayList hydrants = Lists.newArrayList((Iterable)((Iterable)sinks.get(0L)));
        for (int i = 0; i < hydrants.size(); ++i) {
            FireHydrant hydrant = (FireHydrant)hydrants.get(i);
            ReferenceCountingSegment segment = hydrant.getIncrementedSegment();
            try {
                QueryableIndex qindex = segment.asQueryableIndex();
                Assert.assertEquals((long)i, (long)hydrant.getCount());
                Assert.assertEquals(expectedDims.get(i), (Object)ImmutableList.copyOf((Iterable)qindex.getAvailableDimensions()));
                continue;
            }
            finally {
                segment.decrement();
            }
        }
    }

    private InputRow getTestInputRow(final String timeStr) {
        return new InputRow(){

            public List<String> getDimensions() {
                return new ArrayList<String>();
            }

            public long getTimestampFromEpoch() {
                return DateTimes.of((String)timeStr).getMillis();
            }

            public DateTime getTimestamp() {
                return DateTimes.of((String)timeStr);
            }

            public List<String> getDimension(String dimension) {
                return new ArrayList<String>();
            }

            public Number getMetric(String metric) {
                return 0;
            }

            public Object getRaw(String dimension) {
                return null;
            }

            public int compareTo(Row o) {
                return 0;
            }
        };
    }

    private InputRow getTestInputRowFull(final String timeStr, final List<String> dims, final List<String> dimVals) {
        return new InputRow(){

            public List<String> getDimensions() {
                return dims;
            }

            public long getTimestampFromEpoch() {
                return DateTimes.of((String)timeStr).getMillis();
            }

            public DateTime getTimestamp() {
                return DateTimes.of((String)timeStr);
            }

            public List<String> getDimension(String dimension) {
                return dimVals;
            }

            public Number getMetric(String metric) {
                return 0;
            }

            public Object getRaw(String dimension) {
                return dimVals;
            }

            public int compareTo(Row o) {
                return 0;
            }
        };
    }

    private static Supplier<Committer> supplierFromRunnable(final Runnable runnable) {
        Committer committer = new Committer(){

            public Object getMetadata() {
                return null;
            }

            public void run() {
                runnable.run();
            }
        };
        return Suppliers.ofInstance((Object)committer);
    }
}

