/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.realtime.firehose.EventReceiverFirehoseFactory;
import org.apache.druid.server.metrics.EventReceiverFirehoseRegister;
import org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.druid.server.security.AuthTestUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EventReceiverFirehoseIdleTest {
    private static final int CAPACITY = 300;
    private static final long MAX_IDLE_TIME = 5000L;
    private static final String SERVICE_NAME = "test_firehose";
    private final String inputRow = "[{\n  \"timestamp\":123,\n  \"d1\":\"v1\"\n}]";
    private EventReceiverFirehoseFactory eventReceiverFirehoseFactory;
    private EventReceiverFirehoseFactory.EventReceiverFirehose firehose;
    private EventReceiverFirehoseRegister register = new EventReceiverFirehoseRegister();
    private HttpServletRequest req;

    @Before
    public void setUp() {
        this.req = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        this.eventReceiverFirehoseFactory = new EventReceiverFirehoseFactory(SERVICE_NAME, Integer.valueOf(300), Long.valueOf(5000L), null, (ObjectMapper)new DefaultObjectMapper(), (ObjectMapper)new DefaultObjectMapper(), this.register, AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        this.firehose = (EventReceiverFirehoseFactory.EventReceiverFirehose)this.eventReceiverFirehoseFactory.connect((InputRowParser)new MapInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"d1"))), null, null, null)), null);
    }

    @Test(timeout=40000L)
    public void testIdle() throws Exception {
        this.awaitFirehoseClosed();
        this.awaitDelayedExecutorThreadTerminated();
    }

    private void awaitFirehoseClosed() throws InterruptedException {
        while (!this.firehose.isClosed()) {
            Thread.sleep(50L);
        }
    }

    private void awaitDelayedExecutorThreadTerminated() throws InterruptedException {
        this.firehose.getDelayedCloseExecutor().join();
    }

    @Test(timeout=40000L)
    public void testNotIdle() throws Exception {
        EasyMock.expect((Object)this.req.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.req.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.req.getAttribute("Druid-Authentication-Result")).andReturn((Object)AllowAllAuthenticator.ALLOW_ALL_RESULT).anyTimes();
        EasyMock.expect((Object)this.req.getHeader("X-Firehose-Producer-Id")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.req.getContentType()).andReturn((Object)"application/json").anyTimes();
        this.req.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.req});
        int checks = 5;
        for (int i = 0; i < 5; ++i) {
            Assert.assertFalse((boolean)this.firehose.isClosed());
            System.out.printf(Locale.ENGLISH, "Check %d/%d passed\n", i + 1, 5);
            this.firehose.addAll(IOUtils.toInputStream((String)"[{\n  \"timestamp\":123,\n  \"d1\":\"v1\"\n}]"), this.req);
            Thread.sleep(3000L);
        }
        this.awaitFirehoseClosed();
        this.awaitDelayedExecutorThreadTerminated();
    }
}

