/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.OpenAndClosedSegmentsAppenderatorTester;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndCommitMetadata;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class OpenAndClosedSegmentsBatchAppenderatorTest
extends InitializedNullHandlingTest {
    private static final List<SegmentIdWithShardSpec> IDENTIFIERS = ImmutableList.of((Object)OpenAndClosedSegmentsBatchAppenderatorTest.createSegmentId("2000/2001", "A", 0), (Object)OpenAndClosedSegmentsBatchAppenderatorTest.createSegmentId("2000/2001", "A", 1), (Object)OpenAndClosedSegmentsBatchAppenderatorTest.createSegmentId("2001/2002", "A", 0));

    @Test
    public void testSimpleIngestionWithIndexesNotMapped() throws Exception {
        try (OpenAndClosedSegmentsAppenderatorTester tester = new OpenAndClosedSegmentsAppenderatorTester(2, false, false);){
            Appenderator appenderator = tester.getAppenderator();
            Assert.assertEquals(null, (Object)appenderator.startJob());
            Assert.assertEquals((Object)"foo", (Object)appenderator.getDataSource());
            Assert.assertEquals((long)1L, (long)appenderator.add(IDENTIFIERS.get(0), OpenAndClosedSegmentsBatchAppenderatorTest.createInputRow("2000", "foo", 1), null).getNumRowsInSegment());
            Assert.assertEquals((long)2L, (long)appenderator.add(IDENTIFIERS.get(0), OpenAndClosedSegmentsBatchAppenderatorTest.createInputRow("2000", "bar", 2), null).getNumRowsInSegment());
            Assert.assertEquals((long)1L, (long)appenderator.add(IDENTIFIERS.get(1), OpenAndClosedSegmentsBatchAppenderatorTest.createInputRow("2000", "qux", 4), null).getNumRowsInSegment());
            Assert.assertEquals(IDENTIFIERS.subList(0, 2), appenderator.getSegments().stream().sorted().collect(Collectors.toList()));
            Assert.assertEquals((long)2L, (long)appenderator.getRowCount(IDENTIFIERS.get(0)));
            Assert.assertEquals((long)1L, (long)appenderator.getRowCount(IDENTIFIERS.get(1)));
            boolean thrown = false;
            try {
                appenderator.getRowCount(IDENTIFIERS.get(2));
            }
            catch (IllegalStateException e) {
                thrown = true;
            }
            Assert.assertTrue((boolean)thrown);
            SegmentsAndCommitMetadata segmentsAndCommitMetadata = (SegmentsAndCommitMetadata)appenderator.push((Collection)appenderator.getSegments(), null, false).get();
            Assert.assertEquals(IDENTIFIERS.subList(0, 2), Lists.transform((List)segmentsAndCommitMetadata.getSegments(), (Function)new Function<DataSegment, SegmentIdWithShardSpec>(){

                public SegmentIdWithShardSpec apply(DataSegment input) {
                    return SegmentIdWithShardSpec.fromDataSegment((DataSegment)input);
                }
            }).stream().sorted().collect(Collectors.toList()));
            Assert.assertEquals(tester.getPushedSegments().stream().sorted().collect(Collectors.toList()), segmentsAndCommitMetadata.getSegments().stream().sorted().collect(Collectors.toList()));
            appenderator.clear();
            Assert.assertTrue((boolean)appenderator.getSegments().isEmpty());
        }
    }

    @Test
    public void testSimpleIngestionWithIndexesMapped() throws Exception {
        try (OpenAndClosedSegmentsAppenderatorTester tester = new OpenAndClosedSegmentsAppenderatorTester(2, false, true);){
            Appenderator appenderator = tester.getAppenderator();
            Assert.assertEquals(null, (Object)appenderator.startJob());
            Assert.assertEquals((Object)"foo", (Object)appenderator.getDataSource());
            Assert.assertEquals((long)1L, (long)appenderator.add(IDENTIFIERS.get(0), OpenAndClosedSegmentsBatchAppenderatorTest.createInputRow("2000", "foo", 1), null).getNumRowsInSegment());
            Assert.assertEquals((long)2L, (long)appenderator.add(IDENTIFIERS.get(0), OpenAndClosedSegmentsBatchAppenderatorTest.createInputRow("2000", "bar", 2), null).getNumRowsInSegment());
            Assert.assertEquals((long)1L, (long)appenderator.add(IDENTIFIERS.get(1), OpenAndClosedSegmentsBatchAppenderatorTest.createInputRow("2000", "qux", 4), null).getNumRowsInSegment());
            Assert.assertEquals(IDENTIFIERS.subList(0, 2), appenderator.getSegments().stream().sorted().collect(Collectors.toList()));
            Assert.assertEquals((long)2L, (long)appenderator.getRowCount(IDENTIFIERS.get(0)));
            Assert.assertEquals((long)1L, (long)appenderator.getRowCount(IDENTIFIERS.get(1)));
            boolean thrown = false;
            try {
                appenderator.getRowCount(IDENTIFIERS.get(2));
            }
            catch (IllegalStateException e) {
                thrown = true;
            }
            Assert.assertTrue((boolean)thrown);
            SegmentsAndCommitMetadata segmentsAndCommitMetadata = (SegmentsAndCommitMetadata)appenderator.push((Collection)appenderator.getSegments(), null, false).get();
            Assert.assertEquals(IDENTIFIERS.subList(0, 2), Lists.transform((List)segmentsAndCommitMetadata.getSegments(), (Function)new Function<DataSegment, SegmentIdWithShardSpec>(){

                public SegmentIdWithShardSpec apply(DataSegment input) {
                    return SegmentIdWithShardSpec.fromDataSegment((DataSegment)input);
                }
            }).stream().sorted().collect(Collectors.toList()));
            Assert.assertEquals(tester.getPushedSegments().stream().sorted().collect(Collectors.toList()), segmentsAndCommitMetadata.getSegments().stream().sorted().collect(Collectors.toList()));
            appenderator.clear();
            Assert.assertTrue((boolean)appenderator.getSegments().isEmpty());
        }
    }

    private static SegmentIdWithShardSpec createSegmentId(String interval, String version, int partitionNum) {
        return new SegmentIdWithShardSpec("foo", Intervals.of((String)interval), version, (ShardSpec)new LinearShardSpec(Integer.valueOf(partitionNum)));
    }

    static InputRow createInputRow(String ts, String dim, Object met) {
        return new MapBasedInputRow(DateTimes.of((String)ts).getMillis(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)dim, (Object)"met", (Object)met));
    }
}

