/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import java.util.concurrent.Executor;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.segment.handoff.SegmentHandoffNotifier;
import org.apache.druid.segment.handoff.SegmentHandoffNotifierFactory;
import org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.druid.segment.realtime.SegmentPublisher;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorPlumber;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.StreamAppenderatorTest;
import org.apache.druid.segment.realtime.appenderator.StreamAppenderatorTester;
import org.apache.druid.segment.realtime.plumber.IntervalStartVersioningPolicy;
import org.apache.druid.segment.realtime.plumber.NoopRejectionPolicyFactory;
import org.apache.druid.segment.realtime.plumber.RejectionPolicyFactory;
import org.apache.druid.segment.realtime.plumber.VersioningPolicy;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class AppenderatorPlumberTest {
    private final AppenderatorPlumber plumber;
    private final StreamAppenderatorTester streamAppenderatorTester = new StreamAppenderatorTester(10);

    public AppenderatorPlumberTest() throws Exception {
        DataSegmentAnnouncer segmentAnnouncer = (DataSegmentAnnouncer)EasyMock.createMock(DataSegmentAnnouncer.class);
        segmentAnnouncer.announceSegment((DataSegment)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        SegmentPublisher segmentPublisher = (SegmentPublisher)EasyMock.createNiceMock(SegmentPublisher.class);
        SegmentHandoffNotifierFactory handoffNotifierFactory = (SegmentHandoffNotifierFactory)EasyMock.createNiceMock(SegmentHandoffNotifierFactory.class);
        SegmentHandoffNotifier handoffNotifier = (SegmentHandoffNotifier)EasyMock.createNiceMock(SegmentHandoffNotifier.class);
        EasyMock.expect((Object)handoffNotifierFactory.createSegmentHandoffNotifier(EasyMock.anyString())).andReturn((Object)handoffNotifier).anyTimes();
        EasyMock.expect((Object)handoffNotifier.registerSegmentHandoffCallback((SegmentDescriptor)EasyMock.anyObject(), (Executor)EasyMock.anyObject(), (Runnable)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        RealtimeTuningConfig tuningConfig = new RealtimeTuningConfig(null, Integer.valueOf(1), null, null, null, null, null, (VersioningPolicy)new IntervalStartVersioningPolicy(), (RejectionPolicyFactory)new NoopRejectionPolicyFactory(), null, null, null, null, 0, 0, Boolean.valueOf(false), null, null, null, null);
        this.plumber = new AppenderatorPlumber(this.streamAppenderatorTester.getSchema(), tuningConfig, this.streamAppenderatorTester.getMetrics(), segmentAnnouncer, segmentPublisher, handoffNotifier, this.streamAppenderatorTester.getAppenderator());
    }

    @Test
    public void testSimpleIngestion() throws Exception {
        Appenderator appenderator = this.streamAppenderatorTester.getAppenderator();
        Assert.assertEquals(null, (Object)this.plumber.startJob());
        Assert.assertEquals((Object)"foo", (Object)appenderator.getDataSource());
        InputRow[] rows = new InputRow[]{StreamAppenderatorTest.ir("2000", "foo", 1), StreamAppenderatorTest.ir("2000", "bar", 2), StreamAppenderatorTest.ir("2000", "qux", 4)};
        Assert.assertEquals((long)1L, (long)this.plumber.add(rows[0], null).getRowCount());
        Assert.assertEquals((long)2L, (long)this.plumber.add(rows[1], null).getRowCount());
        Assert.assertEquals((long)3L, (long)this.plumber.add(rows[2], null).getRowCount());
        Assert.assertEquals((long)1L, (long)this.plumber.getSegmentsView().size());
        SegmentIdWithShardSpec si = this.plumber.getSegmentsView().values().toArray(new SegmentIdWithShardSpec[0])[0];
        Assert.assertEquals((long)3L, (long)appenderator.getRowCount(si));
        appenderator.clear();
        Assert.assertTrue((boolean)appenderator.getSegments().isEmpty());
        this.plumber.dropSegment(si);
        this.plumber.finishJob();
    }
}

