/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime;

import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FireDepartmentMetricsTest {
    private FireDepartmentMetrics metrics;

    @Before
    public void setup() {
        this.metrics = new FireDepartmentMetrics();
    }

    @Test
    public void testSnapshotBeforeProcessing() {
        Assert.assertEquals((long)0L, (long)this.metrics.snapshot().messageGap());
    }

    @Test
    public void testSnapshotAfterProcessingOver() {
        this.metrics.reportMessageMaxTimestamp(10L);
        this.metrics.markProcessingDone(30L);
        Assert.assertEquals((long)20L, (long)this.metrics.snapshot().messageGap());
    }

    @Test
    public void testSnapshotBeforeProcessingOver() {
        this.metrics.reportMessageMaxTimestamp(10L);
        long current = System.currentTimeMillis();
        long messageGap = this.metrics.snapshot().messageGap();
        Assert.assertTrue((String)("Message gap: " + messageGap), (messageGap >= current - 10L ? 1 : 0) != 0);
    }

    @Test
    public void testProcessingOverAfterSnapshot() {
        this.metrics.reportMessageMaxTimestamp(10L);
        this.metrics.snapshot();
        this.metrics.markProcessingDone(20L);
        Assert.assertEquals((long)10L, (long)this.metrics.snapshot().messageGap());
    }

    @Test
    public void testProcessingOverWithSystemTime() {
        this.metrics.reportMessageMaxTimestamp(10L);
        long current = System.currentTimeMillis();
        this.metrics.markProcessingDone();
        long completionTime = this.metrics.processingCompletionTime();
        Assert.assertTrue((String)("Completion time: " + completionTime), (completionTime >= current && completionTime < current + 10000L ? 1 : 0) != 0);
    }
}

