/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.ObjectMetadata;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.DimensionRangeShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedPartialShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwritePartialShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwriteShardSpec;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class IndexerSQLMetadataStorageCoordinatorTest {
    private static final int MAX_SQL_MEATADATA_RETRY_FOR_TEST = 2;
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();
    private final DataSegment defaultSegment = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    private final DataSegment eternitySegment = new DataSegment("fooDataSource", Intervals.ETERNITY, "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    private final DataSegment firstHalfEternityRangeSegment = new DataSegment("fooDataSource", new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"3000")), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    private final DataSegment secondHalfEternityRangeSegment = new DataSegment("fooDataSource", new Interval((ReadableInstant)DateTimes.of((String)"1970"), (ReadableInstant)DateTimes.MAX), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    private final DataSegment defaultSegment2 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 100L);
    private final DataSegment defaultSegment3 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-03T00Z/2015-01-04T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 100L);
    private final DataSegment defaultSegment4 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment0of0 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment1of0 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(1, 0), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment2of0 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(2, 0), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment2of1 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(2, 1), Integer.valueOf(9), 100L);
    private final DataSegment numberedSegment3of1 = new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(3, 1), Integer.valueOf(9), 100L);
    private final DataSegment existingSegment1 = new DataSegment("fooDataSource", Intervals.of((String)"1994-01-01T00Z/1994-01-02T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(1, 1), Integer.valueOf(9), 100L);
    private final DataSegment existingSegment2 = new DataSegment("fooDataSource", Intervals.of((String)"1994-01-02T00Z/1994-01-03T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(1, 1), Integer.valueOf(9), 100L);
    private final DataSegment hugeTimeRangeSegment1 = new DataSegment("hugeTimeRangeDataSource", Intervals.of((String)"-9994-01-02T00Z/1994-01-03T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
    private final DataSegment hugeTimeRangeSegment2 = new DataSegment("hugeTimeRangeDataSource", Intervals.of((String)"2994-01-02T00Z/2994-01-03T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
    private final DataSegment hugeTimeRangeSegment3 = new DataSegment("hugeTimeRangeDataSource", Intervals.of((String)"29940-01-02T00Z/29940-01-03T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
    private final DataSegment hugeTimeRangeSegment4 = new DataSegment("hugeTimeRangeDataSource", Intervals.of((String)"1990-01-01T00Z/19940-01-01T00Z"), "zversion", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new NumberedShardSpec(0, 1), Integer.valueOf(9), 100L);
    private final Set<DataSegment> SEGMENTS = ImmutableSet.of((Object)this.defaultSegment, (Object)this.defaultSegment2);
    private final AtomicLong metadataUpdateCounter = new AtomicLong();
    private final AtomicLong segmentTableDropUpdateCounter = new AtomicLong();
    private IndexerSQLMetadataStorageCoordinator coordinator;
    private TestDerbyConnector derbyConnector;

    @Before
    public void setUp() {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        this.mapper.registerSubtypes(new Class[]{LinearShardSpec.class, NumberedShardSpec.class, HashBasedNumberedShardSpec.class});
        this.derbyConnector.createDataSourceTable();
        this.derbyConnector.createTaskTables();
        this.derbyConnector.createSegmentTable();
        this.derbyConnector.createPendingSegmentsTable();
        this.metadataUpdateCounter.set(0L);
        this.segmentTableDropUpdateCounter.set(0L);
        this.coordinator = new IndexerSQLMetadataStorageCoordinator(this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector){

            protected IndexerSQLMetadataStorageCoordinator.DataStoreMetadataUpdateResult updateDataSourceMetadataWithHandle(Handle handle, String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) throws IOException {
                IndexerSQLMetadataStorageCoordinatorTest.this.metadataUpdateCounter.getAndIncrement();
                return super.updateDataSourceMetadataWithHandle(handle, dataSource, startMetadata, endMetadata);
            }

            protected IndexerSQLMetadataStorageCoordinator.DataStoreMetadataUpdateResult dropSegmentsWithHandle(Handle handle, Collection<DataSegment> segmentsToDrop, String dataSource) {
                IndexerSQLMetadataStorageCoordinatorTest.this.segmentTableDropUpdateCounter.getAndIncrement();
                return super.dropSegmentsWithHandle(handle, segmentsToDrop, dataSource);
            }

            public int getSqlMetadataMaxRetry() {
                return 2;
            }
        };
    }

    private void markAllSegmentsUnused() {
        this.markAllSegmentsUnused(this.SEGMENTS);
    }

    private void markAllSegmentsUnused(Set<DataSegment> segments) {
        for (final DataSegment segment : segments) {
            Assert.assertEquals((long)1L, (long)((Integer)this.derbyConnector.getDBI().withHandle((HandleCallback)new HandleCallback<Integer>(){

                public Integer withHandle(Handle handle) {
                    String request = StringUtils.format((String)"UPDATE %s SET used = false WHERE id = :id", (Object[])new Object[]{((MetadataStorageTablesConfig)IndexerSQLMetadataStorageCoordinatorTest.this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable()});
                    return ((Update)handle.createStatement(request).bind("id", segment.getId().toString())).execute();
                }
            })).intValue());
        }
    }

    private void markAllSegmentsUsed(Set<DataSegment> segments) {
        for (final DataSegment segment : segments) {
            Assert.assertEquals((long)1L, (long)((Integer)this.derbyConnector.getDBI().withHandle((HandleCallback)new HandleCallback<Integer>(){

                public Integer withHandle(Handle handle) {
                    String request = StringUtils.format((String)"UPDATE %s SET used = true WHERE id = :id", (Object[])new Object[]{((MetadataStorageTablesConfig)IndexerSQLMetadataStorageCoordinatorTest.this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable()});
                    return ((Update)handle.createStatement(request).bind("id", segment.getId().toString())).execute();
                }
            })).intValue());
        }
    }

    private List<String> retrievePendingSegmentIds() {
        final String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getPendingSegmentsTable();
        return (List)this.derbyConnector.retryWithHandle((HandleCallback)new HandleCallback<List<String>>(){

            public List<String> withHandle(Handle handle) {
                return handle.createQuery("SELECT id FROM " + table + "  ORDER BY id").map((ResultSetMapper)StringMapper.FIRST).list();
            }
        });
    }

    private List<String> retrieveUsedSegmentIds() {
        final String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        return (List)this.derbyConnector.retryWithHandle((HandleCallback)new HandleCallback<List<String>>(){

            public List<String> withHandle(Handle handle) {
                return handle.createQuery("SELECT id FROM " + table + " WHERE used = true ORDER BY id").map((ResultSetMapper)StringMapper.FIRST).list();
            }
        });
    }

    private List<String> retrieveUnusedSegmentIds() {
        final String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        return (List)this.derbyConnector.retryWithHandle((HandleCallback)new HandleCallback<List<String>>(){

            public List<String> withHandle(Handle handle) {
                return handle.createQuery("SELECT id FROM " + table + " WHERE used = false ORDER BY id").map((ResultSetMapper)StringMapper.FIRST).list();
            }
        });
    }

    private Boolean insertUsedSegments(final Set<DataSegment> dataSegments) {
        final String table = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        return (Boolean)this.derbyConnector.retryWithHandle((HandleCallback)new HandleCallback<Boolean>(){

            public Boolean withHandle(Handle handle) throws Exception {
                PreparedBatch preparedBatch = handle.prepareBatch(StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)", (Object[])new Object[]{table, IndexerSQLMetadataStorageCoordinatorTest.this.derbyConnector.getQuoteString()}));
                for (DataSegment segment : dataSegments) {
                    ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)preparedBatch.add().bind("id", segment.getId().toString())).bind("dataSource", segment.getDataSource())).bind("created_date", DateTimes.nowUtc().toString())).bind("start", segment.getInterval().getStart().toString())).bind("end", segment.getInterval().getEnd().toString())).bind("partitioned", !(segment.getShardSpec() instanceof NoneShardSpec))).bind("version", segment.getVersion())).bind("used", true)).bind("payload", IndexerSQLMetadataStorageCoordinatorTest.this.mapper.writeValueAsBytes((Object)segment));
                }
                int[] affectedRows = preparedBatch.execute();
                boolean succeeded = Arrays.stream(affectedRows).allMatch(eachAffectedRows -> eachAffectedRows == 1);
                if (!succeeded) {
                    throw new ISE("Failed to publish segments to DB", new Object[0]);
                }
                return true;
            }
        });
    }

    @Test
    public void testSimpleAnnounce() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        for (DataSegment segment : this.SEGMENTS) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment.getId().toString()));
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)this.defaultSegment.getId().toString(), (Object)this.defaultSegment2.getId().toString()), this.retrieveUsedSegmentIds());
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testAnnounceHistoricalSegments() throws IOException {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (int i = 0; i < 105; ++i) {
            segments.add(new DataSegment("fooDataSource", Intervals.of((String)"2015-01-01T00Z/2015-01-02T00Z"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(i)), Integer.valueOf(9), 100L));
        }
        this.coordinator.announceHistoricalSegments(segments);
        for (DataSegment segment2 : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment2.getId().toString()));
        }
        List segmentIds = segments.stream().map(segment -> segment.getId().toString()).collect(Collectors.toList());
        segmentIds.sort(Comparator.naturalOrder());
        Assert.assertEquals(segmentIds, this.retrieveUsedSegmentIds());
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testOvershadowingAnnounce() throws IOException {
        ImmutableSet segments = ImmutableSet.of((Object)this.defaultSegment, (Object)this.defaultSegment2, (Object)this.defaultSegment4);
        this.coordinator.announceHistoricalSegments((Set)segments);
        for (DataSegment segment : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment.getId().toString()));
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)this.defaultSegment4.getId().toString()), this.retrieveUsedSegmentIds());
    }

    @Test
    public void testTransactionalAnnounceSuccess() throws IOException {
        SegmentPublishResult result1 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment)), (Object)result1);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment.getId().toString()));
        SegmentPublishResult result2 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment2), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment2)), (Object)result2);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment2.getId().toString()));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)2L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceRetryAndSuccess() throws IOException {
        final AtomicLong attemptCounter = new AtomicLong();
        IndexerSQLMetadataStorageCoordinator failOnceCoordinator = new IndexerSQLMetadataStorageCoordinator(this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector){

            protected IndexerSQLMetadataStorageCoordinator.DataStoreMetadataUpdateResult updateDataSourceMetadataWithHandle(Handle handle, String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) throws IOException {
                IndexerSQLMetadataStorageCoordinatorTest.this.metadataUpdateCounter.getAndIncrement();
                if (attemptCounter.getAndIncrement() == 0L) {
                    return IndexerSQLMetadataStorageCoordinator.DataStoreMetadataUpdateResult.TRY_AGAIN;
                }
                return super.updateDataSourceMetadataWithHandle(handle, dataSource, startMetadata, endMetadata);
            }
        };
        SegmentPublishResult result1 = failOnceCoordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment)), (Object)result1);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment.getId().toString()));
        attemptCounter.set(0L);
        SegmentPublishResult result2 = failOnceCoordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment2), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment2)), (Object)result2);
        Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)this.defaultSegment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", this.defaultSegment2.getId().toString()));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")), (Object)failOnceCoordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)4L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceFailDbNullWantNotNull() throws IOException {
        SegmentPublishResult result1 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"java.lang.RuntimeException: Aborting transaction!"), (Object)result1);
        Assert.assertEquals((long)1L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceFailSegmentDropFailWithoutRetry() throws IOException {
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)this.existingSegment1, (Object)this.existingSegment2));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.existingSegment1.getId().toString(), (Object)this.existingSegment2.getId().toString()), this.retrieveUsedSegmentIds());
        DataSegment dataSegmentBar = DataSegment.builder().dataSource("bar").interval(Intervals.of((String)"2001/P1D")).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).version("b").size(0L).build();
        ImmutableSet dropSegments = ImmutableSet.of((Object)this.existingSegment1, (Object)this.existingSegment2, (Object)dataSegmentBar);
        SegmentPublishResult result1 = this.coordinator.announceHistoricalSegments(this.SEGMENTS, (Set)dropSegments, null, null);
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"java.lang.RuntimeException: Aborting transaction!"), (Object)result1);
        Assert.assertEquals((long)1L, (long)this.segmentTableDropUpdateCounter.get());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.existingSegment1.getId().toString(), (Object)this.existingSegment2.getId().toString()), this.retrieveUsedSegmentIds());
    }

    @Test
    public void testTransactionalAnnounceSucceedWithSegmentDrop() throws IOException {
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)this.existingSegment1, (Object)this.existingSegment2));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.existingSegment1.getId().toString(), (Object)this.existingSegment2.getId().toString()), this.retrieveUsedSegmentIds());
        SegmentPublishResult result1 = this.coordinator.announceHistoricalSegments(this.SEGMENTS, (Set)ImmutableSet.of((Object)this.existingSegment1, (Object)this.existingSegment2), null, null);
        Assert.assertEquals((Object)SegmentPublishResult.ok(this.SEGMENTS), (Object)result1);
        for (DataSegment segment : this.SEGMENTS) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment.getId().toString()));
        }
        Assert.assertEquals((Object)ImmutableList.of((Object)this.defaultSegment.getId().toString(), (Object)this.defaultSegment2.getId().toString()), this.retrieveUsedSegmentIds());
    }

    @Test
    public void testTransactionalAnnounceFailSegmentDropFailWithRetry() throws IOException {
        this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)this.existingSegment1, (Object)this.existingSegment2));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.existingSegment1.getId().toString(), (Object)this.existingSegment2.getId().toString()), this.retrieveUsedSegmentIds());
        DataSegment nonExistingSegment = this.defaultSegment4;
        ImmutableSet dropSegments = ImmutableSet.of((Object)this.existingSegment1, (Object)nonExistingSegment);
        SegmentPublishResult result1 = this.coordinator.announceHistoricalSegments(this.SEGMENTS, (Set)dropSegments, null, null);
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"org.apache.druid.metadata.RetryTransactionException: Aborting transaction!"), (Object)result1);
        Assert.assertEquals((long)2L, (long)this.segmentTableDropUpdateCounter.get());
        Assert.assertEquals((Object)ImmutableList.of((Object)this.existingSegment1.getId().toString(), (Object)this.existingSegment2.getId().toString()), this.retrieveUsedSegmentIds());
    }

    @Test
    public void testTransactionalAnnounceFailDbNotNullWantNull() throws IOException {
        SegmentPublishResult result1 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment)), (Object)result1);
        SegmentPublishResult result2 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment2), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"java.lang.RuntimeException: Aborting transaction!"), (Object)result2);
        Assert.assertEquals((long)2L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testTransactionalAnnounceFailDbNotNullWantDifferent() throws IOException {
        SegmentPublishResult result1 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.ok((Set)ImmutableSet.of((Object)this.defaultSegment)), (Object)result1);
        SegmentPublishResult result2 = this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment2), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"qux")), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"baz")));
        Assert.assertEquals((Object)SegmentPublishResult.fail((String)"java.lang.RuntimeException: Aborting transaction!"), (Object)result2);
        Assert.assertEquals((long)2L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testSimpleUsedList() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testMultiIntervalUsedList() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment3));
        Assertions.assertThat((Iterable)this.coordinator.retrieveUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)this.defaultSegment.getInterval()), Segments.ONLY_VISIBLE)).containsOnlyOnce((Object[])this.SEGMENTS.toArray(new DataSegment[0]));
        Assertions.assertThat((Iterable)this.coordinator.retrieveUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)this.defaultSegment3.getInterval()), Segments.ONLY_VISIBLE)).containsOnlyOnce((Object[])new DataSegment[]{this.defaultSegment3});
        Assertions.assertThat((Iterable)this.coordinator.retrieveUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)this.defaultSegment.getInterval(), (Object)this.defaultSegment3.getInterval()), Segments.ONLY_VISIBLE)).containsOnlyOnce((Object[])new DataSegment[]{this.defaultSegment, this.defaultSegment2, this.defaultSegment3});
        Assertions.assertThat((Iterable)this.coordinator.retrieveUsedSegmentsForIntervals(this.defaultSegment.getDataSource(), (List)ImmutableList.of((Object)Intervals.of((String)"2015-01-03T00Z/2015-01-03T05Z"), (Object)Intervals.of((String)"2015-01-03T09Z/2015-01-04T00Z")), Segments.ONLY_VISIBLE)).containsOnlyOnce((Object[])new DataSegment[]{this.defaultSegment3});
    }

    @Test
    public void testSimpleUnusedList() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval())));
    }

    @Test
    public void testUsedOverlapLow() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        ImmutableSet actualSegments = ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), Intervals.of((String)"2014-12-31T23:59:59.999Z/2015-01-01T00:00:00.001Z"), Segments.ONLY_VISIBLE));
        Assert.assertEquals(this.SEGMENTS, (Object)actualSegments);
    }

    @Test
    public void testUsedOverlapHigh() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), Intervals.of((String)"2015-1-1T23:59:59.999Z/2015-02-01T00Z"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUsedOutOfBoundsLow() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertTrue((boolean)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart().minus(1L), (ReadableInstant)this.defaultSegment.getInterval().getStart()), Segments.ONLY_VISIBLE).isEmpty());
    }

    @Test
    public void testUsedOutOfBoundsHigh() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertTrue((boolean)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getEnd(), (ReadableInstant)this.defaultSegment.getInterval().getEnd().plusDays(10)), Segments.ONLY_VISIBLE).isEmpty());
    }

    @Test
    public void testUsedWithinBoundsEnd() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().minusMillis(1)), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUsedOverlapEnd() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().plusMillis(1)), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUnusedOverlapLow() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertTrue((boolean)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart().minus(1L), (ReadableInstant)this.defaultSegment.getInterval().getStart().plus(1L))).isEmpty());
    }

    @Test
    public void testUnusedUnderlapLow() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertTrue((boolean)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart().plus(1L), (ReadableInstant)this.defaultSegment.getInterval().getEnd())).isEmpty());
    }

    @Test
    public void testUnusedUnderlapHigh() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertTrue((boolean)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), new Interval((ReadableInstant)this.defaultSegment.getInterval().getStart(), (ReadableInstant)this.defaultSegment.getInterval().getEnd().minus(1L))).isEmpty());
    }

    @Test
    public void testUnusedOverlapHigh() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertTrue((boolean)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withStart((ReadableInstant)this.defaultSegment.getInterval().getEnd().minus(1L))).isEmpty());
    }

    @Test
    public void testUnusedBigOverlap() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), Intervals.of((String)"2000/2999"))));
    }

    @Test
    public void testUnusedLowRange() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withStart((ReadableInstant)this.defaultSegment.getInterval().getStart().minus(1L)))));
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withStart((ReadableInstant)this.defaultSegment.getInterval().getStart().minusYears(1)))));
    }

    @Test
    public void testUnusedHighRange() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        this.markAllSegmentsUnused();
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().plus(1L)))));
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval().withEnd((ReadableInstant)this.defaultSegment.getInterval().getEnd().plusYears(1)))));
    }

    @Test
    public void testUsedHugeTimeRangeEternityFilter() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.hugeTimeRangeSegment1, (Object)this.hugeTimeRangeSegment2, (Object)this.hugeTimeRangeSegment3));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.hugeTimeRangeSegment1, (Object)this.hugeTimeRangeSegment2, (Object)this.hugeTimeRangeSegment3), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForIntervals(this.hugeTimeRangeSegment1.getDataSource(), (List)Intervals.ONLY_ETERNITY, Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUsedHugeTimeRangeTrickyFilter1() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.hugeTimeRangeSegment1, (Object)this.hugeTimeRangeSegment2, (Object)this.hugeTimeRangeSegment3));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.hugeTimeRangeSegment2), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.hugeTimeRangeSegment1.getDataSource(), Intervals.of((String)"2900/10000"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testUsedHugeTimeRangeTrickyFilter2() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.hugeTimeRangeSegment1, (Object)this.hugeTimeRangeSegment2, (Object)this.hugeTimeRangeSegment3));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.hugeTimeRangeSegment2), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.hugeTimeRangeSegment1.getDataSource(), Intervals.of((String)"2993/2995"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testEternitySegmentWithStringComparison() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.eternitySegment));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.eternitySegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.eternitySegment.getDataSource(), Intervals.of((String)"2020/2021"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testEternityMultipleSegmentWithStringComparison() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.eternitySegment));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.eternitySegment, (Object)this.numberedSegment0of0), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.eternitySegment.getDataSource(), Intervals.of((String)"2015/2016"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testFirstHalfEternitySegmentWithStringComparison() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.firstHalfEternityRangeSegment));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.firstHalfEternityRangeSegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.firstHalfEternityRangeSegment.getDataSource(), Intervals.of((String)"2020/2021"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testFirstHalfEternityMultipleSegmentWithStringComparison() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.firstHalfEternityRangeSegment));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.firstHalfEternityRangeSegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.firstHalfEternityRangeSegment.getDataSource(), Intervals.of((String)"2015/2016"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testSecondHalfEternitySegmentWithStringComparison() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.secondHalfEternityRangeSegment));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.secondHalfEternityRangeSegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.secondHalfEternityRangeSegment.getDataSource(), Intervals.of((String)"2020/2021"), Segments.ONLY_VISIBLE)));
    }

    @Ignore
    @Test
    public void testLargeIntervalWithStringComparison() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.hugeTimeRangeSegment4));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.hugeTimeRangeSegment4), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.hugeTimeRangeSegment4.getDataSource(), Intervals.of((String)"2020/2021"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testSecondHalfEternityMultipleSegmentWithStringComparison() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.secondHalfEternityRangeSegment));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.secondHalfEternityRangeSegment), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.secondHalfEternityRangeSegment.getDataSource(), Intervals.of((String)"2015/2016"), Segments.ONLY_VISIBLE)));
    }

    @Test
    public void testDeleteDataSourceMetadata() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertFalse((String)"deleteInvalidDataSourceMetadata", (boolean)this.coordinator.deleteDataSourceMetadata("nonExistentDS"));
        Assert.assertTrue((String)"deleteValidDataSourceMetadata", (boolean)this.coordinator.deleteDataSourceMetadata("fooDataSource"));
        Assert.assertNull((String)"getDataSourceMetadataNullAfterDelete", (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
    }

    @Test
    public void testDeleteSegmentsInMetaDataStorage() throws IOException {
        this.coordinator.announceHistoricalSegments(this.SEGMENTS);
        Assert.assertEquals(this.SEGMENTS, (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE)));
        this.coordinator.deleteSegments(this.SEGMENTS);
        Assert.assertEquals((long)0L, (long)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUsedSegmentsForInterval(this.defaultSegment.getDataSource(), this.defaultSegment.getInterval(), Segments.ONLY_VISIBLE)).size());
    }

    @Test
    public void testSingleAdditionalNumberedShardWithNoCorePartitions() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment0of0));
    }

    @Test
    public void testMultipleAdditionalNumberedShardsWithNoCorePartitions() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment0of0, (Object)this.numberedSegment1of0, (Object)this.numberedSegment2of0));
    }

    @Test
    public void testSingleAdditionalNumberedShardWithOneCorePartition() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment2of1));
    }

    @Test
    public void testMultipleAdditionalNumberedShardsWithOneCorePartition() throws IOException {
        this.additionalNumberedShardTest((Set<DataSegment>)ImmutableSet.of((Object)this.numberedSegment2of1, (Object)this.numberedSegment3of1));
    }

    private void additionalNumberedShardTest(Set<DataSegment> segments) throws IOException {
        this.coordinator.announceHistoricalSegments(segments);
        for (DataSegment segment2 : segments) {
            Assert.assertArrayEquals((byte[])this.mapper.writeValueAsString((Object)segment2).getBytes(StandardCharsets.UTF_8), (byte[])this.derbyConnector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "id", "payload", segment2.getId().toString()));
        }
        Assert.assertEquals(segments.stream().map(segment -> segment.getId().toString()).collect(Collectors.toList()), this.retrieveUsedSegmentIds());
        Assert.assertEquals((long)0L, (long)this.metadataUpdateCounter.get());
    }

    @Test
    public void testAllocatePendingSegment() {
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, "version", false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version", (Object)identifier.toString());
        SegmentIdWithShardSpec identifier1 = this.coordinator.allocatePendingSegment("ds", "seq", identifier.toString(), interval, (PartialShardSpec)partialShardSpec, identifier.getVersion(), false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_1", (Object)identifier1.toString());
        SegmentIdWithShardSpec identifier2 = this.coordinator.allocatePendingSegment("ds", "seq", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, identifier1.getVersion(), false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_2", (Object)identifier2.toString());
        SegmentIdWithShardSpec identifier3 = this.coordinator.allocatePendingSegment("ds", "seq", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, identifier1.getVersion(), false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_2", (Object)identifier3.toString());
        Assert.assertEquals((Object)identifier2, (Object)identifier3);
        SegmentIdWithShardSpec identifier4 = this.coordinator.allocatePendingSegment("ds", "seq1", null, interval, (PartialShardSpec)partialShardSpec, "version", false);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_3", (Object)identifier4.toString());
    }

    @Test
    public void testAllocatePendingSegmentAfterDroppingExistingSegment() {
        String maxVersion = "version_newer_newer";
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, "version", true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version", (Object)identifier.toString());
        SegmentIdWithShardSpec identifier1 = this.coordinator.allocatePendingSegment("ds", "seq2", identifier.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_1", (Object)identifier1.toString());
        SegmentIdWithShardSpec identifier2 = this.coordinator.allocatePendingSegment("ds", "seq3", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_2", (Object)identifier2.toString());
        DataSegment segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "version_new", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        List<String> ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_new", (Object)ids.get(0));
        SegmentIdWithShardSpec identifier3 = this.coordinator.allocatePendingSegment("ds", "seq4", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_new_1", (Object)identifier3.toString());
        this.markAllSegmentsUnused((Set<DataSegment>)ImmutableSet.of((Object)segment));
        SegmentIdWithShardSpec identifier4 = this.coordinator.allocatePendingSegment("ds", "seq5", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version_new_2", (Object)identifier4.toString());
    }

    @Test
    public void testAnotherAllocatePendingSegmentAfterRevertingCompaction() {
        String maxVersion = "Z";
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, "A", true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A", (Object)identifier.toString());
        DataSegment segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        List<String> ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A", (Object)ids.get(0));
        SegmentIdWithShardSpec identifier1 = this.coordinator.allocatePendingSegment("ds", "seq2", identifier.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_1", (Object)identifier1.toString());
        segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_1", (Object)ids.get(1));
        SegmentIdWithShardSpec identifier2 = this.coordinator.allocatePendingSegment("ds", "seq3", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_2", (Object)identifier2.toString());
        segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(2)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_2", (Object)ids.get(2));
        DataSegment compactedSegment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "B", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)compactedSegment)));
        ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_B", (Object)ids.get(3));
        SegmentIdWithShardSpec identifier3 = this.coordinator.allocatePendingSegment("ds", "seq4", identifier2.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_B_1", (Object)identifier3.toString());
        this.markAllSegmentsUnused((Set<DataSegment>)ImmutableSet.of((Object)compactedSegment));
        List<String> pendings = this.retrievePendingSegmentIds();
        Assert.assertTrue((pendings.size() == 4 ? 1 : 0) != 0);
        List<String> used = this.retrieveUsedSegmentIds();
        Assert.assertTrue((used.size() == 3 ? 1 : 0) != 0);
        List<String> unused = this.retrieveUnusedSegmentIds();
        Assert.assertTrue((unused.size() == 1 ? 1 : 0) != 0);
        SegmentIdWithShardSpec identifier4 = this.coordinator.allocatePendingSegment("ds", "seq5", identifier1.toString(), interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_3", (Object)identifier4.toString());
        segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(3)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_3", (Object)ids.get(3));
    }

    @Test
    public void testNoPendingSegmentsAndOneUsedSegment() {
        String maxVersion = "Z";
        DataSegment segment = new DataSegment("ds", Intervals.of((String)"2017-01-01T00Z/2017-02-01T00Z"), "A", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)"dim1"), (List)ImmutableList.of((Object)"m1"), (ShardSpec)new LinearShardSpec(Integer.valueOf(0)), Integer.valueOf(9), 100L);
        Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)segment)));
        List<String> ids = this.retrieveUsedSegmentIds();
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A", (Object)ids.get(0));
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, maxVersion, true);
        Assert.assertEquals((Object)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_A_1", (Object)identifier.toString());
    }

    @Test
    public void testDeletePendingSegment() throws InterruptedException {
        NumberedPartialShardSpec partialShardSpec = NumberedPartialShardSpec.instance();
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        String prevSegmentId = null;
        DateTime begin = DateTimes.nowUtc();
        for (int i = 0; i < 10; ++i) {
            SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", prevSegmentId, interval, (PartialShardSpec)partialShardSpec, "version", false);
            prevSegmentId = identifier.toString();
        }
        Thread.sleep(100L);
        DateTime secondBegin = DateTimes.nowUtc();
        for (int i = 0; i < 5; ++i) {
            SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", prevSegmentId, interval, (PartialShardSpec)partialShardSpec, "version", false);
            prevSegmentId = identifier.toString();
        }
        int numDeleted = this.coordinator.deletePendingSegmentsCreatedInInterval("ds", new Interval((ReadableInstant)begin, (ReadableInstant)secondBegin));
        Assert.assertEquals((long)10L, (long)numDeleted);
    }

    @Test
    public void testAllocatePendingSegmentsWithOvershadowingSegments() throws IOException {
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        String prevSegmentId = null;
        for (int i = 0; i < 10; ++i) {
            SegmentIdWithShardSpec identifier = this.coordinator.allocatePendingSegment("ds", "seq", prevSegmentId, interval, (PartialShardSpec)new NumberedOverwritePartialShardSpec(0, 1, (short)(i + 1)), "version", false);
            Assert.assertEquals((Object)StringUtils.format((String)"ds_2017-01-01T00:00:00.000Z_2017-02-01T00:00:00.000Z_version%s", (Object[])new Object[]{"_" + (i + 32768)}), (Object)identifier.toString());
            prevSegmentId = identifier.toString();
            Set<DataSegment> toBeAnnounced = Collections.singleton(new DataSegment(identifier.getDataSource(), identifier.getInterval(), identifier.getVersion(), null, Collections.emptyList(), Collections.emptyList(), (ShardSpec)((NumberedOverwriteShardSpec)identifier.getShardSpec()).withAtomicUpdateGroupSize(1), Integer.valueOf(0), 10L));
            Set announced = this.coordinator.announceHistoricalSegments(toBeAnnounced);
            Assert.assertEquals(toBeAnnounced, (Object)announced);
        }
        Collection visibleSegments = this.coordinator.retrieveUsedSegmentsForInterval("ds", interval, Segments.ONLY_VISIBLE);
        Assert.assertEquals((long)1L, (long)visibleSegments.size());
        Assert.assertEquals((Object)new DataSegment("ds", interval, "version", null, Collections.emptyList(), Collections.emptyList(), (ShardSpec)new NumberedOverwriteShardSpec(32777, 0, 1, 9, 1), Integer.valueOf(0), 10L), (Object)Iterables.getOnlyElement((Iterable)visibleSegments));
    }

    @Test
    public void testAllocatePendingSegmentsForHashBasedNumberedShardSpec() throws IOException {
        HashBasedNumberedPartialShardSpec partialShardSpec = new HashBasedNumberedPartialShardSpec(null, 2, 5, null);
        String dataSource = "ds";
        Interval interval = Intervals.of((String)"2017-01-01/2017-02-01");
        SegmentIdWithShardSpec id = this.coordinator.allocatePendingSegment("ds", "seq", null, interval, (PartialShardSpec)partialShardSpec, "version", true);
        HashBasedNumberedShardSpec shardSpec = (HashBasedNumberedShardSpec)id.getShardSpec();
        Assert.assertEquals((long)0L, (long)shardSpec.getPartitionNum());
        Assert.assertEquals((long)0L, (long)shardSpec.getNumCorePartitions());
        Assert.assertEquals((long)5L, (long)shardSpec.getNumBuckets());
        this.coordinator.announceHistoricalSegments(Collections.singleton(new DataSegment(id.getDataSource(), id.getInterval(), id.getVersion(), null, Collections.emptyList(), Collections.emptyList(), id.getShardSpec(), Integer.valueOf(0), 10L)));
        id = this.coordinator.allocatePendingSegment("ds", "seq2", null, interval, (PartialShardSpec)partialShardSpec, "version", true);
        shardSpec = (HashBasedNumberedShardSpec)id.getShardSpec();
        Assert.assertEquals((long)1L, (long)shardSpec.getPartitionNum());
        Assert.assertEquals((long)0L, (long)shardSpec.getNumCorePartitions());
        Assert.assertEquals((long)5L, (long)shardSpec.getNumBuckets());
        this.coordinator.announceHistoricalSegments(Collections.singleton(new DataSegment(id.getDataSource(), id.getInterval(), id.getVersion(), null, Collections.emptyList(), Collections.emptyList(), id.getShardSpec(), Integer.valueOf(0), 10L)));
        id = this.coordinator.allocatePendingSegment("ds", "seq3", null, interval, (PartialShardSpec)new HashBasedNumberedPartialShardSpec(null, 2, 3, null), "version", true);
        shardSpec = (HashBasedNumberedShardSpec)id.getShardSpec();
        Assert.assertEquals((long)2L, (long)shardSpec.getPartitionNum());
        Assert.assertEquals((long)0L, (long)shardSpec.getNumCorePartitions());
        Assert.assertEquals((long)3L, (long)shardSpec.getNumBuckets());
    }

    @Test
    public void testAddNumberedShardSpecAfterMultiDimensionsShardSpecWithUnknownCorePartitionSize() throws IOException {
        String datasource = "datasource";
        Interval interval = Intervals.of((String)"2020-01-01/P1D");
        String version = "version";
        ImmutableList dimensions = ImmutableList.of((Object)"dim");
        ImmutableList metrics = ImmutableList.of((Object)"met");
        HashSet<DataSegment> originalSegments = new HashSet<DataSegment>();
        for (int i = 0; i < 6; ++i) {
            originalSegments.add(new DataSegment("datasource", interval, "version", (Map)ImmutableMap.of(), (List)dimensions, (List)metrics, (ShardSpec)new DimensionRangeShardSpec(Collections.singletonList("dim"), i == 0 ? null : StringTuple.create((String[])new String[]{String.valueOf(i - 1)}), i == 5 ? null : StringTuple.create((String[])new String[]{String.valueOf(i)}), i, null), Integer.valueOf(9), 10L));
        }
        this.coordinator.announceHistoricalSegments(originalSegments);
        SegmentIdWithShardSpec id = this.coordinator.allocatePendingSegment("datasource", "seq", null, interval, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false);
        Assert.assertNull((Object)id);
    }

    @Test
    public void testAddNumberedShardSpecAfterSingleDimensionsShardSpecWithUnknownCorePartitionSize() throws IOException {
        String datasource = "datasource";
        Interval interval = Intervals.of((String)"2020-01-01/P1D");
        String version = "version";
        ImmutableList dimensions = ImmutableList.of((Object)"dim");
        ImmutableList metrics = ImmutableList.of((Object)"met");
        HashSet<DataSegment> originalSegments = new HashSet<DataSegment>();
        for (int i = 0; i < 6; ++i) {
            String start = i == 0 ? null : String.valueOf(i - 1);
            String end = i == 5 ? null : String.valueOf(i);
            originalSegments.add(new DataSegment("datasource", interval, "version", (Map)ImmutableMap.of(), (List)dimensions, (List)metrics, (ShardSpec)new SingleDimensionShardSpec("dim", start, end, i, null), Integer.valueOf(9), 10L));
        }
        this.coordinator.announceHistoricalSegments(originalSegments);
        SegmentIdWithShardSpec id = this.coordinator.allocatePendingSegment("datasource", "seq", null, interval, (PartialShardSpec)NumberedPartialShardSpec.instance(), "version", false);
        Assert.assertNull((Object)id);
    }

    @Test
    public void testDropSegmentsWithHandleForSegmentThatExist() {
        try (Handle handle = this.derbyConnector.getDBI().open();){
            Assert.assertTrue((boolean)this.insertUsedSegments((Set<DataSegment>)ImmutableSet.of((Object)this.defaultSegment)));
            List<String> usedSegments = this.retrieveUsedSegmentIds();
            Assert.assertEquals((long)1L, (long)usedSegments.size());
            Assert.assertEquals((Object)this.defaultSegment.getId().toString(), (Object)usedSegments.get(0));
            IndexerSQLMetadataStorageCoordinator.DataStoreMetadataUpdateResult result = this.coordinator.dropSegmentsWithHandle(handle, (Collection)ImmutableSet.of((Object)this.defaultSegment), this.defaultSegment.getDataSource());
            Assert.assertEquals((Object)IndexerSQLMetadataStorageCoordinator.DataStoreMetadataUpdateResult.SUCCESS, (Object)result);
            usedSegments = this.retrieveUsedSegmentIds();
            Assert.assertEquals((long)0L, (long)usedSegments.size());
        }
    }

    @Test
    public void testDropSegmentsWithHandleForSegmentThatDoesNotExist() {
        try (Handle handle = this.derbyConnector.getDBI().open();){
            IndexerSQLMetadataStorageCoordinator.DataStoreMetadataUpdateResult result = this.coordinator.dropSegmentsWithHandle(handle, (Collection)ImmutableSet.of((Object)this.defaultSegment), this.defaultSegment.getDataSource());
            Assert.assertEquals((Object)IndexerSQLMetadataStorageCoordinator.DataStoreMetadataUpdateResult.TRY_AGAIN, (Object)result);
        }
    }

    @Test
    public void testRemoveDataSourceMetadataOlderThanDatasourceActiveShouldNotBeDeleted() throws Exception {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        int deletedCount = this.coordinator.removeDataSourceMetadataOlderThan(System.currentTimeMillis(), (Set)ImmutableSet.of((Object)"fooDataSource"));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)0L, (long)deletedCount);
    }

    @Test
    public void testRemoveDataSourceMetadataOlderThanDatasourceNotActiveAndOlderThanTimeShouldBeDeleted() throws Exception {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        int deletedCount = this.coordinator.removeDataSourceMetadataOlderThan(System.currentTimeMillis(), (Set)ImmutableSet.of());
        Assert.assertNull((Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)1L, (long)deletedCount);
    }

    @Test
    public void testRemoveDataSourceMetadataOlderThanDatasourceNotActiveButNotOlderThanTimeShouldNotBeDeleted() throws Exception {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.defaultSegment), (Set)ImmutableSet.of(), (DataSourceMetadata)new ObjectMetadata(null), (DataSourceMetadata)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        int deletedCount = this.coordinator.removeDataSourceMetadataOlderThan(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis(), (Set)ImmutableSet.of());
        Assert.assertEquals((Object)new ObjectMetadata((Object)ImmutableMap.of((Object)"foo", (Object)"bar")), (Object)this.coordinator.retrieveDataSourceMetadata("fooDataSource"));
        Assert.assertEquals((long)0L, (long)deletedCount);
    }

    @Test
    public void testMarkSegmentsAsUnusedWithinIntervalOneYear() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.existingSegment1, (Object)this.existingSegment2));
        this.coordinator.markSegmentsAsUnusedWithinInterval(this.existingSegment1.getDataSource(), Intervals.of((String)"1994-01-01/1994-01-02T12Z"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.existingSegment1), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.existingSegment1.getDataSource(), this.existingSegment1.getInterval().withEnd((ReadableInstant)this.existingSegment1.getInterval().getEnd().plus(1L)))));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.existingSegment2.getDataSource(), this.existingSegment2.getInterval().withEnd((ReadableInstant)this.existingSegment2.getInterval().getEnd().plusYears(1)))));
    }

    @Test
    public void testMarkSegmentsAsUnusedWithinIntervalTwoYears() throws IOException {
        this.coordinator.announceHistoricalSegments((Set)ImmutableSet.of((Object)this.existingSegment1, (Object)this.existingSegment2));
        this.coordinator.markSegmentsAsUnusedWithinInterval(this.existingSegment1.getDataSource(), Intervals.of((String)"1993-12-31T12Z/1994-01-02T12Z"));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.existingSegment1), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.existingSegment1.getDataSource(), this.existingSegment1.getInterval().withEnd((ReadableInstant)this.existingSegment1.getInterval().getEnd().plus(1L)))));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)ImmutableSet.copyOf((Collection)this.coordinator.retrieveUnusedSegmentsForInterval(this.existingSegment2.getDataSource(), this.existingSegment2.getInterval().withEnd((ReadableInstant)this.existingSegment2.getInterval().getEnd().plusYears(1)))));
    }
}

