/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.DruidServiceTestUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.coordination.ServerType;
import org.junit.Assert;
import org.junit.Test;

public class DataNodeServiceTest {
    private final ObjectMapper mapper = DruidServiceTestUtils.newJsonMapper();

    @Test
    public void testSerde() throws Exception {
        DataNodeService expected = new DataNodeService("tier", 100L, ServerType.HISTORICAL, 1);
        DruidService actual = (DruidService)this.mapper.readValue(this.mapper.writeValueAsString((Object)expected), DruidService.class);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDeserializeWithDeprecatedServerTypeProperty() throws Exception {
        String json = "{\n  \"type\" : \"dataNodeService\",\n  \"tier\" : \"tier\",\n  \"maxSize\" : 100,\n  \"type\" : \"historical\",\n  \"priority\" : 1\n}";
        DruidService actual = (DruidService)this.mapper.readValue(json, DruidService.class);
        Assert.assertEquals((Object)new DataNodeService("tier", 100L, ServerType.HISTORICAL, 1), (Object)actual);
    }

    @Test
    public void testDeserializeWithServerTypeProperty() throws Exception {
        String json = "{\n  \"type\" : \"dataNodeService\",\n  \"tier\" : \"tier\",\n  \"maxSize\" : 100,\n  \"serverType\" : \"historical\",\n  \"priority\" : 1\n}";
        DruidService actual = (DruidService)this.mapper.readValue(json, DruidService.class);
        Assert.assertEquals((Object)new DataNodeService("tier", 100L, ServerType.HISTORICAL, 1), (Object)actual);
    }

    @Test
    public void testSerdeDeserializeWithBothDeprecatedAndNewServerTypes() throws Exception {
        String json = "{\n  \"type\" : \"dataNodeService\",\n  \"tier\" : \"tier\",\n  \"maxSize\" : 100,\n  \"type\" : \"historical\",\n  \"serverType\" : \"historical\",\n  \"priority\" : 1\n}";
        DruidService actual = (DruidService)this.mapper.readValue(json, DruidService.class);
        Assert.assertEquals((Object)new DataNodeService("tier", 100L, ServerType.HISTORICAL, 1), (Object)actual);
    }

    @Test
    public void testSerializeSubtypeKeyShouldAppearFirstInJson() throws JsonProcessingException {
        DataNodeService dataNodeService = new DataNodeService("tier", 100L, ServerType.HISTORICAL, 1);
        String json = this.mapper.writeValueAsString((Object)dataNodeService);
        Assert.assertTrue((boolean)json.startsWith(StringUtils.format((String)"{\"type\":\"%s\"", (Object[])new Object[]{"dataNodeService"})));
    }
}

