/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.client.indexing.ClientCompactionIntervalSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class ClientCompactionIntervalSpecTest {
    private final DataSegment dataSegment1 = new DataSegment("test", Intervals.of((String)"2015-04-11/2015-04-12"), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 11L);
    private final DataSegment dataSegment2 = new DataSegment("test", Intervals.of((String)"2015-04-12/2015-04-14"), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 11L);
    private final DataSegment dataSegment3 = new DataSegment("test", Intervals.of((String)"2015-02-12/2015-03-13"), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 11L);

    @Test
    public void testFromSegmentWithNoSegmentGranularity() {
        ClientCompactionIntervalSpec actual = ClientCompactionIntervalSpec.fromSegments((List)ImmutableList.of((Object)this.dataSegment1, (Object)this.dataSegment2, (Object)this.dataSegment3), null);
        Assert.assertEquals((Object)Intervals.of((String)"2015-02-12/2015-04-14"), (Object)actual.getInterval());
    }

    @Test
    public void testFromSegmentWitSegmentGranularitySameAsSegment() {
        ClientCompactionIntervalSpec actual = ClientCompactionIntervalSpec.fromSegments((List)ImmutableList.of((Object)this.dataSegment1), (Granularity)Granularities.DAY);
        Assert.assertEquals((Object)Intervals.of((String)"2015-04-11/2015-04-12"), (Object)actual.getInterval());
    }

    @Test
    public void testFromSegmentWithCoarserSegmentGranularity() {
        ClientCompactionIntervalSpec actual = ClientCompactionIntervalSpec.fromSegments((List)ImmutableList.of((Object)this.dataSegment1, (Object)this.dataSegment2, (Object)this.dataSegment3), (Granularity)Granularities.YEAR);
        Assert.assertEquals((Object)Intervals.of((String)"2015-01-01/2016-01-01"), (Object)actual.getInterval());
    }

    @Test
    public void testFromSegmentWithFinerSegmentGranularityAndUmbrellaIntervalAlign() {
        ClientCompactionIntervalSpec actual = ClientCompactionIntervalSpec.fromSegments((List)ImmutableList.of((Object)this.dataSegment1, (Object)this.dataSegment2, (Object)this.dataSegment3), (Granularity)Granularities.DAY);
        Assert.assertEquals((Object)Intervals.of((String)"2015-02-12/2015-04-14"), (Object)actual.getInterval());
    }

    @Test
    public void testFromSegmentWithFinerSegmentGranularityAndUmbrellaIntervalNotAlign() {
        ClientCompactionIntervalSpec actual = ClientCompactionIntervalSpec.fromSegments((List)ImmutableList.of((Object)this.dataSegment1, (Object)this.dataSegment2, (Object)this.dataSegment3), (Granularity)Granularities.WEEK);
        Assert.assertEquals((Object)Intervals.of((String)"2015-02-09/2015-04-20"), (Object)actual.getInterval());
    }
}

