/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.druid.client.DirectDruidClient;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.druid.client.selector.QueryableDruidServer;
import org.apache.druid.client.selector.RandomServerSelectorStrategy;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineLookup;
import org.apache.druid.timeline.VersionedIntervalTimeline;

public class SimpleServerView
implements TimelineServerView {
    private static final QueryWatcher NOOP_QUERY_WATCHER = (query, future) -> {};
    private final TierSelectorStrategy tierSelectorStrategy = new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy());
    private final Map<DruidServer, QueryableDruidServer> servers = new HashMap<DruidServer, QueryableDruidServer>();
    private final Map<String, ServerSelector> selectors = new HashMap<String, ServerSelector>();
    private final Map<String, VersionedIntervalTimeline<String, ServerSelector>> timelines = new HashMap<String, VersionedIntervalTimeline<String, ServerSelector>>();
    private final QueryToolChestWarehouse warehouse;
    private final ObjectMapper objectMapper;
    private final HttpClient httpClient;

    public SimpleServerView(QueryToolChestWarehouse warehouse, ObjectMapper objectMapper, HttpClient httpClient) {
        this.warehouse = warehouse;
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
    }

    public void addServer(DruidServer server, DataSegment dataSegment) {
        this.servers.put(server, new QueryableDruidServer(server, (QueryRunner)new DirectDruidClient(this.warehouse, NOOP_QUERY_WATCHER, this.objectMapper, this.httpClient, server.getScheme(), server.getHost(), (ServiceEmitter)new NoopServiceEmitter())));
        this.addSegmentToServer(server, dataSegment);
    }

    public void removeServer(DruidServer server) {
        this.servers.remove(server);
    }

    public void unannounceSegmentFromServer(DruidServer server, DataSegment segment) {
        QueryableDruidServer queryableDruidServer = this.servers.get(server);
        if (queryableDruidServer == null) {
            throw new ISE("Unknown server [%s]", new Object[]{server});
        }
        ServerSelector selector = this.selectors.get(segment.getId().toString());
        if (selector == null) {
            throw new ISE("Unknown segment [%s]", new Object[]{segment.getId()});
        }
        if (!selector.removeServer(queryableDruidServer)) {
            throw new ISE("Failed to remove segment[%s] from server[%s]", new Object[]{segment.getId(), server});
        }
        VersionedIntervalTimeline<String, ServerSelector> timeline = this.timelines.get(segment.getDataSource());
        if (timeline == null) {
            throw new ISE("Unknown datasource [%s]", new Object[]{segment.getDataSource()});
        }
        timeline.remove(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)selector));
    }

    private void addSegmentToServer(DruidServer server, DataSegment segment) {
        ServerSelector selector = this.selectors.computeIfAbsent(segment.getId().toString(), k -> new ServerSelector(segment, this.tierSelectorStrategy));
        selector.addServerAndUpdateSegment(this.servers.get(server), segment);
        this.timelines.computeIfAbsent(segment.getDataSource(), k -> new VersionedIntervalTimeline((Comparator)Ordering.natural(), true)).add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)selector));
    }

    public Optional<? extends TimelineLookup<String, ServerSelector>> getTimeline(DataSourceAnalysis analysis) {
        TableDataSource table = (TableDataSource)analysis.getBaseTableDataSource().orElseThrow(() -> new ISE("Cannot handle datasource: %s", new Object[]{analysis.getDataSource()}));
        return Optional.ofNullable(this.timelines.get(table.getName()));
    }

    public List<ImmutableDruidServer> getDruidServers() {
        return Collections.emptyList();
    }

    public <T> QueryRunner<T> getQueryRunner(DruidServer server) {
        QueryableDruidServer queryableDruidServer = (QueryableDruidServer)Preconditions.checkNotNull((Object)this.servers.get(server), (Object)"server");
        return queryableDruidServer.getQueryRunner();
    }

    public void registerTimelineCallback(Executor exec, TimelineServerView.TimelineCallback callback) {
    }

    public void registerServerRemovedCallback(Executor exec, ServerView.ServerRemovedCallback callback) {
    }

    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
    }

    public static DruidServer createServer(int nameSuiffix) {
        return new DruidServer("server_" + nameSuiffix, "127.0.0." + nameSuiffix, null, Long.MAX_VALUE, ServerType.HISTORICAL, "default", 0);
    }
}

