/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.core.io.JsonEOFException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.HashMap;
import org.apache.druid.client.BrokerInternalQueryConfig;
import org.apache.druid.guice.ConfigModule;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class BrokerInternalQueryConfigTest {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws Exception {
        String json = "{}";
        BrokerInternalQueryConfig config = (BrokerInternalQueryConfig)MAPPER.readValue(MAPPER.writeValueAsString(MAPPER.readValue(json, BrokerInternalQueryConfig.class)), BrokerInternalQueryConfig.class);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)config.getContext());
        json = "{ \"context\": {\"priority\": 5}}";
        config = (BrokerInternalQueryConfig)MAPPER.readValue(MAPPER.writeValueAsString(MAPPER.readValue(json, BrokerInternalQueryConfig.class)), BrokerInternalQueryConfig.class);
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        expected.put("priority", 5);
        Assert.assertEquals(expected, (Object)config.getContext());
    }

    @Test(expected=JsonEOFException.class)
    public void testMalfomattedContext() throws Exception {
        String malformedJson = "{\"priority: 5}";
        MAPPER.readValue(MAPPER.writeValueAsString(MAPPER.readValue(malformedJson, BrokerInternalQueryConfig.class)), BrokerInternalQueryConfig.class);
    }

    @Test
    public void testDefaultBehavior() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.install((Module)new ConfigModule());
                binder.install((Module)new DruidGuiceExtensions());
                JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.internal.query.config", BrokerInternalQueryConfig.class);
            }

            @Provides
            @LazySingleton
            public ObjectMapper jsonMapper() {
                return new DefaultObjectMapper();
            }
        }});
        BrokerInternalQueryConfig config = (BrokerInternalQueryConfig)injector.getInstance(BrokerInternalQueryConfig.class);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)config.getContext());
    }
}

