/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.cache;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.SequenceInputStreamResponseHandler;
import org.apache.druid.query.lookup.LookupsState;
import org.apache.druid.server.http.HostAndPortWithScheme;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManagerConfig;
import org.apache.druid.server.lookup.cache.LookupExtractorFactoryMapContainer;
import org.apache.druid.server.lookup.cache.LookupNodeDiscovery;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class LookupCoordinatorManager {
    public static final String OLD_LOOKUP_CONFIG_KEY = "lookups";
    public static final String LOOKUP_CONFIG_KEY = "lookupsConfig";
    public static final String LOOKUP_LISTEN_ANNOUNCE_KEY = "lookups";
    private static final String LOOKUP_BASE_REQUEST_PATH = "/druid/listen/v1/lookups";
    private static final String LOOKUP_UPDATE_REQUEST_PATH = "/druid/listen/v1/lookups/updates";
    private static final TypeReference<LookupsState<LookupExtractorFactoryMapContainer>> LOOKUPS_STATE_TYPE_REFERENCE = new TypeReference<LookupsState<LookupExtractorFactoryMapContainer>>(){};
    private static final EmittingLogger LOG = new EmittingLogger(LookupCoordinatorManager.class);
    private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
    private LookupNodeDiscovery lookupNodeDiscovery;
    private final JacksonConfigManager configManager;
    private final LookupCoordinatorManagerConfig lookupCoordinatorManagerConfig;
    private final LookupsCommunicator lookupsCommunicator;
    @VisibleForTesting
    final AtomicReference<Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>>> knownOldState = new AtomicReference<ImmutableMap>(ImmutableMap.of());
    private AtomicReference<Map<String, Map<String, LookupExtractorFactoryMapContainer>>> lookupMapConfigRef;
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private ListeningScheduledExecutorService executorService;
    private ListenableScheduledFuture<?> backgroundManagerFuture;
    private CountDownLatch backgroundManagerExitedLatch;

    @Inject
    public LookupCoordinatorManager(@EscalatedGlobal HttpClient httpClient, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, @Smile ObjectMapper smileMapper, JacksonConfigManager configManager, LookupCoordinatorManagerConfig lookupCoordinatorManagerConfig) {
        this(druidNodeDiscoveryProvider, configManager, lookupCoordinatorManagerConfig, new LookupsCommunicator(httpClient, lookupCoordinatorManagerConfig, smileMapper), null);
    }

    @VisibleForTesting
    LookupCoordinatorManager(DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, JacksonConfigManager configManager, LookupCoordinatorManagerConfig lookupCoordinatorManagerConfig, LookupsCommunicator lookupsCommunicator, LookupNodeDiscovery lookupNodeDiscovery) {
        this.druidNodeDiscoveryProvider = druidNodeDiscoveryProvider;
        this.configManager = configManager;
        this.lookupCoordinatorManagerConfig = lookupCoordinatorManagerConfig;
        this.lookupsCommunicator = lookupsCommunicator;
        this.lookupNodeDiscovery = lookupNodeDiscovery;
    }

    public boolean updateLookup(String tier, String lookupName, LookupExtractorFactoryMapContainer spec, AuditInfo auditInfo) {
        return this.updateLookups((Map<String, Map<String, LookupExtractorFactoryMapContainer>>)ImmutableMap.of((Object)tier, (Object)ImmutableMap.of((Object)lookupName, (Object)spec)), auditInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateLookups(Map<String, Map<String, LookupExtractorFactoryMapContainer>> updateSpec, AuditInfo auditInfo) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(5L, TimeUnit.SECONDS), (Object)"not started");
        if (updateSpec.isEmpty() && this.lookupMapConfigRef.get() != null) {
            return true;
        }
        for (Map.Entry<String, Map<String, LookupExtractorFactoryMapContainer>> tierEntry : updateSpec.entrySet()) {
            for (Map.Entry<String, LookupExtractorFactoryMapContainer> e : tierEntry.getValue().entrySet()) {
                Preconditions.checkNotNull((Object)e.getValue().getVersion(), (String)"lookup [%s]:[%s] does not have version.", (Object[])new Object[]{tierEntry.getKey(), e.getKey()});
            }
        }
        LookupCoordinatorManager lookupCoordinatorManager = this;
        synchronized (lookupCoordinatorManager) {
            Map<String, Map<String, LookupExtractorFactoryMapContainer>> updatedSpec;
            Map<String, Map<String, LookupExtractorFactoryMapContainer>> priorSpec = this.getKnownLookups();
            if (priorSpec == null && !updateSpec.isEmpty()) {
                throw new ISE("Not initialized. If this is the first lookup, post an empty map to initialize", new Object[0]);
            }
            if (priorSpec == null) {
                updatedSpec = updateSpec;
            } else {
                updatedSpec = new HashMap<String, Map<String, LookupExtractorFactoryMapContainer>>(priorSpec);
                for (Map.Entry<String, Map<String, LookupExtractorFactoryMapContainer>> tierEntry : updateSpec.entrySet()) {
                    String tier = tierEntry.getKey();
                    Map<String, LookupExtractorFactoryMapContainer> updateTierSpec = tierEntry.getValue();
                    Map<String, LookupExtractorFactoryMapContainer> priorTierSpec = priorSpec.get(tier);
                    if (priorTierSpec == null) {
                        updatedSpec.put(tier, updateTierSpec);
                        continue;
                    }
                    HashMap<String, LookupExtractorFactoryMapContainer> updatedTierSpec = new HashMap<String, LookupExtractorFactoryMapContainer>(priorTierSpec);
                    for (Map.Entry<String, LookupExtractorFactoryMapContainer> e : updateTierSpec.entrySet()) {
                        if (!updatedTierSpec.containsKey(e.getKey()) || e.getValue().replaces((LookupExtractorFactoryMapContainer)updatedTierSpec.get(e.getKey()))) continue;
                        throw new IAE("given update for lookup [%s]:[%s] can't replace existing spec [%s].", new Object[]{tier, e.getKey(), updatedTierSpec.get(e.getKey())});
                    }
                    updatedTierSpec.putAll(updateTierSpec);
                    updatedSpec.put(tier, updatedTierSpec);
                }
            }
            return this.configManager.set(LOOKUP_CONFIG_KEY, updatedSpec, auditInfo).isOk();
        }
    }

    public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(5L, TimeUnit.SECONDS), (Object)"not started");
        return this.lookupMapConfigRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTier(String tier, AuditInfo auditInfo) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(5L, TimeUnit.SECONDS), (Object)"not started");
        LookupCoordinatorManager lookupCoordinatorManager = this;
        synchronized (lookupCoordinatorManager) {
            Map<String, Map<String, LookupExtractorFactoryMapContainer>> priorSpec = this.getKnownLookups();
            if (priorSpec == null) {
                LOG.warn("Requested delete tier [%s]. But no lookups exist!", new Object[]{tier});
                return false;
            }
            HashMap<String, Map<String, LookupExtractorFactoryMapContainer>> updateSpec = new HashMap<String, Map<String, LookupExtractorFactoryMapContainer>>(priorSpec);
            if (updateSpec.remove(tier) == null) {
                LOG.warn("Requested delete of tier [%s] that does not exist!", new Object[]{tier});
                return false;
            }
            return this.configManager.set(LOOKUP_CONFIG_KEY, updateSpec, auditInfo).isOk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteLookup(String tier, String lookup, AuditInfo auditInfo) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(5L, TimeUnit.SECONDS), (Object)"not started");
        LookupCoordinatorManager lookupCoordinatorManager = this;
        synchronized (lookupCoordinatorManager) {
            Map<String, Map<String, LookupExtractorFactoryMapContainer>> priorSpec = this.getKnownLookups();
            if (priorSpec == null) {
                LOG.warn("Requested delete lookup [%s]/[%s]. But no lookups exist!", new Object[]{tier, lookup});
                return false;
            }
            HashMap<String, Map<String, LookupExtractorFactoryMapContainer>> updateSpec = new HashMap<String, Map<String, LookupExtractorFactoryMapContainer>>(priorSpec);
            Map priorTierSpec = (Map)updateSpec.get(tier);
            if (priorTierSpec == null) {
                LOG.warn("Requested delete of lookup [%s]/[%s] but tier does not exist!", new Object[]{tier, lookup});
                return false;
            }
            if (!priorTierSpec.containsKey(lookup)) {
                LOG.warn("Requested delete of lookup [%s]/[%s] but lookup does not exist!", new Object[]{tier, lookup});
                return false;
            }
            HashMap updateTierSpec = new HashMap(priorTierSpec);
            updateTierSpec.remove(lookup);
            if (updateTierSpec.isEmpty()) {
                updateSpec.remove(tier);
            } else {
                updateSpec.put(tier, updateTierSpec);
            }
            return this.configManager.set(LOOKUP_CONFIG_KEY, updateSpec, auditInfo).isOk();
        }
    }

    public Set<String> discoverTiers() {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(5L, TimeUnit.SECONDS), (Object)"not started");
        return this.lookupNodeDiscovery.getAllTiers();
    }

    public Collection<HostAndPort> discoverNodesInTier(String tier) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(5L, TimeUnit.SECONDS), (Object)"not started");
        return Collections2.transform(this.lookupNodeDiscovery.getNodesInTier(tier), (Function)new Function<HostAndPortWithScheme, HostAndPort>(){

            public HostAndPort apply(HostAndPortWithScheme input) {
                return input.getHostAndPort();
            }
        });
    }

    public Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>> getLastKnownLookupsStateOnNodes() {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(5L, TimeUnit.SECONDS), (Object)"not started");
        return this.knownOldState.get();
    }

    @Nullable
    public LookupExtractorFactoryMapContainer getLookup(String tier, String lookupName) {
        Map<String, Map<String, LookupExtractorFactoryMapContainer>> prior = this.getKnownLookups();
        if (prior == null) {
            LOG.warn("Requested tier [%s] lookupName [%s]. But no lookups exist!", new Object[]{tier, lookupName});
            return null;
        }
        Map<String, LookupExtractorFactoryMapContainer> tierLookups = prior.get(tier);
        if (tierLookups == null) {
            LOG.warn("Tier [%s] does not exist", new Object[]{tier});
            return null;
        }
        return tierLookups.get(lookupName);
    }

    public boolean isStarted() {
        return this.lifecycleLock.isStarted();
    }

    @VisibleForTesting
    boolean awaitStarted(long waitTimeMs) {
        return this.lifecycleLock.awaitStarted(waitTimeMs, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LifecycleLock lifecycleLock = this.lifecycleLock;
        synchronized (lifecycleLock) {
            if (!this.lifecycleLock.canStart()) {
                throw new ISE("LookupCoordinatorManager can't start.", new Object[0]);
            }
            try {
                LOG.debug("Starting.", new Object[0]);
                if (this.lookupNodeDiscovery == null) {
                    this.lookupNodeDiscovery = new LookupNodeDiscovery(this.druidNodeDiscoveryProvider);
                }
                if (this.executorService != null && !this.executorService.awaitTermination(this.lookupCoordinatorManagerConfig.getHostTimeout().getMillis() * 10L, TimeUnit.MILLISECONDS)) {
                    throw new ISE("LookupCoordinatorManager executor from last start() hasn't finished. Failed to Start.", new Object[0]);
                }
                this.executorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(this.lookupCoordinatorManagerConfig.getThreadPoolSize(), Execs.makeThreadFactory((String)"LookupCoordinatorManager--%s")));
                this.initializeLookupsConfigWatcher();
                this.backgroundManagerExitedLatch = new CountDownLatch(1);
                this.backgroundManagerFuture = this.executorService.scheduleWithFixedDelay(this::lookupManagementLoop, this.lookupCoordinatorManagerConfig.getInitialDelay(), this.lookupCoordinatorManagerConfig.getPeriod(), TimeUnit.MILLISECONDS);
                Futures.addCallback(this.backgroundManagerFuture, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(@Nullable Object result) {
                        LookupCoordinatorManager.this.backgroundManagerExitedLatch.countDown();
                        LOG.debug("Exited background lookup manager", new Object[0]);
                    }

                    public void onFailure(Throwable t) {
                        LookupCoordinatorManager.this.backgroundManagerExitedLatch.countDown();
                        if (LookupCoordinatorManager.this.backgroundManagerFuture.isCancelled()) {
                            LOG.debug("Exited background lookup manager due to cancellation.", new Object[0]);
                        } else {
                            LOG.makeAlert(t, "Background lookup manager exited with error!", new Object[0]).emit();
                        }
                    }
                });
                LOG.debug("Started", new Object[0]);
            }
            catch (Exception ex) {
                LOG.makeAlert((Throwable)ex, "Got Exception while start()", new Object[0]).emit();
            }
            finally {
                this.lifecycleLock.started();
                this.lifecycleLock.exitStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LifecycleLock lifecycleLock = this.lifecycleLock;
        synchronized (lifecycleLock) {
            if (!this.lifecycleLock.canStop()) {
                throw new ISE("LookupCoordinatorManager can't stop.", new Object[0]);
            }
            try {
                LOG.debug("Stopping", new Object[0]);
                if (this.backgroundManagerFuture != null && !this.backgroundManagerFuture.cancel(true)) {
                    LOG.warn("Background lookup manager thread could not be cancelled", new Object[0]);
                }
                if (this.executorService != null) {
                    this.executorService.shutdownNow();
                }
                LOG.debug("Stopped", new Object[0]);
            }
            catch (Exception ex) {
                LOG.makeAlert((Throwable)ex, "Got Exception while stop()", new Object[0]).emit();
            }
            finally {
                this.lifecycleLock.exitStopAndReset();
            }
        }
    }

    private void initializeLookupsConfigWatcher() {
        Map oldLookups;
        this.lookupMapConfigRef = this.configManager.watch(LOOKUP_CONFIG_KEY, (TypeReference)new TypeReference<Map<String, Map<String, LookupExtractorFactoryMapContainer>>>(){}, null);
        if (this.lookupMapConfigRef.get() == null && (oldLookups = (Map)this.configManager.watch("lookups", (TypeReference)new TypeReference<Map<String, Map<String, Map<String, Object>>>>(){}, null).get()) != null) {
            HashMap converted = new HashMap();
            oldLookups.forEach((tier, oldTierLookups) -> {
                if (oldTierLookups != null && !oldTierLookups.isEmpty()) {
                    converted.put(tier, this.convertTierLookups((Map<String, Map<String, Object>>)oldTierLookups));
                }
            });
            this.configManager.set(LOOKUP_CONFIG_KEY, converted, new AuditInfo("autoConversion", "autoConversion", "127.0.0.1"));
        }
    }

    private Map<String, LookupExtractorFactoryMapContainer> convertTierLookups(Map<String, Map<String, Object>> oldTierLookups) {
        HashMap<String, LookupExtractorFactoryMapContainer> convertedTierLookups = new HashMap<String, LookupExtractorFactoryMapContainer>();
        oldTierLookups.forEach((lookup, lookupExtractorFactory) -> convertedTierLookups.put((String)lookup, new LookupExtractorFactoryMapContainer(null, (Map<String, Object>)lookupExtractorFactory)));
        return convertedTierLookups;
    }

    @VisibleForTesting
    void lookupManagementLoop() {
        if (Thread.currentThread().isInterrupted() || !this.lifecycleLock.awaitStarted(15L, TimeUnit.SECONDS)) {
            LOG.info("Not updating lookups because process was interrupted or not finished starting yet.", new Object[0]);
            return;
        }
        Map<String, Map<String, LookupExtractorFactoryMapContainer>> allLookupTiers = this.lookupMapConfigRef.get();
        if (allLookupTiers == null) {
            LOG.info("Not updating lookups because no data exists", new Object[0]);
            return;
        }
        LOG.debug("Starting lookup sync for on all nodes.", new Object[0]);
        try {
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
            Set<String> discoveredLookupTiers = this.lookupNodeDiscovery.getAllTiers();
            for (String tierInDB : allLookupTiers.keySet()) {
                if (discoveredLookupTiers.contains(tierInDB) || allLookupTiers.getOrDefault(tierInDB, (Map<String, LookupExtractorFactoryMapContainer>)ImmutableMap.of()).isEmpty()) continue;
                LOG.warn("Found lookups for tier [%s] in DB, but no nodes discovered for it", new Object[]{tierInDB});
            }
            for (String tier : discoveredLookupTiers) {
                LOG.debug("Starting lookup mgmt for tier [%s].", new Object[]{tier});
                Map<String, LookupExtractorFactoryMapContainer> tierLookups = allLookupTiers.getOrDefault(tier, (Map<String, LookupExtractorFactoryMapContainer>)ImmutableMap.of());
                for (HostAndPortWithScheme node : this.lookupNodeDiscovery.getNodesInTier(tier)) {
                    LOG.debug("Starting lookup mgmt for tier [%s] and host [%s:%s:%s].", new Object[]{tier, node.getScheme(), node.getHostText(), node.getPort()});
                    futures.add(this.executorService.submit(() -> {
                        try {
                            return new AbstractMap.SimpleImmutableEntry<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>>(node.getHostAndPort(), this.doLookupManagementOnNode(node, tierLookups));
                        }
                        catch (InterruptedException ex) {
                            LOG.warn((Throwable)ex, "lookup management on node [%s:%s:%s] interrupted.", new Object[]{node.getScheme(), node.getHostText(), node.getPort()});
                            return null;
                        }
                        catch (Exception ex) {
                            LOG.makeAlert((Throwable)ex, "Failed to finish lookup management on node [%s:%s:%s]", new Object[]{node.getScheme(), node.getHostText(), node.getPort()}).emit();
                            return null;
                        }
                    }));
                }
            }
            ListenableFuture allFuture = Futures.allAsList(futures);
            try {
                ImmutableMap.Builder stateBuilder = ImmutableMap.builder();
                ((List)allFuture.get(this.lookupCoordinatorManagerConfig.getAllHostTimeout().getMillis(), TimeUnit.MILLISECONDS)).stream().filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableMap.Builder)stateBuilder).put(arg_0));
                this.knownOldState.set((Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>>)stateBuilder.build());
            }
            catch (InterruptedException ex) {
                allFuture.cancel(true);
                Thread.currentThread().interrupt();
                throw ex;
            }
            catch (Exception ex) {
                allFuture.cancel(true);
                throw ex;
            }
        }
        catch (Exception ex) {
            LOG.makeAlert((Throwable)ex, "Failed to finish lookup management loop.", new Object[0]).emit();
        }
        LOG.debug("Finished lookup sync for on all nodes.", new Object[0]);
    }

    private LookupsState<LookupExtractorFactoryMapContainer> doLookupManagementOnNode(HostAndPortWithScheme node, Map<String, LookupExtractorFactoryMapContainer> nodeTierLookupsToBe) throws IOException, InterruptedException, ExecutionException {
        LOG.debug("Starting lookup sync for node [%s].", new Object[]{node});
        LookupsState<LookupExtractorFactoryMapContainer> currLookupsStateOnNode = this.lookupsCommunicator.getLookupStateForNode(node);
        LOG.debug("Received lookups state from node [%s].", new Object[]{node});
        Map<String, LookupExtractorFactoryMapContainer> toLoad = this.getToBeLoadedOnNode(currLookupsStateOnNode, nodeTierLookupsToBe);
        Set<String> toDrop = this.getToBeDroppedFromNode(currLookupsStateOnNode, nodeTierLookupsToBe);
        if (!toLoad.isEmpty() || !toDrop.isEmpty()) {
            currLookupsStateOnNode = this.lookupsCommunicator.updateNode(node, (LookupsState<LookupExtractorFactoryMapContainer>)new LookupsState(null, toLoad, toDrop));
            LOG.debug("Sent lookup toAdd[%s] and toDrop[%s] updates to node [%s].", new Object[]{toLoad.keySet(), toDrop, node});
        }
        LOG.debug("Finished lookup sync for node [%s].", new Object[]{node});
        return currLookupsStateOnNode;
    }

    @VisibleForTesting
    Map<String, LookupExtractorFactoryMapContainer> getToBeLoadedOnNode(LookupsState<LookupExtractorFactoryMapContainer> currLookupsStateOnNode, Map<String, LookupExtractorFactoryMapContainer> nodeTierLookupsToBe) {
        HashMap<String, LookupExtractorFactoryMapContainer> toLoad = new HashMap<String, LookupExtractorFactoryMapContainer>();
        for (Map.Entry<String, LookupExtractorFactoryMapContainer> e : nodeTierLookupsToBe.entrySet()) {
            String name = e.getKey();
            LookupExtractorFactoryMapContainer lookupToBe = e.getValue();
            LookupExtractorFactoryMapContainer current = (LookupExtractorFactoryMapContainer)currLookupsStateOnNode.getToLoad().get(name);
            if (current == null) {
                current = (LookupExtractorFactoryMapContainer)currLookupsStateOnNode.getCurrent().get(name);
            }
            if (current != null && !currLookupsStateOnNode.getToDrop().contains(name) && !lookupToBe.replaces(current)) continue;
            toLoad.put(name, lookupToBe);
        }
        return toLoad;
    }

    @VisibleForTesting
    Set<String> getToBeDroppedFromNode(LookupsState<LookupExtractorFactoryMapContainer> currLookupsStateOnNode, Map<String, LookupExtractorFactoryMapContainer> nodeTierLookupsToBe) {
        Sets.SetView toDrop = new HashSet();
        toDrop.addAll(currLookupsStateOnNode.getCurrent().keySet());
        toDrop.addAll(currLookupsStateOnNode.getToLoad().keySet());
        toDrop = Sets.difference(toDrop, (Set)currLookupsStateOnNode.getToDrop());
        toDrop = Sets.difference((Set)toDrop, nodeTierLookupsToBe.keySet());
        return toDrop;
    }

    static URL getLookupsURL(HostAndPortWithScheme druidNode) throws MalformedURLException {
        return new URL(druidNode.getScheme(), druidNode.getHostText(), druidNode.getPortOrDefault(-1), LOOKUP_BASE_REQUEST_PATH);
    }

    static URL getLookupsUpdateURL(HostAndPortWithScheme druidNode) throws MalformedURLException {
        return new URL(druidNode.getScheme(), druidNode.getHostText(), druidNode.getPortOrDefault(-1), LOOKUP_UPDATE_REQUEST_PATH);
    }

    private static boolean httpStatusIsSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    @VisibleForTesting
    boolean backgroundManagerIsRunning() {
        ListenableScheduledFuture<?> backgroundManagerFuture = this.backgroundManagerFuture;
        return backgroundManagerFuture != null && !backgroundManagerFuture.isDone();
    }

    @VisibleForTesting
    boolean waitForBackgroundTermination(long timeout) throws InterruptedException {
        return this.backgroundManagerExitedLatch.await(timeout, TimeUnit.MILLISECONDS);
    }

    static /* synthetic */ boolean access$300(int x0) {
        return LookupCoordinatorManager.httpStatusIsSuccess(x0);
    }

    static /* synthetic */ TypeReference access$400() {
        return LOOKUPS_STATE_TYPE_REFERENCE;
    }

    @VisibleForTesting
    public static class LookupsCommunicator {
        private final HttpClient httpClient;
        private final LookupCoordinatorManagerConfig lookupCoordinatorManagerConfig;
        private final ObjectMapper smileMapper;

        public LookupsCommunicator(HttpClient httpClient, LookupCoordinatorManagerConfig lookupCoordinatorManagerConfig, ObjectMapper smileMapper) {
            this.httpClient = httpClient;
            this.lookupCoordinatorManagerConfig = lookupCoordinatorManagerConfig;
            this.smileMapper = smileMapper;
        }

        /*
         * Exception decompiling
         */
        public LookupsState<LookupExtractorFactoryMapContainer> updateNode(HostAndPortWithScheme node, LookupsState<LookupExtractorFactoryMapContainer> lookupsUpdate) throws IOException, InterruptedException, ExecutionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        public LookupsState<LookupExtractorFactoryMapContainer> getLookupStateForNode(HostAndPortWithScheme node) throws IOException, InterruptedException, ExecutionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @VisibleForTesting
        HttpResponseHandler<InputStream, InputStream> makeResponseHandler(final AtomicInteger returnCode, final AtomicReference<String> reasonString) {
            return new SequenceInputStreamResponseHandler(){

                public ClientResponse<InputStream> handleResponse(HttpResponse response, HttpResponseHandler.TrafficCop trafficCop) {
                    returnCode.set(response.getStatus().getCode());
                    reasonString.set(response.getStatus().getReasonPhrase());
                    return super.handleResponse(response, trafficCop);
                }
            };
        }
    }
}

