/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Set;
import org.apache.druid.server.coordinator.CostBalancerStrategy;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.cost.ClusterCostCache;
import org.apache.druid.timeline.DataSegment;

public class CachingCostBalancerStrategy
extends CostBalancerStrategy {
    private final ClusterCostCache clusterCostCache;

    public CachingCostBalancerStrategy(ClusterCostCache clusterCostCache, ListeningExecutorService exec) {
        super(exec);
        this.clusterCostCache = (ClusterCostCache)Preconditions.checkNotNull((Object)clusterCostCache);
    }

    @Override
    protected double computeCost(DataSegment proposalSegment, ServerHolder server, boolean includeCurrentServer) {
        long proposalSegmentSize = proposalSegment.getSize();
        if (!includeCurrentServer && server.isServingSegment(proposalSegment)) {
            return Double.POSITIVE_INFINITY;
        }
        if (proposalSegmentSize > server.getAvailableSize() || server.isLoadingSegment(proposalSegment)) {
            return Double.POSITIVE_INFINITY;
        }
        String serverName = server.getServer().getName();
        double cost = this.clusterCostCache.computeCost(serverName, proposalSegment);
        cost += this.costCacheForLoadingSegments(server).computeCost(serverName, proposalSegment);
        if (server.getAvailableSize() <= 0L) {
            return Double.POSITIVE_INFINITY;
        }
        return cost * (double)(server.getMaxSize() / server.getAvailableSize());
    }

    private ClusterCostCache costCacheForLoadingSegments(ServerHolder server) {
        Set<DataSegment> loadingSegments = server.getPeon().getSegmentsToLoad();
        return ClusterCostCache.builder((Map<String, Set<DataSegment>>)ImmutableMap.of((Object)server.getServer().getName(), loadingSegments)).build();
    }
}

